/*
 * Decompiled with CFR 0.152.
 */
package com.airbnb.epoxy;

import android.support.annotation.VisibleForTesting;
import com.airbnb.epoxy.BaseEpoxyAdapter;
import com.airbnb.epoxy.EpoxyModel;
import com.airbnb.epoxy.HiddenEpoxyModel;
import java.util.HashMap;
import java.util.Map;

class ViewTypeManager {
    private static final Map<Class, Integer> VIEW_TYPE_MAP = new HashMap<Class, Integer>();
    private EpoxyModel<?> lastModelForViewTypeLookup;

    ViewTypeManager() {
    }

    @VisibleForTesting
    void resetMapForTesting() {
        VIEW_TYPE_MAP.clear();
    }

    int getViewType(EpoxyModel<?> model) {
        this.lastModelForViewTypeLookup = model;
        return ViewTypeManager.getViewTypeInternal(model);
    }

    private static int getViewTypeInternal(EpoxyModel<?> model) {
        int defaultViewType = model.getViewType();
        if (defaultViewType != 0) {
            return defaultViewType;
        }
        Class<?> modelClass = model.getClass();
        Integer viewType = VIEW_TYPE_MAP.get(modelClass);
        if (viewType == null) {
            viewType = -VIEW_TYPE_MAP.size() - 1;
            VIEW_TYPE_MAP.put(modelClass, viewType);
        }
        return viewType;
    }

    EpoxyModel<?> getModelForViewType(BaseEpoxyAdapter adapter, int viewType) {
        if (this.lastModelForViewTypeLookup != null && ViewTypeManager.getViewTypeInternal(this.lastModelForViewTypeLookup) == viewType) {
            return this.lastModelForViewTypeLookup;
        }
        adapter.onExceptionSwallowed(new IllegalStateException("Last model did not match expected view type"));
        for (EpoxyModel<?> model : adapter.getCurrentModels()) {
            if (ViewTypeManager.getViewTypeInternal(model) != viewType) continue;
            return model;
        }
        HiddenEpoxyModel hiddenEpoxyModel = new HiddenEpoxyModel();
        if (viewType == hiddenEpoxyModel.getViewType()) {
            return hiddenEpoxyModel;
        }
        throw new IllegalStateException("Could not find model for view type: " + viewType);
    }
}

