/*
 * Decompiled with CFR 0.152.
 */
package com.airbnb.epoxy;

import android.support.annotation.Nullable;
import android.support.v7.widget.RecyclerView;
import android.util.Log;

public class EpoxyDiffLogger
extends RecyclerView.AdapterDataObserver {
    private final String tag;

    public EpoxyDiffLogger(String tag) {
        this.tag = tag;
    }

    public void onItemRangeChanged(int positionStart, int itemCount) {
        Log.d((String)this.tag, (String)("Item range changed. Start: " + positionStart + " Count: " + itemCount));
    }

    public void onItemRangeChanged(int positionStart, int itemCount, @Nullable Object payload) {
        if (payload == null) {
            this.onItemRangeChanged(positionStart, itemCount);
        } else {
            Log.d((String)this.tag, (String)("Item range changed with payloads. Start: " + positionStart + " Count: " + itemCount));
        }
    }

    public void onItemRangeInserted(int positionStart, int itemCount) {
        Log.d((String)this.tag, (String)("Item range inserted. Start: " + positionStart + " Count: " + itemCount));
    }

    public void onItemRangeRemoved(int positionStart, int itemCount) {
        Log.d((String)this.tag, (String)("Item range removed. Start: " + positionStart + " Count: " + itemCount));
    }

    public void onItemRangeMoved(int fromPosition, int toPosition, int itemCount) {
        Log.d((String)this.tag, (String)("Item moved. From: " + fromPosition + " To: " + toPosition));
    }
}

