/*
 * Decompiled with CFR 0.152.
 */
package com.airbnb.epoxy;

import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.support.annotation.Nullable;
import android.support.v7.widget.GridLayoutManager;
import android.support.v7.widget.RecyclerView;
import com.airbnb.epoxy.ControllerHelper;
import com.airbnb.epoxy.ControllerHelperLookup;
import com.airbnb.epoxy.ControllerModelList;
import com.airbnb.epoxy.DebugTimer;
import com.airbnb.epoxy.EpoxyControllerAdapter;
import com.airbnb.epoxy.EpoxyDiffLogger;
import com.airbnb.epoxy.EpoxyModel;
import com.airbnb.epoxy.EpoxyViewHolder;
import com.airbnb.epoxy.IllegalEpoxyUsage;
import com.airbnb.epoxy.NoOpTimer;
import com.airbnb.epoxy.Timer;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;

public abstract class EpoxyController {
    private static final Timer NO_OP_TIMER = new NoOpTimer();
    private static final int DELAY_TO_CHECK_ADAPTER_COUNT_MS = 3000;
    private final EpoxyControllerAdapter adapter = new EpoxyControllerAdapter(this);
    private final ControllerHelper helper = ControllerHelperLookup.getHelperForController(this);
    private final Handler handler = new Handler(Looper.getMainLooper());
    private final List<Interceptor> interceptors = new ArrayList<Interceptor>();
    private ControllerModelList modelsBeingBuilt;
    private boolean filterDuplicates;
    private Timer timer = NO_OP_TIMER;
    private EpoxyDiffLogger debugObserver;
    private boolean hasBuiltModelsEver;
    private boolean hasPendingModelBuildRequest;
    private List<ModelInterceptorCallback> modelInterceptorCallbacks;
    private int recyclerViewAttachCount = 0;
    private EpoxyModel<?> stagedModel;
    private final Runnable buildModelsRunnable = new Runnable(){

        @Override
        public void run() {
            EpoxyController.this.dispatchModelBuild();
        }
    };

    public void requestModelBuild() {
        if (this.isBuildingModels()) {
            throw new IllegalEpoxyUsage("Cannot call `requestModelBuild` from inside `buildModels`");
        }
        if (this.hasBuiltModelsEver) {
            this.requestDelayedModelBuild(0);
        } else {
            this.cancelPendingModelBuild();
            this.dispatchModelBuild();
        }
    }

    public void requestDelayedModelBuild(int delayMs) {
        if (this.isBuildingModels()) {
            throw new IllegalEpoxyUsage("Cannot call `requestDelayedModelBuild` from inside `buildModels`");
        }
        if (!this.hasPendingModelBuildRequest) {
            this.hasPendingModelBuildRequest = true;
            this.handler.postDelayed(this.buildModelsRunnable, (long)delayMs);
        }
    }

    public void cancelPendingModelBuild() {
        this.hasPendingModelBuildRequest = false;
        this.handler.removeCallbacks(this.buildModelsRunnable);
    }

    private void dispatchModelBuild() {
        this.hasPendingModelBuildRequest = false;
        this.helper.resetAutoModels();
        this.modelsBeingBuilt = new ControllerModelList(this.getExpectedModelCount());
        this.timer.start();
        this.buildModels();
        this.addCurrentlyStagedModelIfExists();
        this.timer.stop("Models built");
        this.runInterceptors();
        this.filterDuplicatesIfNeeded(this.modelsBeingBuilt);
        this.modelsBeingBuilt.freeze();
        this.timer.start();
        this.adapter.setModels(this.modelsBeingBuilt);
        this.timer.stop("Models diffed");
        this.modelsBeingBuilt = null;
        this.hasBuiltModelsEver = true;
    }

    private int getExpectedModelCount() {
        int currentModelCount = this.adapter.getItemCount();
        return currentModelCount != 0 ? currentModelCount : 25;
    }

    protected abstract void buildModels();

    int getFirstIndexOfModelInBuildingList(EpoxyModel<?> model) {
        int size = this.modelsBeingBuilt.size();
        for (int i = 0; i < size; ++i) {
            if (this.modelsBeingBuilt.get(i) != model) continue;
            return i;
        }
        return -1;
    }

    boolean isModelAddedMultipleTimes(EpoxyModel<?> model) {
        int modelCount = 0;
        int size = this.modelsBeingBuilt.size();
        for (int i = 0; i < size; ++i) {
            if (this.modelsBeingBuilt.get(i) != model) continue;
            ++modelCount;
        }
        return modelCount > 1;
    }

    void addAfterInterceptorCallback(ModelInterceptorCallback callback) {
        if (!this.isBuildingModels()) {
            throw new IllegalEpoxyUsage("Can only call when building models");
        }
        if (this.modelInterceptorCallbacks == null) {
            this.modelInterceptorCallbacks = new ArrayList<ModelInterceptorCallback>();
        }
        this.modelInterceptorCallbacks.add(callback);
    }

    private void runInterceptors() {
        if (!this.interceptors.isEmpty()) {
            if (this.modelInterceptorCallbacks != null) {
                for (ModelInterceptorCallback callback : this.modelInterceptorCallbacks) {
                    callback.onInterceptorsStarted(this);
                }
            }
            this.timer.start();
            for (Interceptor interceptor : this.interceptors) {
                interceptor.intercept(this.modelsBeingBuilt);
            }
            this.timer.stop("Interceptors executed");
            if (this.modelInterceptorCallbacks != null) {
                for (ModelInterceptorCallback callback : this.modelInterceptorCallbacks) {
                    callback.onInterceptorsFinished(this);
                }
                this.modelInterceptorCallbacks = null;
            }
        }
    }

    public void addInterceptor(Interceptor interceptor) {
        this.interceptors.add(interceptor);
    }

    public void removeInterceptor(Interceptor interceptor) {
        this.interceptors.remove(interceptor);
    }

    protected int getModelCountBuiltSoFar() {
        if (!this.isBuildingModels()) {
            throw new IllegalEpoxyUsage("Can only all this when inside the `buildModels` method");
        }
        return this.modelsBeingBuilt.size();
    }

    protected void add(EpoxyModel<?> model) {
        model.addTo(this);
    }

    protected void add(EpoxyModel<?> ... modelsToAdd) {
        this.modelsBeingBuilt.ensureCapacity(this.modelsBeingBuilt.size() + modelsToAdd.length);
        for (EpoxyModel<?> model : modelsToAdd) {
            model.addTo(this);
        }
    }

    protected void add(List<? extends EpoxyModel<?>> modelsToAdd) {
        this.modelsBeingBuilt.ensureCapacity(this.modelsBeingBuilt.size() + modelsToAdd.size());
        for (EpoxyModel<?> model : modelsToAdd) {
            model.addTo(this);
        }
    }

    void addInternal(EpoxyModel<?> modelToAdd) {
        if (!this.isBuildingModels()) {
            throw new IllegalEpoxyUsage("You can only add models inside the `buildModels` methods, and you cannot call `buildModels` directly. Call `requestModelBuild` instead");
        }
        if (modelToAdd.hasDefaultId()) {
            throw new IllegalEpoxyUsage("You must set an id on a model before adding it. Use the @AutoModel annotation if you want an id to be automatically generated for you.");
        }
        if (!modelToAdd.isShown()) {
            throw new IllegalEpoxyUsage("You cannot hide a model in an EpoxyController. Use `addIf` to conditionally add a model instead.");
        }
        this.clearModelFromStaging(modelToAdd);
        modelToAdd.controllerToStageTo = null;
        this.modelsBeingBuilt.add(modelToAdd);
    }

    void setStagedModel(EpoxyModel<?> model) {
        if (model != this.stagedModel) {
            this.addCurrentlyStagedModelIfExists();
        }
        this.stagedModel = model;
    }

    void addCurrentlyStagedModelIfExists() {
        if (this.stagedModel != null) {
            this.stagedModel.addTo(this);
        }
        this.stagedModel = null;
    }

    void clearModelFromStaging(EpoxyModel<?> model) {
        if (this.stagedModel != model) {
            this.addCurrentlyStagedModelIfExists();
        }
        this.stagedModel = null;
    }

    boolean isBuildingModels() {
        return this.modelsBeingBuilt != null;
    }

    private void filterDuplicatesIfNeeded(List<EpoxyModel<?>> models) {
        if (!this.filterDuplicates) {
            return;
        }
        this.timer.start();
        HashSet<Long> modelIds = new HashSet<Long>(models.size());
        ListIterator<EpoxyModel<?>> modelIterator = models.listIterator();
        while (modelIterator.hasNext()) {
            EpoxyModel<?> model = modelIterator.next();
            if (modelIds.add(model.id())) continue;
            int indexOfDuplicate = modelIterator.previousIndex();
            modelIterator.remove();
            int indexOfOriginal = this.findPositionOfDuplicate(models, model);
            EpoxyModel<?> originalModel = models.get(indexOfOriginal);
            if (indexOfDuplicate <= indexOfOriginal) {
                ++indexOfOriginal;
            }
            this.onExceptionSwallowed(new IllegalEpoxyUsage("Two models have the same ID. ID's must be unique!\nOriginal has position " + indexOfOriginal + ":\n" + originalModel + "\nDuplicate has position " + indexOfDuplicate + ":\n" + model));
        }
        this.timer.stop("Duplicates filtered");
    }

    private int findPositionOfDuplicate(List<EpoxyModel<?>> models, EpoxyModel<?> duplicateModel) {
        int size = models.size();
        for (int i = 0; i < size; ++i) {
            EpoxyModel<?> model = models.get(i);
            if (model.id() != duplicateModel.id()) continue;
            return i;
        }
        throw new IllegalArgumentException("No duplicates in list");
    }

    public void setFilterDuplicates(boolean filterDuplicates) {
        this.filterDuplicates = filterDuplicates;
    }

    public void setDebugLoggingEnabled(boolean enabled) {
        if (this.isBuildingModels()) {
            throw new IllegalEpoxyUsage("Debug logging should be enabled before models are built");
        }
        if (enabled) {
            this.timer = new DebugTimer(this.getClass().getSimpleName());
            this.debugObserver = new EpoxyDiffLogger(this.getClass().getSimpleName());
            this.adapter.registerAdapterDataObserver(this.debugObserver);
        } else {
            this.timer = NO_OP_TIMER;
            if (this.debugObserver != null) {
                this.adapter.unregisterAdapterDataObserver(this.debugObserver);
            }
        }
    }

    public void moveModel(int fromPosition, int toPosition) {
        if (this.isBuildingModels()) {
            throw new IllegalEpoxyUsage("Cannot call `moveModel` from inside `buildModels`");
        }
        this.adapter.moveModel(fromPosition, toPosition);
        this.requestDelayedModelBuild(500);
    }

    public EpoxyControllerAdapter getAdapter() {
        return this.adapter;
    }

    public void onSaveInstanceState(Bundle outState) {
        this.adapter.onSaveInstanceState(outState);
    }

    public void onRestoreInstanceState(@Nullable Bundle inState) {
        this.adapter.onRestoreInstanceState(inState);
    }

    public GridLayoutManager.SpanSizeLookup getSpanSizeLookup() {
        return this.adapter.getSpanSizeLookup();
    }

    public void setSpanCount(int spanCount) {
        this.adapter.setSpanCount(spanCount);
    }

    public int getSpanCount() {
        return this.adapter.getSpanCount();
    }

    public boolean isMultiSpan() {
        return this.adapter.isMultiSpan();
    }

    protected void onExceptionSwallowed(RuntimeException exception) {
    }

    void onAttachedToRecyclerViewInternal(RecyclerView recyclerView) {
        ++this.recyclerViewAttachCount;
        if (this.recyclerViewAttachCount > 1) {
            this.handler.postDelayed(new Runnable(){

                @Override
                public void run() {
                    if (EpoxyController.this.recyclerViewAttachCount > 1) {
                        EpoxyController.this.onExceptionSwallowed(new IllegalStateException("This EpoxyController had its adapter added to more than one ReyclerView. Epoxy does not support attaching an adapter to multiple RecyclerViews because saved state will not work properly. If you did not intend to attach your adapter to multiple RecyclerViews you may be leaking a reference to a previous RecyclerView. Make sure to remove the adapter from any previous RecyclerViews (eg if the adapter is reused in a Fragment across multiple onCreateView/onDestroyView cycles). See https://github.com/airbnb/epoxy/wiki/Avoiding-Memory-Leaks for more information."));
                    }
                }
            }, 3000L);
        }
        this.onAttachedToRecyclerView(recyclerView);
    }

    void onDetachedFromRecyclerViewInternal(RecyclerView recyclerView) {
        --this.recyclerViewAttachCount;
        this.onDetachedFromRecyclerView(recyclerView);
    }

    protected void onAttachedToRecyclerView(RecyclerView recyclerView) {
    }

    protected void onDetachedFromRecyclerView(RecyclerView recyclerView) {
    }

    protected void onModelBound(EpoxyViewHolder holder, EpoxyModel<?> boundModel, int position, @Nullable EpoxyModel<?> previouslyBoundModel) {
    }

    protected void onModelUnbound(EpoxyViewHolder holder, EpoxyModel<?> model) {
    }

    protected void onViewAttachedToWindow(EpoxyViewHolder holder, EpoxyModel<?> model) {
    }

    protected void onViewDetachedFromWindow(EpoxyViewHolder holder, EpoxyModel<?> model) {
    }

    public static interface Interceptor {
        public void intercept(List<EpoxyModel<?>> var1);
    }

    static interface ModelInterceptorCallback {
        public void onInterceptorsStarted(EpoxyController var1);

        public void onInterceptorsFinished(EpoxyController var1);
    }
}

