/*
 * Decompiled with CFR 0.152.
 */
package com.airbnb.epoxy;

import android.support.annotation.Nullable;
import android.support.v4.util.LongSparseArray;
import com.airbnb.epoxy.EpoxyModel;
import com.airbnb.epoxy.EpoxyViewHolder;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class BoundViewHolders
implements Iterable<EpoxyViewHolder> {
    private final LongSparseArray<EpoxyViewHolder> holders = new LongSparseArray();

    @Nullable
    public EpoxyViewHolder get(EpoxyViewHolder holder) {
        return (EpoxyViewHolder)((Object)this.holders.get(holder.getItemId()));
    }

    public void put(EpoxyViewHolder holder) {
        this.holders.put(holder.getItemId(), (Object)holder);
    }

    public void remove(EpoxyViewHolder holder) {
        this.holders.remove(holder.getItemId());
    }

    public int size() {
        return this.holders.size();
    }

    @Override
    public Iterator<EpoxyViewHolder> iterator() {
        return new HolderIterator();
    }

    @Nullable
    public EpoxyViewHolder getHolderForModel(EpoxyModel<?> model) {
        return (EpoxyViewHolder)((Object)this.holders.get(model.id()));
    }

    private class HolderIterator
    implements Iterator<EpoxyViewHolder> {
        private int position = 0;

        private HolderIterator() {
        }

        @Override
        public boolean hasNext() {
            return this.position < BoundViewHolders.this.holders.size();
        }

        @Override
        public EpoxyViewHolder next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            return (EpoxyViewHolder)((Object)BoundViewHolders.this.holders.valueAt(this.position++));
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

