/*
 * Decompiled with CFR 0.152.
 */
package com.airbnb.epoxy;

import android.content.Context;
import android.support.annotation.DimenRes;
import android.support.annotation.Dimension;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.Px;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.LinearSnapHelper;
import android.support.v7.widget.RecyclerView;
import android.support.v7.widget.SnapHelper;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.view.View;
import android.view.ViewGroup;
import com.airbnb.epoxy.EpoxyModel;
import com.airbnb.epoxy.EpoxyRecyclerView;
import com.airbnb.epoxy.ModelProp;
import com.airbnb.epoxy.ModelView;
import com.airbnb.epoxy.OnViewRecycled;
import com.airbnb.viewmodeladapter.R;
import java.util.List;

@ModelView(saveViewState=true, autoLayout=ModelView.Size.MATCH_WIDTH_WRAP_HEIGHT)
public class Carousel
extends EpoxyRecyclerView {
    public static final int NO_VALUE_SET = -1;
    private static SnapHelperFactory defaultGlobalSnapHelperFactory = new SnapHelperFactory(){

        @Override
        SnapHelper buildSnapHelper(Context context) {
            return new LinearSnapHelper();
        }
    };
    @Dimension(unit=0)
    private static int defaultSpacingBetweenItemsDp = 8;
    private float numViewsToShowOnScreen;

    public Carousel(Context context) {
        super(context);
    }

    public Carousel(Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
    }

    public Carousel(Context context, @Nullable AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
    }

    @Override
    protected void init() {
        SnapHelperFactory snapHelperFactory;
        super.init();
        int defaultSpacingDp = this.getDefaultSpacingBetweenItemsDp();
        if (defaultSpacingDp >= 0) {
            this.setItemSpacingDp(defaultSpacingDp);
            if (this.getPaddingLeft() == 0 && this.getPaddingRight() == 0 && this.getPaddingTop() == 0 && this.getPaddingBottom() == 0) {
                this.setPaddingDp(defaultSpacingDp);
            }
        }
        if ((snapHelperFactory = this.getSnapHelperFactory()) != null) {
            snapHelperFactory.buildSnapHelper(this.getContext()).attachToRecyclerView((RecyclerView)this);
        }
    }

    @Nullable
    protected SnapHelperFactory getSnapHelperFactory() {
        return defaultGlobalSnapHelperFactory;
    }

    protected void setDefaultGlobalSnapHelperFactory(@Nullable SnapHelperFactory factory) {
        defaultGlobalSnapHelperFactory = factory;
    }

    @ModelProp
    public void setHasFixedSize(boolean hasFixedSize) {
        super.setHasFixedSize(hasFixedSize);
    }

    @ModelProp(group="prefetch")
    public void setNumViewsToShowOnScreen(float viewCount) {
        this.numViewsToShowOnScreen = viewCount;
        this.setInitialPrefetchItemCount((int)Math.ceil(viewCount));
    }

    @ModelProp(group="prefetch")
    public void setInitialPrefetchItemCount(int numItemsToPrefetch) {
        if (numItemsToPrefetch < 0) {
            throw new IllegalStateException("numItemsToPrefetch must be greater than 0");
        }
        int prefetchCount = numItemsToPrefetch == 0 ? 2 : numItemsToPrefetch;
        RecyclerView.LayoutManager layoutManager = this.getLayoutManager();
        if (layoutManager instanceof LinearLayoutManager) {
            ((LinearLayoutManager)layoutManager).setInitialPrefetchItemCount(prefetchCount);
        }
    }

    public void onChildAttachedToWindow(View child) {
        if (this.numViewsToShowOnScreen > 0.0f) {
            ViewGroup.LayoutParams childLayoutParams = child.getLayoutParams();
            child.setTag(R.id.epoxy_recycler_view_child_initial_size_id, (Object)childLayoutParams.width);
            int itemSpacingPx = this.spacingDecorator.getPxBetweenItems();
            int spaceBetweenItems = 0;
            if (itemSpacingPx > 0) {
                spaceBetweenItems = (int)((float)itemSpacingPx * this.numViewsToShowOnScreen);
            }
            boolean isScrollingHorizontally = this.getLayoutManager().canScrollHorizontally();
            int itemSizeInScrollingDirection = (int)((float)(this.getSpaceForChildren(isScrollingHorizontally) - spaceBetweenItems) / this.numViewsToShowOnScreen);
            if (isScrollingHorizontally) {
                childLayoutParams.width = itemSizeInScrollingDirection;
            } else {
                childLayoutParams.height = itemSizeInScrollingDirection;
            }
        }
    }

    private int getSpaceForChildren(boolean horizontal) {
        if (horizontal) {
            return Carousel.getTotalWidthPx((View)this) - this.getPaddingLeft() - (this.getClipToPadding() ? this.getPaddingRight() : 0);
        }
        return Carousel.getTotalHeightPx((View)this) - this.getPaddingTop() - (this.getClipToPadding() ? this.getPaddingBottom() : 0);
    }

    @Px
    private static int getTotalWidthPx(View view) {
        if (view.getWidth() > 0) {
            return view.getWidth();
        }
        DisplayMetrics metrics = view.getContext().getResources().getDisplayMetrics();
        return metrics.widthPixels;
    }

    @Px
    private static int getTotalHeightPx(View view) {
        if (view.getHeight() > 0) {
            return view.getHeight();
        }
        DisplayMetrics metrics = view.getContext().getResources().getDisplayMetrics();
        return metrics.heightPixels;
    }

    public void onChildDetachedFromWindow(View child) {
        Object initialWidth = child.getTag(R.id.epoxy_recycler_view_child_initial_size_id);
        if (initialWidth instanceof Integer) {
            ViewGroup.LayoutParams params = child.getLayoutParams();
            params.width = (Integer)initialWidth;
            child.setTag(R.id.epoxy_recycler_view_child_initial_size_id, null);
        }
    }

    public static void setDefaultItemSpacingDp(@Dimension(unit=0) int dp) {
        defaultSpacingBetweenItemsDp = dp;
    }

    @Dimension(unit=0)
    protected int getDefaultSpacingBetweenItemsDp() {
        return defaultSpacingBetweenItemsDp;
    }

    @ModelProp(group="padding")
    public void setPaddingRes(@DimenRes int paddingRes) {
        int px = this.resToPx(paddingRes);
        this.setPadding(px, px, px, px);
        this.setItemSpacingPx(px);
    }

    @ModelProp(defaultValue="NO_VALUE_SET", group="padding")
    public void setPaddingDp(@Dimension(unit=0) int paddingDp) {
        int px = this.dpToPx(paddingDp != -1 ? paddingDp : this.getDefaultSpacingBetweenItemsDp());
        this.setPadding(px, px, px, px);
        this.setItemSpacingPx(px);
    }

    @Override
    @ModelProp
    public void setModels(List<? extends EpoxyModel<?>> models) {
        super.setModels(models);
    }

    @Override
    @OnViewRecycled
    public void clear() {
        super.clear();
    }

    public static abstract class SnapHelperFactory {
        @NonNull
        abstract SnapHelper buildSnapHelper(Context var1);
    }
}

