/*
 * Decompiled with CFR 0.152.
 */
package com.airbnb.epoxy;

import android.graphics.Canvas;
import android.support.v7.widget.RecyclerView;
import android.support.v7.widget.helper.ItemTouchHelper;
import android.view.View;
import com.airbnb.epoxy.EpoxyController;
import com.airbnb.epoxy.EpoxyDragCallback;
import com.airbnb.epoxy.EpoxyModel;
import com.airbnb.epoxy.EpoxyModelTouchCallback;
import com.airbnb.epoxy.EpoxySwipeCallback;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public abstract class EpoxyTouchHelper {
    public static DragBuilder initDragging(EpoxyController controller) {
        return new DragBuilder(controller);
    }

    public static SwipeBuilder initSwiping(RecyclerView recyclerView) {
        return new SwipeBuilder(recyclerView);
    }

    public static abstract class SwipeCallbacks<T extends EpoxyModel>
    implements EpoxySwipeCallback<T> {
        @Override
        public void onSwipeStarted(T model, View itemView, int adapterPosition) {
        }

        @Override
        public void onSwipeProgressChanged(T model, View itemView, float swipeProgress, Canvas canvas) {
        }

        @Override
        public abstract void onSwipeCompleted(T var1, View var2, int var3, int var4);

        @Override
        public void onSwipeReleased(T model, View itemView) {
        }

        @Override
        public void clearView(T model, View itemView) {
        }

        public boolean isSwipeEnabledForModel(T model) {
            return true;
        }

        @Override
        public final int getMovementFlagsForModel(T model, int adapterPosition) {
            return 0;
        }
    }

    public static class SwipeBuilder3<U extends EpoxyModel> {
        private final RecyclerView recyclerView;
        private final int movementFlags;
        private final Class<U> targetModelClass;
        private final List<Class<? extends EpoxyModel>> targetModelClasses;

        private SwipeBuilder3(RecyclerView recyclerView, int movementFlags, Class<U> targetModelClass, List<Class<? extends EpoxyModel>> targetModelClasses) {
            this.recyclerView = recyclerView;
            this.movementFlags = movementFlags;
            this.targetModelClass = targetModelClass;
            this.targetModelClasses = targetModelClasses;
        }

        public ItemTouchHelper andCallbacks(final SwipeCallbacks<U> callbacks) {
            ItemTouchHelper itemTouchHelper = new ItemTouchHelper((ItemTouchHelper.Callback)new EpoxyModelTouchCallback<U>(null, this.targetModelClass){

                @Override
                public int getMovementFlagsForModel(U model, int adapterPosition) {
                    return SwipeBuilder3.this.movementFlags;
                }

                @Override
                protected boolean isTouchableModel(EpoxyModel<?> model) {
                    boolean isTargetType = SwipeBuilder3.this.targetModelClasses.size() == 1 ? super.isTouchableModel(model) : SwipeBuilder3.this.targetModelClasses.contains(model.getClass());
                    return isTargetType && callbacks.isSwipeEnabledForModel(model);
                }

                @Override
                public void onSwipeStarted(U model, View itemView, int adapterPosition) {
                    callbacks.onSwipeStarted(model, itemView, adapterPosition);
                }

                @Override
                public void onSwipeProgressChanged(U model, View itemView, float swipeProgress, Canvas canvas) {
                    callbacks.onSwipeProgressChanged(model, itemView, swipeProgress, canvas);
                }

                @Override
                public void onSwipeCompleted(U model, View itemView, int position, int direction) {
                    callbacks.onSwipeCompleted(model, itemView, position, direction);
                }

                @Override
                public void onSwipeReleased(U model, View itemView) {
                    callbacks.onSwipeReleased(model, itemView);
                }

                @Override
                public void clearView(U model, View itemView) {
                    callbacks.clearView(model, itemView);
                }
            });
            itemTouchHelper.attachToRecyclerView(this.recyclerView);
            return itemTouchHelper;
        }
    }

    public static class SwipeBuilder2 {
        private final RecyclerView recyclerView;
        private final int movementFlags;

        private SwipeBuilder2(RecyclerView recyclerView, int movementFlags) {
            this.recyclerView = recyclerView;
            this.movementFlags = movementFlags;
        }

        public <U extends EpoxyModel> SwipeBuilder3<U> withTarget(Class<U> targetModelClass) {
            ArrayList<Class<U>> targetClasses = new ArrayList<Class<U>>(1);
            targetClasses.add(targetModelClass);
            return new SwipeBuilder3(this.recyclerView, this.movementFlags, targetModelClass, targetClasses);
        }

        public SwipeBuilder3<EpoxyModel> withTargets(Class<? extends EpoxyModel> ... targetModelClasses) {
            return new SwipeBuilder3<EpoxyModel>(this.recyclerView, this.movementFlags, EpoxyModel.class, Arrays.asList(targetModelClasses));
        }

        public SwipeBuilder3<EpoxyModel> forAllModels() {
            return this.withTarget(EpoxyModel.class);
        }
    }

    public static class SwipeBuilder {
        private final RecyclerView recyclerView;

        private SwipeBuilder(RecyclerView recyclerView) {
            this.recyclerView = recyclerView;
        }

        public SwipeBuilder2 right() {
            return this.withDirections(8);
        }

        public SwipeBuilder2 left() {
            return this.withDirections(4);
        }

        public SwipeBuilder2 leftAndRight() {
            return this.withDirections(12);
        }

        public SwipeBuilder2 withDirections(int directionFlags) {
            return new SwipeBuilder2(this.recyclerView, ItemTouchHelper.Callback.makeMovementFlags((int)0, (int)directionFlags));
        }
    }

    public static abstract class DragCallbacks<T extends EpoxyModel>
    implements EpoxyDragCallback<T> {
        @Override
        public void onDragStarted(T model, View itemView, int adapterPosition) {
        }

        @Override
        public void onDragReleased(T model, View itemView) {
        }

        @Override
        public abstract void onModelMoved(int var1, int var2, T var3, View var4);

        @Override
        public void clearView(T model, View itemView) {
        }

        public boolean isDragEnabledForModel(T model) {
            return true;
        }

        @Override
        public final int getMovementFlagsForModel(T model, int adapterPosition) {
            return 0;
        }
    }

    public static class DragBuilder4<U extends EpoxyModel> {
        private final EpoxyController controller;
        private final RecyclerView recyclerView;
        private final int movementFlags;
        private final Class<U> targetModelClass;
        private final List<Class<? extends EpoxyModel>> targetModelClasses;

        private DragBuilder4(EpoxyController controller, RecyclerView recyclerView, int movementFlags, Class<U> targetModelClass, List<Class<? extends EpoxyModel>> targetModelClasses) {
            this.controller = controller;
            this.recyclerView = recyclerView;
            this.movementFlags = movementFlags;
            this.targetModelClass = targetModelClass;
            this.targetModelClasses = targetModelClasses;
        }

        public ItemTouchHelper andCallbacks(final DragCallbacks<U> callbacks) {
            ItemTouchHelper itemTouchHelper = new ItemTouchHelper((ItemTouchHelper.Callback)new EpoxyModelTouchCallback<U>(this.controller, this.targetModelClass){

                @Override
                public int getMovementFlagsForModel(U model, int adapterPosition) {
                    return DragBuilder4.this.movementFlags;
                }

                @Override
                protected boolean isTouchableModel(EpoxyModel<?> model) {
                    boolean isTargetType = DragBuilder4.this.targetModelClasses.size() == 1 ? super.isTouchableModel(model) : DragBuilder4.this.targetModelClasses.contains(model.getClass());
                    return isTargetType && callbacks.isDragEnabledForModel(model);
                }

                @Override
                public void onDragStarted(U model, View itemView, int adapterPosition) {
                    callbacks.onDragStarted(model, itemView, adapterPosition);
                }

                @Override
                public void onDragReleased(U model, View itemView) {
                    callbacks.onDragReleased(model, itemView);
                }

                @Override
                public void onModelMoved(int fromPosition, int toPosition, U modelBeingMoved, View itemView) {
                    callbacks.onModelMoved(fromPosition, toPosition, modelBeingMoved, itemView);
                }

                @Override
                public void clearView(U model, View itemView) {
                    callbacks.clearView(model, itemView);
                }
            });
            itemTouchHelper.attachToRecyclerView(this.recyclerView);
            return itemTouchHelper;
        }
    }

    public static class DragBuilder3 {
        private final EpoxyController controller;
        private final RecyclerView recyclerView;
        private final int movementFlags;

        private DragBuilder3(EpoxyController controller, RecyclerView recyclerView, int movementFlags) {
            this.controller = controller;
            this.recyclerView = recyclerView;
            this.movementFlags = movementFlags;
        }

        public <U extends EpoxyModel> DragBuilder4<U> withTarget(Class<U> targetModelClass) {
            ArrayList<Class<U>> targetClasses = new ArrayList<Class<U>>(1);
            targetClasses.add(targetModelClass);
            return new DragBuilder4(this.controller, this.recyclerView, this.movementFlags, targetModelClass, targetClasses);
        }

        public DragBuilder4<EpoxyModel> withTargets(Class<? extends EpoxyModel> ... targetModelClasses) {
            return new DragBuilder4<EpoxyModel>(this.controller, this.recyclerView, this.movementFlags, EpoxyModel.class, Arrays.asList(targetModelClasses));
        }

        public DragBuilder4<EpoxyModel> forAllModels() {
            return this.withTarget(EpoxyModel.class);
        }
    }

    public static class DragBuilder2 {
        private final EpoxyController controller;
        private final RecyclerView recyclerView;

        private DragBuilder2(EpoxyController controller, RecyclerView recyclerView) {
            this.controller = controller;
            this.recyclerView = recyclerView;
        }

        public DragBuilder3 forVerticalList() {
            return this.withDirections(3);
        }

        public DragBuilder3 forHorizontalList() {
            return this.withDirections(12);
        }

        public DragBuilder3 forGrid() {
            return this.withDirections(15);
        }

        public DragBuilder3 withDirections(int directionFlags) {
            return new DragBuilder3(this.controller, this.recyclerView, ItemTouchHelper.Callback.makeMovementFlags((int)directionFlags, (int)0));
        }
    }

    public static class DragBuilder {
        private final EpoxyController controller;

        private DragBuilder(EpoxyController controller) {
            this.controller = controller;
        }

        public DragBuilder2 withRecyclerView(RecyclerView recyclerView) {
            return new DragBuilder2(this.controller, recyclerView);
        }
    }
}

