/*
 * Decompiled with CFR 0.152.
 */
package com.airbnb.epoxy;

import android.support.annotation.Nullable;
import com.airbnb.epoxy.EpoxyModel;
import java.util.ArrayList;

class UpdateOp {
    static final int ADD = 0;
    static final int REMOVE = 1;
    static final int UPDATE = 2;
    static final int MOVE = 3;
    int type;
    int positionStart;
    int itemCount;
    ArrayList<EpoxyModel<?>> payloads;

    private UpdateOp() {
    }

    static UpdateOp instance(int type, int positionStart, int itemCount, @Nullable EpoxyModel<?> payload) {
        UpdateOp op = new UpdateOp();
        op.type = type;
        op.positionStart = positionStart;
        op.itemCount = itemCount;
        op.addPayload(payload);
        return op;
    }

    int positionEnd() {
        return this.positionStart + this.itemCount;
    }

    boolean isAfter(int position) {
        return position < this.positionStart;
    }

    boolean isBefore(int position) {
        return position >= this.positionEnd();
    }

    boolean contains(int position) {
        return position >= this.positionStart && position < this.positionEnd();
    }

    void addPayload(@Nullable EpoxyModel<?> payload) {
        if (payload == null) {
            return;
        }
        if (this.payloads == null) {
            this.payloads = new ArrayList(1);
        } else if (this.payloads.size() == 1) {
            this.payloads.ensureCapacity(10);
        }
        this.payloads.add(payload);
    }

    public String toString() {
        return "UpdateOp{type=" + this.type + ", positionStart=" + this.positionStart + ", itemCount=" + this.itemCount + '}';
    }
}

