/*
 * Decompiled with CFR 0.152.
 */
package com.airbnb.epoxy;

import android.view.View;
import com.airbnb.epoxy.EpoxyModel;
import com.airbnb.epoxy.EpoxyViewHolder;
import com.airbnb.epoxy.OnModelClickListener;
import com.airbnb.epoxy.OnModelLongClickListener;

public class WrappedEpoxyModelClickListener<T extends EpoxyModel<?>, V>
implements View.OnClickListener,
View.OnLongClickListener {
    private final OnModelClickListener<T, V> originalClickListener;
    private final OnModelLongClickListener<T, V> originalLongClickListener;
    private EpoxyViewHolder holder;
    private final T model;
    private V object;

    public WrappedEpoxyModelClickListener(T model, OnModelClickListener<T, V> clickListener) {
        if (clickListener == null) {
            throw new IllegalArgumentException("Click listener cannot be null");
        }
        this.model = model;
        this.originalClickListener = clickListener;
        this.originalLongClickListener = null;
    }

    public WrappedEpoxyModelClickListener(T model, OnModelLongClickListener<T, V> clickListener) {
        if (clickListener == null) {
            throw new IllegalArgumentException("Click listener cannot be null");
        }
        this.model = model;
        this.originalLongClickListener = clickListener;
        this.originalClickListener = null;
    }

    public void bind(EpoxyViewHolder holder, V object) {
        this.holder = holder;
        this.object = object;
    }

    public void onClick(View v) {
        if (this.holder == null) {
            throw new IllegalStateException("Holder was not bound");
        }
        if (this.object == null) {
            throw new IllegalStateException("Object was not bound");
        }
        if (this.originalClickListener == null) {
            throw new IllegalStateException("Long click listener was set.");
        }
        int adapterPosition = this.holder.getAdapterPosition();
        if (adapterPosition != -1) {
            this.originalClickListener.onClick(this.model, this.object, v, adapterPosition);
        }
    }

    public boolean onLongClick(View v) {
        if (this.holder == null) {
            throw new IllegalStateException("Holder was not bound");
        }
        if (this.object == null) {
            throw new IllegalStateException("Object was not bound");
        }
        if (this.originalLongClickListener == null) {
            throw new IllegalStateException("Normal click listener was set.");
        }
        return this.originalLongClickListener.onLongClick(this.model, this.object, v, this.holder.getAdapterPosition());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof WrappedEpoxyModelClickListener)) {
            return false;
        }
        WrappedEpoxyModelClickListener that = (WrappedEpoxyModelClickListener)o;
        if (this.originalClickListener != null ? !this.originalClickListener.equals(that.originalClickListener) : that.originalClickListener != null) {
            return false;
        }
        return this.originalLongClickListener != null ? this.originalLongClickListener.equals(that.originalLongClickListener) : that.originalLongClickListener == null;
    }

    public int hashCode() {
        int result = this.originalClickListener != null ? this.originalClickListener.hashCode() : 0;
        result = 31 * result + (this.originalLongClickListener != null ? this.originalLongClickListener.hashCode() : 0);
        return result;
    }
}

