/*
 * Decompiled with CFR 0.152.
 */
package com.airbnb.epoxy;

import android.content.Context;
import android.support.annotation.CallSuper;
import android.support.annotation.DimenRes;
import android.support.annotation.Dimension;
import android.support.annotation.Nullable;
import android.support.annotation.Px;
import android.support.v7.widget.GridLayoutManager;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.SparseArray;
import android.util.TypedValue;
import android.view.ViewGroup;
import com.airbnb.epoxy.EpoxyController;
import com.airbnb.epoxy.EpoxyItemSpacingDecorator;
import com.airbnb.epoxy.EpoxyModel;
import com.airbnb.epoxy.SimpleEpoxyController;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;

public class EpoxyRecyclerView
extends RecyclerView {
    private static final List<PoolReference> RECYCLER_POOLS = new ArrayList<PoolReference>(5);
    protected final EpoxyItemSpacingDecorator spacingDecorator = new EpoxyItemSpacingDecorator();
    private EpoxyController epoxyController;

    public EpoxyRecyclerView(Context context) {
        super(context);
        this.init();
    }

    public EpoxyRecyclerView(Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        this.init();
    }

    public EpoxyRecyclerView(Context context, @Nullable AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.init();
    }

    @CallSuper
    protected void init() {
        this.setClipToPadding(false);
        this.initViewPool();
    }

    private void initViewPool() {
        if (!this.shouldShareViewPoolAcrossContext()) {
            this.setRecycledViewPool(this.createViewPool());
            return;
        }
        Context context = this.getContext();
        Iterator<PoolReference> iterator = RECYCLER_POOLS.iterator();
        PoolReference poolToUse = null;
        while (iterator.hasNext()) {
            PoolReference poolReference = iterator.next();
            if (poolReference.context() == null) {
                iterator.remove();
                continue;
            }
            if (poolReference.context() != context) continue;
            if (poolToUse != null) {
                throw new IllegalStateException("A pool was already found");
            }
            poolToUse = poolReference;
        }
        if (poolToUse == null) {
            poolToUse = new PoolReference(context, this.createViewPool());
            RECYCLER_POOLS.add(poolToUse);
        }
        this.setRecycledViewPool(poolToUse.viewPool);
    }

    protected RecyclerView.RecycledViewPool createViewPool() {
        return new UnboundedViewPool();
    }

    public boolean shouldShareViewPoolAcrossContext() {
        return true;
    }

    public void setLayoutParams(ViewGroup.LayoutParams params) {
        boolean isFirstParams = this.getLayoutParams() == null;
        super.setLayoutParams(params);
        if (isFirstParams && this.getLayoutManager() == null) {
            this.setLayoutManager(this.createLayoutManager());
        }
    }

    protected RecyclerView.LayoutManager createLayoutManager() {
        ViewGroup.LayoutParams layoutParams = this.getLayoutParams();
        if (layoutParams.height == -1 || layoutParams.height == 0) {
            if (layoutParams.width == -1 || layoutParams.width == 0) {
                this.setHasFixedSize(true);
            }
            return new LinearLayoutManager(this.getContext());
        }
        return new LinearLayoutManager(this.getContext(), 0, false);
    }

    public void setLayoutManager(RecyclerView.LayoutManager layout2) {
        super.setLayoutManager(layout2);
        this.syncSpanCount();
    }

    private void syncSpanCount() {
        RecyclerView.LayoutManager layout2 = this.getLayoutManager();
        if (layout2 instanceof GridLayoutManager && this.epoxyController != null) {
            GridLayoutManager grid = (GridLayoutManager)layout2;
            if (this.epoxyController.getSpanCount() != grid.getSpanCount() || grid.getSpanSizeLookup() != this.epoxyController.getSpanSizeLookup()) {
                this.epoxyController.setSpanCount(grid.getSpanCount());
                grid.setSpanSizeLookup(this.epoxyController.getSpanSizeLookup());
            }
        }
    }

    public void requestLayout() {
        this.syncSpanCount();
        super.requestLayout();
    }

    public void setItemSpacingRes(@DimenRes int itemSpacingRes) {
        this.setItemSpacingPx(this.resToPx(itemSpacingRes));
    }

    public void setItemSpacingDp(@Dimension(unit=0) int dp) {
        this.setItemSpacingPx(this.dpToPx(dp));
    }

    public void setItemSpacingPx(@Px int spacingPx) {
        this.removeItemDecoration(this.spacingDecorator);
        this.spacingDecorator.setPxBetweenItems(spacingPx);
        if (spacingPx > 0) {
            this.addItemDecoration(this.spacingDecorator);
        }
    }

    public void setModels(List<? extends EpoxyModel<?>> models) {
        if (!(this.epoxyController instanceof SimpleEpoxyController)) {
            this.setController(new SimpleEpoxyController());
        }
        ((SimpleEpoxyController)this.epoxyController).setModels(models);
    }

    public void setController(EpoxyController controller) {
        this.epoxyController = controller;
        this.setAdapter(controller.getAdapter());
        this.syncSpanCount();
    }

    public void setControllerAndBuildModels(EpoxyController controller) {
        controller.requestModelBuild();
        this.setController(controller);
    }

    public void buildModelsWith(final ModelBuilderCallback callback) {
        this.setControllerAndBuildModels(new EpoxyController(){

            @Override
            protected void buildModels() {
                callback.buildModels(this);
            }
        });
    }

    public void requestModelBuild() {
        if (this.epoxyController == null) {
            throw new IllegalStateException("A controller must be set before requesting a model build.");
        }
        if (this.epoxyController instanceof SimpleEpoxyController) {
            throw new IllegalStateException("Models were set with #setModels, they can not be rebuilt.");
        }
        this.epoxyController.requestModelBuild();
    }

    public void clear() {
        if (this.epoxyController == null) {
            return;
        }
        this.epoxyController.cancelPendingModelBuild();
        this.epoxyController = null;
        this.swapAdapter(null, true);
    }

    @Px
    protected int dpToPx(@Dimension(unit=0) int dp) {
        return (int)TypedValue.applyDimension((int)1, (float)dp, (DisplayMetrics)this.getResources().getDisplayMetrics());
    }

    @Px
    protected int resToPx(@DimenRes int itemSpacingRes) {
        return this.getResources().getDimensionPixelOffset(itemSpacingRes);
    }

    private static class UnboundedViewPool
    extends RecyclerView.RecycledViewPool {
        private final SparseArray<Queue<RecyclerView.ViewHolder>> scrapHeaps = new SparseArray();

        private UnboundedViewPool() {
        }

        public void clear() {
            this.scrapHeaps.clear();
        }

        public void setMaxRecycledViews(int viewType, int max) {
            throw new UnsupportedOperationException("UnboundedViewPool does not support setting a maximum number of recycled views");
        }

        @Nullable
        public RecyclerView.ViewHolder getRecycledView(int viewType) {
            Queue scrapHeap = (Queue)this.scrapHeaps.get(viewType);
            return scrapHeap != null ? (RecyclerView.ViewHolder)scrapHeap.poll() : null;
        }

        public void putRecycledView(RecyclerView.ViewHolder viewHolder) {
            this.getScrapHeapForType(viewHolder.getItemViewType()).add(viewHolder);
        }

        private Queue<RecyclerView.ViewHolder> getScrapHeapForType(int viewType) {
            LinkedList scrapHeap = (LinkedList)this.scrapHeaps.get(viewType);
            if (scrapHeap == null) {
                scrapHeap = new LinkedList();
                this.scrapHeaps.put(viewType, scrapHeap);
            }
            return scrapHeap;
        }
    }

    private static class PoolReference {
        private final WeakReference<Context> contextReference;
        private final RecyclerView.RecycledViewPool viewPool;

        private PoolReference(Context context, RecyclerView.RecycledViewPool viewPool) {
            this.contextReference = new WeakReference<Context>(context);
            this.viewPool = viewPool;
        }

        @Nullable
        private Context context() {
            return (Context)this.contextReference.get();
        }
    }

    public static interface ModelBuilderCallback {
        public void buildModels(EpoxyController var1);
    }
}

