/*
 * Decompiled with CFR 0.152.
 */
package com.airbnb.epoxy;

import android.os.Build;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.Looper;
import androidx.annotation.MainThread;
import androidx.annotation.Nullable;
import java.lang.reflect.Constructor;

public final class EpoxyAsyncUtil {
    public static final Handler MAIN_THREAD_HANDLER = EpoxyAsyncUtil.createHandler(Looper.getMainLooper(), false);
    public static final Handler AYSNC_MAIN_THREAD_HANDLER = EpoxyAsyncUtil.createHandler(Looper.getMainLooper(), true);
    private static Handler asyncBackgroundHandler;

    private EpoxyAsyncUtil() {
    }

    @MainThread
    public static Handler getAsyncBackgroundHandler() {
        if (asyncBackgroundHandler == null) {
            asyncBackgroundHandler = EpoxyAsyncUtil.createHandler(EpoxyAsyncUtil.buildBackgroundLooper("epoxy"), true);
        }
        return asyncBackgroundHandler;
    }

    public static Handler createHandler(Looper looper, boolean async) {
        Constructor<Handler> handlerConstructor;
        if (!async) {
            return new Handler(looper);
        }
        if (Build.VERSION.SDK_INT >= 28) {
            return Handler.createAsync((Looper)looper);
        }
        if (Build.VERSION.SDK_INT >= 17 && (handlerConstructor = EpoxyAsyncUtil.asyncHandlerConstructor()) != null) {
            try {
                return handlerConstructor.newInstance(looper, null, true);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return new Handler(looper);
    }

    public static Looper buildBackgroundLooper(String threadName) {
        HandlerThread handlerThread = new HandlerThread(threadName);
        handlerThread.start();
        return handlerThread.getLooper();
    }

    @Nullable
    private static Constructor<Handler> asyncHandlerConstructor() {
        try {
            return Handler.class.getConstructor(Looper.class, Handler.Callback.class, Boolean.class);
        }
        catch (Throwable e) {
            return null;
        }
    }
}

