/*
 * Decompiled with CFR 0.152.
 */
package com.airbnb.epoxy;

import android.content.Context;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.view.View;
import android.view.ViewGroup;
import androidx.annotation.DimenRes;
import androidx.annotation.Dimension;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.Px;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.LinearSnapHelper;
import androidx.recyclerview.widget.RecyclerView;
import androidx.recyclerview.widget.SnapHelper;
import com.airbnb.epoxy.EpoxyModel;
import com.airbnb.epoxy.EpoxyRecyclerView;
import com.airbnb.epoxy.ModelProp;
import com.airbnb.epoxy.ModelView;
import com.airbnb.epoxy.OnViewRecycled;
import com.airbnb.viewmodeladapter.R;
import java.util.List;

@ModelView(saveViewState=true, autoLayout=ModelView.Size.MATCH_WIDTH_WRAP_HEIGHT)
public class Carousel
extends EpoxyRecyclerView {
    public static final int NO_VALUE_SET = -1;
    private static SnapHelperFactory defaultGlobalSnapHelperFactory = new SnapHelperFactory(){

        @Override
        @NonNull
        public SnapHelper buildSnapHelper(Context context) {
            return new LinearSnapHelper();
        }
    };
    @Dimension(unit=0)
    private static int defaultSpacingBetweenItemsDp = 8;
    private float numViewsToShowOnScreen;

    public Carousel(Context context) {
        super(context);
    }

    public Carousel(Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
    }

    public Carousel(Context context, @Nullable AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
    }

    @Override
    protected void init() {
        SnapHelperFactory snapHelperFactory;
        super.init();
        int defaultSpacingDp = this.getDefaultSpacingBetweenItemsDp();
        if (defaultSpacingDp >= 0) {
            this.setItemSpacingDp(defaultSpacingDp);
            if (this.getPaddingLeft() == 0 && this.getPaddingRight() == 0 && this.getPaddingTop() == 0 && this.getPaddingBottom() == 0) {
                this.setPaddingDp(defaultSpacingDp);
            }
        }
        if ((snapHelperFactory = this.getSnapHelperFactory()) != null) {
            snapHelperFactory.buildSnapHelper(this.getContext()).attachToRecyclerView((RecyclerView)this);
        }
    }

    @Nullable
    protected SnapHelperFactory getSnapHelperFactory() {
        return defaultGlobalSnapHelperFactory;
    }

    public static void setDefaultGlobalSnapHelperFactory(@Nullable SnapHelperFactory factory) {
        defaultGlobalSnapHelperFactory = factory;
    }

    @ModelProp
    public void setHasFixedSize(boolean hasFixedSize) {
        super.setHasFixedSize(hasFixedSize);
    }

    @ModelProp(group="prefetch")
    public void setNumViewsToShowOnScreen(float viewCount) {
        this.numViewsToShowOnScreen = viewCount;
        this.setInitialPrefetchItemCount((int)Math.ceil(viewCount));
    }

    @ModelProp(group="prefetch")
    public void setInitialPrefetchItemCount(int numItemsToPrefetch) {
        if (numItemsToPrefetch < 0) {
            throw new IllegalStateException("numItemsToPrefetch must be greater than 0");
        }
        int prefetchCount = numItemsToPrefetch == 0 ? 2 : numItemsToPrefetch;
        RecyclerView.LayoutManager layoutManager = this.getLayoutManager();
        if (layoutManager instanceof LinearLayoutManager) {
            ((LinearLayoutManager)layoutManager).setInitialPrefetchItemCount(prefetchCount);
        }
    }

    public void onChildAttachedToWindow(View child) {
        if (this.numViewsToShowOnScreen > 0.0f) {
            ViewGroup.LayoutParams childLayoutParams = child.getLayoutParams();
            child.setTag(R.id.epoxy_recycler_view_child_initial_size_id, (Object)childLayoutParams.width);
            int itemSpacingPx = this.spacingDecorator.getPxBetweenItems();
            int spaceBetweenItems = 0;
            if (itemSpacingPx > 0) {
                spaceBetweenItems = (int)((float)itemSpacingPx * this.numViewsToShowOnScreen);
            }
            boolean isScrollingHorizontally = this.getLayoutManager().canScrollHorizontally();
            int itemSizeInScrollingDirection = (int)((float)(this.getSpaceForChildren(isScrollingHorizontally) - spaceBetweenItems) / this.numViewsToShowOnScreen);
            if (isScrollingHorizontally) {
                childLayoutParams.width = itemSizeInScrollingDirection;
            } else {
                childLayoutParams.height = itemSizeInScrollingDirection;
            }
        }
    }

    private int getSpaceForChildren(boolean horizontal) {
        if (horizontal) {
            return Carousel.getTotalWidthPx((View)this) - this.getPaddingLeft() - (this.getClipToPadding() ? this.getPaddingRight() : 0);
        }
        return Carousel.getTotalHeightPx((View)this) - this.getPaddingTop() - (this.getClipToPadding() ? this.getPaddingBottom() : 0);
    }

    @Px
    private static int getTotalWidthPx(View view) {
        if (view.getWidth() > 0) {
            return view.getWidth();
        }
        DisplayMetrics metrics = view.getContext().getResources().getDisplayMetrics();
        return metrics.widthPixels;
    }

    @Px
    private static int getTotalHeightPx(View view) {
        if (view.getHeight() > 0) {
            return view.getHeight();
        }
        DisplayMetrics metrics = view.getContext().getResources().getDisplayMetrics();
        return metrics.heightPixels;
    }

    public void onChildDetachedFromWindow(View child) {
        Object initialWidth = child.getTag(R.id.epoxy_recycler_view_child_initial_size_id);
        if (initialWidth instanceof Integer) {
            ViewGroup.LayoutParams params = child.getLayoutParams();
            params.width = (Integer)initialWidth;
            child.setTag(R.id.epoxy_recycler_view_child_initial_size_id, null);
        }
    }

    public static void setDefaultItemSpacingDp(@Dimension(unit=0) int dp) {
        defaultSpacingBetweenItemsDp = dp;
    }

    @Dimension(unit=0)
    protected int getDefaultSpacingBetweenItemsDp() {
        return defaultSpacingBetweenItemsDp;
    }

    @ModelProp(group="padding")
    public void setPaddingRes(@DimenRes int paddingRes) {
        int px = this.resToPx(paddingRes);
        this.setPadding(px, px, px, px);
        this.setItemSpacingPx(px);
    }

    @ModelProp(defaultValue="NO_VALUE_SET", group="padding")
    public void setPaddingDp(@Dimension(unit=0) int paddingDp) {
        int px = this.dpToPx(paddingDp != -1 ? paddingDp : this.getDefaultSpacingBetweenItemsDp());
        this.setPadding(px, px, px, px);
        this.setItemSpacingPx(px);
    }

    @ModelProp(group="padding")
    public void setPadding(@Nullable Padding padding) {
        if (padding == null) {
            this.setPaddingDp(0);
        } else if (padding.paddingType == Padding.PaddingType.PX) {
            this.setPadding(padding.left, padding.top, padding.right, padding.bottom);
            this.setItemSpacingPx(padding.itemSpacing);
        } else if (padding.paddingType == Padding.PaddingType.DP) {
            this.setPadding(this.dpToPx(padding.left), this.dpToPx(padding.top), this.dpToPx(padding.right), this.dpToPx(padding.bottom));
            this.setItemSpacingPx(this.dpToPx(padding.itemSpacing));
        } else if (padding.paddingType == Padding.PaddingType.RESOURCE) {
            this.setPadding(this.resToPx(padding.left), this.resToPx(padding.top), this.resToPx(padding.right), this.resToPx(padding.bottom));
            this.setItemSpacingPx(this.resToPx(padding.itemSpacing));
        }
    }

    @Override
    @ModelProp
    public void setModels(@NonNull List<? extends EpoxyModel<?>> models) {
        super.setModels(models);
    }

    @Override
    @OnViewRecycled
    public void clear() {
        super.clear();
    }

    public static abstract class SnapHelperFactory {
        @NonNull
        public abstract SnapHelper buildSnapHelper(Context var1);
    }

    public static class Padding {
        public final int left;
        public final int top;
        public final int right;
        public final int bottom;
        public final int itemSpacing;
        public final PaddingType paddingType;

        public static Padding resource(@DimenRes int paddingRes, @DimenRes int itemSpacingRes) {
            return new Padding(paddingRes, paddingRes, paddingRes, paddingRes, itemSpacingRes, PaddingType.RESOURCE);
        }

        public static Padding resource(@DimenRes int leftRes, @DimenRes int topRes, @DimenRes int rightRes, @DimenRes int bottomRes, @DimenRes int itemSpacingRes) {
            return new Padding(leftRes, topRes, rightRes, bottomRes, itemSpacingRes, PaddingType.RESOURCE);
        }

        public static Padding dp(@Dimension(unit=0) int paddingDp, @Dimension(unit=0) int itemSpacingDp) {
            return new Padding(paddingDp, paddingDp, paddingDp, paddingDp, itemSpacingDp, PaddingType.DP);
        }

        public static Padding dp(@Dimension(unit=0) int leftDp, @Dimension(unit=0) int topDp, @Dimension(unit=0) int rightDp, @Dimension(unit=0) int bottomDp, @Dimension(unit=0) int itemSpacingDp) {
            return new Padding(leftDp, topDp, rightDp, bottomDp, itemSpacingDp, PaddingType.DP);
        }

        public Padding(@Px int paddingPx, @Px int itemSpacingPx) {
            this(paddingPx, paddingPx, paddingPx, paddingPx, itemSpacingPx, PaddingType.PX);
        }

        public Padding(@Px int leftPx, @Px int topPx, @Px int rightPx, @Px int bottomPx, @Px int itemSpacingPx) {
            this(leftPx, topPx, rightPx, bottomPx, itemSpacingPx, PaddingType.PX);
        }

        private Padding(int left, int top, int right, int bottom, int itemSpacing, PaddingType paddingType) {
            this.left = left;
            this.top = top;
            this.right = right;
            this.bottom = bottom;
            this.itemSpacing = itemSpacing;
            this.paddingType = paddingType;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Padding padding = (Padding)o;
            if (this.left != padding.left) {
                return false;
            }
            if (this.top != padding.top) {
                return false;
            }
            if (this.right != padding.right) {
                return false;
            }
            if (this.bottom != padding.bottom) {
                return false;
            }
            return this.itemSpacing == padding.itemSpacing;
        }

        public int hashCode() {
            int result = this.left;
            result = 31 * result + this.top;
            result = 31 * result + this.right;
            result = 31 * result + this.bottom;
            result = 31 * result + this.itemSpacing;
            return result;
        }

        static enum PaddingType {
            PX,
            DP,
            RESOURCE;

        }
    }
}

