/*
 * Decompiled with CFR 0.152.
 */
package com.airbnb.epoxy;

import android.graphics.Rect;
import android.view.View;
import androidx.annotation.NonNull;
import androidx.annotation.Px;
import androidx.recyclerview.widget.RecyclerView;
import com.airbnb.epoxy.EpoxyViewHolder;

class EpoxyVisibilityItem {
    private static final int NOT_NOTIFIED = -1;
    private final Rect localVisibleRect = new Rect();
    private int adapterPosition = -1;
    @Px
    private int sizeInScrollingDirection;
    private int sizeNotInScrollingDirection;
    private boolean verticalScrolling;
    private float percentVisibleSize = 0.0f;
    private int visibleSize;
    private int viewportSize;
    private boolean fullyVisible = false;
    private boolean visible = false;
    private boolean focusedVisible = false;
    private int lastVisibleSizeNotified = -1;

    EpoxyVisibilityItem(int adapterPosition) {
        this.reset(adapterPosition);
    }

    boolean update(@NonNull View view, @NonNull RecyclerView parent, boolean vertical, boolean detachEvent) {
        this.localVisibleRect.setEmpty();
        boolean visibleRect = view.getLocalVisibleRect(this.localVisibleRect);
        this.verticalScrolling = vertical;
        if (vertical) {
            this.sizeInScrollingDirection = view.getMeasuredHeight();
            this.sizeNotInScrollingDirection = view.getMeasuredWidth();
            this.viewportSize = parent.getMeasuredHeight();
            this.visibleSize = detachEvent || !visibleRect ? 0 : this.localVisibleRect.height();
        } else {
            this.sizeNotInScrollingDirection = view.getMeasuredHeight();
            this.sizeInScrollingDirection = view.getMeasuredWidth();
            this.viewportSize = parent.getMeasuredWidth();
            this.visibleSize = detachEvent || !visibleRect ? 0 : this.localVisibleRect.width();
        }
        float f = this.percentVisibleSize = detachEvent ? 0.0f : 100.0f / (float)this.sizeInScrollingDirection * (float)this.visibleSize;
        if (this.visibleSize != this.sizeInScrollingDirection) {
            this.fullyVisible = false;
        }
        return this.sizeInScrollingDirection > 0;
    }

    int getAdapterPosition() {
        return this.adapterPosition;
    }

    void reset(int newAdapterPosition) {
        this.fullyVisible = false;
        this.visible = false;
        this.focusedVisible = false;
        this.adapterPosition = newAdapterPosition;
        this.lastVisibleSizeNotified = -1;
    }

    void handleVisible(@NonNull EpoxyViewHolder epoxyHolder, boolean detachEvent) {
        if (this.visible && this.checkAndUpdateInvisible(detachEvent)) {
            epoxyHolder.visibilityStateChanged(1);
        } else if (!this.visible && this.checkAndUpdateVisible()) {
            epoxyHolder.visibilityStateChanged(0);
        }
    }

    void handleFocus(EpoxyViewHolder epoxyHolder, boolean detachEvent) {
        if (this.focusedVisible && this.checkAndUpdateUnfocusedVisible(detachEvent)) {
            epoxyHolder.visibilityStateChanged(3);
        } else if (!this.focusedVisible && this.checkAndUpdateFocusedVisible()) {
            epoxyHolder.visibilityStateChanged(2);
        }
    }

    void handleFullImpressionVisible(EpoxyViewHolder epoxyHolder, boolean detachEvent) {
        if (!this.fullyVisible && this.checkAndUpdateFullImpressionVisible()) {
            epoxyHolder.visibilityStateChanged(4);
        }
    }

    void handleChanged(EpoxyViewHolder epoxyHolder) {
        if (this.visibleSize != this.lastVisibleSizeNotified) {
            if (this.verticalScrolling) {
                epoxyHolder.visibilityChanged(this.percentVisibleSize, 100.0f, this.visibleSize, this.sizeNotInScrollingDirection);
            } else {
                epoxyHolder.visibilityChanged(100.0f, this.percentVisibleSize, this.sizeNotInScrollingDirection, this.visibleSize);
            }
            this.lastVisibleSizeNotified = this.visibleSize;
        }
    }

    private boolean checkAndUpdateVisible() {
        this.visible = this.visibleSize > 0;
        return this.visible;
    }

    private boolean checkAndUpdateInvisible(boolean detachEvent) {
        boolean invisible;
        boolean bl = invisible = this.visibleSize <= 0 || detachEvent;
        if (invisible) {
            this.visible = false;
        }
        return !this.visible;
    }

    private boolean checkAndUpdateFocusedVisible() {
        this.focusedVisible = this.sizeInScrollingDirection >= this.viewportSize / 2 || this.visibleSize == this.sizeInScrollingDirection && this.sizeInScrollingDirection < this.viewportSize / 2;
        return this.focusedVisible;
    }

    private boolean checkAndUpdateUnfocusedVisible(boolean detachEvent) {
        boolean unfocusedVisible;
        boolean bl = unfocusedVisible = detachEvent || this.sizeInScrollingDirection < this.viewportSize / 2 && (this.visibleSize != this.sizeInScrollingDirection || this.sizeInScrollingDirection >= this.viewportSize / 2);
        if (unfocusedVisible) {
            this.focusedVisible = false;
        }
        return !this.focusedVisible;
    }

    private boolean checkAndUpdateFullImpressionVisible() {
        this.fullyVisible = this.visibleSize == this.sizeInScrollingDirection;
        return this.fullyVisible;
    }

    void shiftBy(int offsetPosition) {
        this.adapterPosition += offsetPosition;
    }
}

