/*
 * Decompiled with CFR 0.152.
 */
package com.airbnb.epoxy;

import android.util.SparseArray;
import android.view.View;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.recyclerview.widget.RecyclerView;
import com.airbnb.epoxy.EpoxyViewHolder;
import com.airbnb.epoxy.EpoxyVisibilityItem;
import com.airbnb.epoxy.IllegalEpoxyUsage;
import java.util.ArrayList;
import java.util.List;

public class EpoxyVisibilityTracker {
    private static final String TAG = "EpoxyVisibilityTracker";
    static final boolean DEBUG_LOG = false;
    private final SparseArray<EpoxyVisibilityItem> visibilityIdToItemMap = new SparseArray();
    private final List<EpoxyVisibilityItem> visibilityIdToItems = new ArrayList<EpoxyVisibilityItem>();
    private final Listener listener = new Listener();
    private final DataObserver observer = new DataObserver();
    @Nullable
    private RecyclerView attachedRecyclerView = null;
    @Nullable
    private RecyclerView.Adapter lastAdapterSeen = null;
    private boolean onChangedEnabled = true;
    private boolean visibleDataChanged = false;

    public void setOnChangedEnabled(boolean enabled) {
        this.onChangedEnabled = enabled;
    }

    public void attach(@NonNull RecyclerView recyclerView) {
        this.attachedRecyclerView = recyclerView;
        recyclerView.addOnScrollListener((RecyclerView.OnScrollListener)this.listener);
        recyclerView.addOnLayoutChangeListener((View.OnLayoutChangeListener)this.listener);
        recyclerView.addOnChildAttachStateChangeListener((RecyclerView.OnChildAttachStateChangeListener)this.listener);
    }

    public void detach(@NonNull RecyclerView recyclerView) {
        recyclerView.removeOnScrollListener((RecyclerView.OnScrollListener)this.listener);
        recyclerView.removeOnLayoutChangeListener((View.OnLayoutChangeListener)this.listener);
        recyclerView.removeOnChildAttachStateChangeListener((RecyclerView.OnChildAttachStateChangeListener)this.listener);
        this.attachedRecyclerView = null;
    }

    public void clearVisibilityStates() {
        this.visibilityIdToItemMap.clear();
        this.visibilityIdToItems.clear();
    }

    private void processChangeEvent(String debug) {
        this.processChangeEventWithDetachedView(null, debug);
    }

    private void processChangeEventWithDetachedView(@Nullable View detachedView, String debug) {
        RecyclerView recyclerView = this.attachedRecyclerView;
        if (recyclerView != null) {
            this.processNewAdapterIfNecessary();
            if (detachedView != null) {
                this.processChild(detachedView, true, debug);
            }
            for (int i = 0; i < recyclerView.getChildCount(); ++i) {
                View child = recyclerView.getChildAt(i);
                if (child == null || child == detachedView) continue;
                this.processChild(child, false, debug);
            }
        }
    }

    private void processNewAdapterIfNecessary() {
        if (this.attachedRecyclerView != null && this.attachedRecyclerView.getAdapter() != null && this.lastAdapterSeen != this.attachedRecyclerView.getAdapter()) {
            if (this.lastAdapterSeen != null) {
                this.lastAdapterSeen.unregisterAdapterDataObserver((RecyclerView.AdapterDataObserver)this.observer);
            }
            this.attachedRecyclerView.getAdapter().registerAdapterDataObserver((RecyclerView.AdapterDataObserver)this.observer);
            this.lastAdapterSeen = this.attachedRecyclerView.getAdapter();
        }
    }

    private void processChild(@NonNull View child, boolean detachEvent, String eventOriginForDebug) {
        RecyclerView recyclerView = this.attachedRecyclerView;
        if (recyclerView != null) {
            RecyclerView.ViewHolder holder = recyclerView.getChildViewHolder(child);
            if (holder instanceof EpoxyViewHolder) {
                this.processVisibilityEvents(recyclerView, (EpoxyViewHolder)holder, recyclerView.getLayoutManager().canScrollVertically(), detachEvent, eventOriginForDebug);
            } else {
                throw new IllegalEpoxyUsage("`EpoxyVisibilityTracker` cannot be used with non-epoxy view holders.");
            }
        }
    }

    private void processVisibilityEvents(@NonNull RecyclerView recyclerView, @NonNull EpoxyViewHolder epoxyHolder, boolean vertical, boolean detachEvent, String eventOriginForDebug) {
        View itemView = epoxyHolder.itemView;
        int id2 = System.identityHashCode(itemView);
        EpoxyVisibilityItem vi = (EpoxyVisibilityItem)this.visibilityIdToItemMap.get(id2);
        if (vi == null) {
            vi = new EpoxyVisibilityItem(epoxyHolder.getAdapterPosition());
            this.visibilityIdToItemMap.put(id2, (Object)vi);
            this.visibilityIdToItems.add(vi);
        } else if (epoxyHolder.getAdapterPosition() != -1 && vi.getAdapterPosition() != epoxyHolder.getAdapterPosition()) {
            vi.reset(epoxyHolder.getAdapterPosition());
        }
        if (vi.update(itemView, recyclerView, vertical, detachEvent)) {
            vi.handleVisible(epoxyHolder, detachEvent);
            vi.handleFocus(epoxyHolder, detachEvent);
            vi.handleFullImpressionVisible(epoxyHolder, detachEvent);
            if (this.onChangedEnabled) {
                vi.handleChanged(epoxyHolder);
            }
        }
    }

    class DataObserver
    extends RecyclerView.AdapterDataObserver {
        DataObserver() {
        }

        public void onChanged() {
            EpoxyVisibilityTracker.this.visibilityIdToItemMap.clear();
            EpoxyVisibilityTracker.this.visibilityIdToItems.clear();
            EpoxyVisibilityTracker.this.visibleDataChanged = true;
        }

        public void onItemRangeInserted(int positionStart, int itemCount) {
            for (EpoxyVisibilityItem item : EpoxyVisibilityTracker.this.visibilityIdToItems) {
                if (item.getAdapterPosition() < positionStart) continue;
                EpoxyVisibilityTracker.this.visibleDataChanged = true;
                item.shiftBy(itemCount);
            }
        }

        public void onItemRangeRemoved(int positionStart, int itemCount) {
            for (EpoxyVisibilityItem item : EpoxyVisibilityTracker.this.visibilityIdToItems) {
                if (item.getAdapterPosition() < positionStart) continue;
                EpoxyVisibilityTracker.this.visibleDataChanged = true;
                item.shiftBy(-itemCount);
            }
        }

        public void onItemRangeMoved(int fromPosition, int toPosition, int itemCount) {
            for (int i = 0; i < itemCount; ++i) {
                this.onItemMoved(fromPosition + i, toPosition + i);
            }
        }

        private void onItemMoved(int fromPosition, int toPosition) {
            for (EpoxyVisibilityItem item : EpoxyVisibilityTracker.this.visibilityIdToItems) {
                int position = item.getAdapterPosition();
                if (position == fromPosition) {
                    item.shiftBy(toPosition - fromPosition);
                    EpoxyVisibilityTracker.this.visibleDataChanged = true;
                    continue;
                }
                if (fromPosition < toPosition) {
                    if (position <= fromPosition || position > toPosition) continue;
                    item.shiftBy(-1);
                    EpoxyVisibilityTracker.this.visibleDataChanged = true;
                    continue;
                }
                if (fromPosition <= toPosition || position < toPosition || position >= fromPosition) continue;
                item.shiftBy(1);
                EpoxyVisibilityTracker.this.visibleDataChanged = true;
            }
        }
    }

    private class Listener
    extends RecyclerView.OnScrollListener
    implements View.OnLayoutChangeListener,
    RecyclerView.OnChildAttachStateChangeListener {
        private Listener() {
        }

        public void onLayoutChange(@NonNull View recyclerView, int left, int top, int right, int bottom, int oldLeft, int oldTop, int oldRight, int oldBottom) {
            EpoxyVisibilityTracker.this.processChangeEvent("onLayoutChange");
        }

        public void onScrolled(@NonNull RecyclerView recyclerView, int dx, int dy) {
            EpoxyVisibilityTracker.this.processChangeEvent("onScrolled");
        }

        public void onChildViewAttachedToWindow(View child) {
            EpoxyVisibilityTracker.this.processChild(child, false, "onChildViewAttachedToWindow");
        }

        public void onChildViewDetachedFromWindow(View child) {
            if (EpoxyVisibilityTracker.this.visibleDataChanged) {
                EpoxyVisibilityTracker.this.processChangeEventWithDetachedView(child, "onChildViewDetachedFromWindow");
                EpoxyVisibilityTracker.this.visibleDataChanged = false;
            } else {
                EpoxyVisibilityTracker.this.processChild(child, true, "onChildViewDetachedFromWindow");
            }
        }
    }
}

