/*
 * Decompiled with CFR 0.152.
 */
package com.airbnb.epoxy;

import android.os.Handler;
import androidx.annotation.Nullable;
import com.airbnb.epoxy.EpoxyController;

public abstract class TypedEpoxyController<T>
extends EpoxyController {
    private T currentData;
    private boolean allowModelBuildRequests;

    public TypedEpoxyController() {
    }

    public TypedEpoxyController(Handler modelBuildingHandler, Handler diffingHandler) {
        super(modelBuildingHandler, diffingHandler);
    }

    public final void setData(T data) {
        this.currentData = data;
        this.allowModelBuildRequests = true;
        this.requestModelBuild();
        this.allowModelBuildRequests = false;
    }

    @Override
    public final void requestModelBuild() {
        if (!this.allowModelBuildRequests) {
            throw new IllegalStateException("You cannot call `requestModelBuild` directly. Call `setData` instead to trigger a model refresh with new data.");
        }
        super.requestModelBuild();
    }

    @Override
    public void moveModel(int fromPosition, int toPosition) {
        this.allowModelBuildRequests = true;
        super.moveModel(fromPosition, toPosition);
        this.allowModelBuildRequests = false;
    }

    @Override
    public void requestDelayedModelBuild(int delayMs) {
        if (!this.allowModelBuildRequests) {
            throw new IllegalStateException("You cannot call `requestModelBuild` directly. Call `setData` instead to trigger a model refresh with new data.");
        }
        super.requestDelayedModelBuild(delayMs);
    }

    @Nullable
    public final T getCurrentData() {
        return this.currentData;
    }

    @Override
    protected final void buildModels() {
        if (!this.isBuildingModels()) {
            throw new IllegalStateException("You cannot call `buildModels` directly. Call `setData` instead to trigger a model refresh with new data.");
        }
        this.buildModels(this.currentData);
    }

    protected abstract void buildModels(T var1);
}

