/*
 * Decompiled with CFR 0.152.
 */
package com.airbnb.epoxy;

import android.graphics.Rect;
import android.view.View;
import androidx.annotation.IntRange;
import androidx.annotation.NonNull;
import androidx.annotation.Px;
import androidx.recyclerview.widget.RecyclerView;
import com.airbnb.epoxy.EpoxyViewHolder;

class EpoxyVisibilityItem {
    private static final int NOT_NOTIFIED = -1;
    private final Rect localVisibleRect = new Rect();
    private int adapterPosition = -1;
    @Px
    private int height;
    @Px
    private int width;
    @Px
    private int visibleHeight;
    @Px
    private int visibleWidth;
    @Px
    private int viewportHeight;
    @Px
    private int viewportWidth;
    private boolean partiallyVisible = false;
    private boolean fullyVisible = false;
    private boolean visible = false;
    private boolean focusedVisible = false;
    private int lastVisibleHeightNotified = -1;
    private int lastVisibleWidthNotified = -1;

    EpoxyVisibilityItem(int adapterPosition) {
        this.reset(adapterPosition);
    }

    boolean update(@NonNull View view, @NonNull RecyclerView parent, boolean detachEvent) {
        this.localVisibleRect.setEmpty();
        boolean viewDrawn = view.getLocalVisibleRect(this.localVisibleRect) && !detachEvent;
        this.height = view.getHeight();
        this.width = view.getWidth();
        this.viewportHeight = parent.getHeight();
        this.viewportWidth = parent.getWidth();
        this.visibleHeight = viewDrawn ? this.localVisibleRect.height() : 0;
        this.visibleWidth = viewDrawn ? this.localVisibleRect.width() : 0;
        return this.height > 0 && this.width > 0;
    }

    int getAdapterPosition() {
        return this.adapterPosition;
    }

    void reset(int newAdapterPosition) {
        this.fullyVisible = false;
        this.visible = false;
        this.focusedVisible = false;
        this.adapterPosition = newAdapterPosition;
        this.lastVisibleHeightNotified = -1;
        this.lastVisibleWidthNotified = -1;
    }

    void handleVisible(@NonNull EpoxyViewHolder epoxyHolder, boolean detachEvent) {
        boolean previousVisible = this.visible;
        boolean bl = this.visible = !detachEvent && this.isVisible();
        if (this.visible != previousVisible) {
            if (this.visible) {
                epoxyHolder.visibilityStateChanged(0);
            } else {
                epoxyHolder.visibilityStateChanged(1);
            }
        }
    }

    void handleFocus(EpoxyViewHolder epoxyHolder, boolean detachEvent) {
        boolean previousFocusedVisible = this.focusedVisible;
        boolean bl = this.focusedVisible = !detachEvent && this.isInFocusVisible();
        if (this.focusedVisible != previousFocusedVisible) {
            if (this.focusedVisible) {
                epoxyHolder.visibilityStateChanged(2);
            } else {
                epoxyHolder.visibilityStateChanged(3);
            }
        }
    }

    void handlePartialImpressionVisible(EpoxyViewHolder epoxyHolder, boolean detachEvent, @IntRange(from=0L, to=100L) int thresholdPercentage) {
        boolean previousPartiallyVisible = this.partiallyVisible;
        boolean bl = this.partiallyVisible = !detachEvent && this.isPartiallyVisible(thresholdPercentage);
        if (this.partiallyVisible != previousPartiallyVisible) {
            if (this.partiallyVisible) {
                epoxyHolder.visibilityStateChanged(5);
            } else {
                epoxyHolder.visibilityStateChanged(6);
            }
        }
    }

    void handleFullImpressionVisible(EpoxyViewHolder epoxyHolder, boolean detachEvent) {
        boolean previousFullyVisible = this.fullyVisible;
        boolean bl = this.fullyVisible = !detachEvent && this.isFullyVisible();
        if (this.fullyVisible != previousFullyVisible && this.fullyVisible) {
            epoxyHolder.visibilityStateChanged(4);
        }
    }

    boolean handleChanged(EpoxyViewHolder epoxyHolder, boolean visibilityChangedEnabled) {
        boolean changed = false;
        if (this.visibleHeight != this.lastVisibleHeightNotified || this.visibleWidth != this.lastVisibleWidthNotified) {
            if (visibilityChangedEnabled) {
                epoxyHolder.visibilityChanged(100.0f / (float)this.height * (float)this.visibleHeight, 100.0f / (float)this.width * (float)this.visibleWidth, this.visibleHeight, this.visibleWidth);
            }
            this.lastVisibleHeightNotified = this.visibleHeight;
            this.lastVisibleWidthNotified = this.visibleWidth;
            changed = true;
        }
        return changed;
    }

    private boolean isVisible() {
        return this.visibleHeight > 0 && this.visibleWidth > 0;
    }

    private boolean isInFocusVisible() {
        int halfViewportArea = this.viewportHeight * this.viewportWidth / 2;
        int totalArea = this.height * this.width;
        int visibleArea = this.visibleHeight * this.visibleWidth;
        return totalArea >= halfViewportArea ? visibleArea >= halfViewportArea : totalArea == visibleArea;
    }

    private boolean isPartiallyVisible(@IntRange(from=0L, to=100L) int thresholdPercentage) {
        if (thresholdPercentage == 0) {
            return this.isVisible();
        }
        int visibleArea = this.visibleHeight * this.visibleWidth;
        int totalArea = this.height * this.width;
        float visibleAreaPercentage = (float)visibleArea / (float)totalArea * 100.0f;
        return visibleAreaPercentage >= (float)thresholdPercentage;
    }

    private boolean isFullyVisible() {
        return this.visibleHeight == this.height && this.visibleWidth == this.width;
    }

    void shiftBy(int offsetPosition) {
        this.adapterPosition += offsetPosition;
    }
}

