/*
 * Decompiled with CFR 0.152.
 */
package com.airbnb.epoxy;

import android.os.Handler;
import androidx.annotation.AnyThread;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.recyclerview.widget.DiffUtil;
import com.airbnb.epoxy.DiffResult;
import com.airbnb.epoxy.EpoxyModel;
import com.airbnb.epoxy.HandlerExecutor;
import com.airbnb.epoxy.MainThreadExecutor;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Executor;

class AsyncEpoxyDiffer {
    private final Executor executor;
    private final ResultCallack resultCallack;
    private final DiffUtil.ItemCallback<EpoxyModel<?>> diffCallback;
    private final GenerationTracker generationTracker = new GenerationTracker();
    @Nullable
    private volatile List<? extends EpoxyModel<?>> list;
    @NonNull
    private volatile List<? extends EpoxyModel<?>> readOnlyList = Collections.emptyList();

    AsyncEpoxyDiffer(@NonNull Handler handler, @NonNull ResultCallack resultCallack, @NonNull DiffUtil.ItemCallback<EpoxyModel<?>> diffCallback) {
        this.executor = new HandlerExecutor(handler);
        this.resultCallack = resultCallack;
        this.diffCallback = diffCallback;
    }

    @AnyThread
    @NonNull
    public List<? extends EpoxyModel<?>> getCurrentList() {
        return this.readOnlyList;
    }

    @AnyThread
    public boolean cancelDiff() {
        return this.generationTracker.finishMaxGeneration();
    }

    @AnyThread
    public boolean isDiffInProgress() {
        return this.generationTracker.hasUnfinishedGeneration();
    }

    @AnyThread
    public synchronized boolean forceListOverride(@Nullable List<EpoxyModel<?>> newList) {
        boolean interruptedDiff = this.cancelDiff();
        int generation = this.generationTracker.incrementAndGetNextScheduled();
        this.tryLatchList(newList, generation);
        return interruptedDiff;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @AnyThread
    public void submitList(final @Nullable List<? extends EpoxyModel<?>> newList) {
        List<EpoxyModel<?>> previousList;
        int runGeneration;
        AsyncEpoxyDiffer asyncEpoxyDiffer = this;
        synchronized (asyncEpoxyDiffer) {
            runGeneration = this.generationTracker.incrementAndGetNextScheduled();
            previousList = this.list;
        }
        if (newList == previousList) {
            this.onRunCompleted(runGeneration, newList, DiffResult.noOp(previousList));
            return;
        }
        if (newList == null || newList.isEmpty()) {
            DiffResult result = null;
            if (previousList != null && !previousList.isEmpty()) {
                result = DiffResult.clear(previousList);
            }
            this.onRunCompleted(runGeneration, null, result);
            return;
        }
        if (previousList == null || previousList.isEmpty()) {
            this.onRunCompleted(runGeneration, newList, DiffResult.inserted(newList));
            return;
        }
        final DiffCallback wrappedCallback = new DiffCallback(previousList, newList, this.diffCallback);
        this.executor.execute(new Runnable(){

            @Override
            public void run() {
                DiffUtil.DiffResult result = DiffUtil.calculateDiff((DiffUtil.Callback)wrappedCallback);
                AsyncEpoxyDiffer.this.onRunCompleted(runGeneration, newList, DiffResult.diff(previousList, newList, result));
            }
        });
    }

    private void onRunCompleted(final int runGeneration, final @Nullable List<? extends EpoxyModel<?>> newList, final @Nullable DiffResult result) {
        MainThreadExecutor.ASYNC_INSTANCE.execute(new Runnable(){

            @Override
            public void run() {
                boolean dispatchResult = AsyncEpoxyDiffer.this.tryLatchList(newList, runGeneration);
                if (result != null && dispatchResult) {
                    AsyncEpoxyDiffer.this.resultCallack.onResult(result);
                }
            }
        });
    }

    @AnyThread
    private synchronized boolean tryLatchList(@Nullable List<? extends EpoxyModel<?>> newList, int runGeneration) {
        if (this.generationTracker.finishGeneration(runGeneration)) {
            this.list = newList;
            this.readOnlyList = newList == null ? Collections.emptyList() : Collections.unmodifiableList(newList);
            return true;
        }
        return false;
    }

    private static class DiffCallback
    extends DiffUtil.Callback {
        final List<? extends EpoxyModel<?>> oldList;
        final List<? extends EpoxyModel<?>> newList;
        private final DiffUtil.ItemCallback<EpoxyModel<?>> diffCallback;

        DiffCallback(List<? extends EpoxyModel<?>> oldList, List<? extends EpoxyModel<?>> newList, DiffUtil.ItemCallback<EpoxyModel<?>> diffCallback) {
            this.oldList = oldList;
            this.newList = newList;
            this.diffCallback = diffCallback;
        }

        public int getOldListSize() {
            return this.oldList.size();
        }

        public int getNewListSize() {
            return this.newList.size();
        }

        public boolean areItemsTheSame(int oldItemPosition, int newItemPosition) {
            return this.diffCallback.areItemsTheSame(this.oldList.get(oldItemPosition), this.newList.get(newItemPosition));
        }

        public boolean areContentsTheSame(int oldItemPosition, int newItemPosition) {
            return this.diffCallback.areContentsTheSame(this.oldList.get(oldItemPosition), this.newList.get(newItemPosition));
        }

        @Nullable
        public Object getChangePayload(int oldItemPosition, int newItemPosition) {
            return this.diffCallback.getChangePayload(this.oldList.get(oldItemPosition), this.newList.get(newItemPosition));
        }
    }

    private static class GenerationTracker {
        private volatile int maxScheduledGeneration;
        private volatile int maxFinishedGeneration;

        private GenerationTracker() {
        }

        synchronized int incrementAndGetNextScheduled() {
            return ++this.maxScheduledGeneration;
        }

        synchronized boolean finishMaxGeneration() {
            boolean isInterrupting = this.hasUnfinishedGeneration();
            this.maxFinishedGeneration = this.maxScheduledGeneration;
            return isInterrupting;
        }

        synchronized boolean hasUnfinishedGeneration() {
            return this.maxScheduledGeneration > this.maxFinishedGeneration;
        }

        synchronized boolean finishGeneration(int runGeneration) {
            boolean isLatestGeneration;
            boolean bl = isLatestGeneration = this.maxScheduledGeneration == runGeneration && runGeneration > this.maxFinishedGeneration;
            if (isLatestGeneration) {
                this.maxFinishedGeneration = runGeneration;
            }
            return isLatestGeneration;
        }
    }

    static interface ResultCallack {
        public void onResult(@NonNull DiffResult var1);
    }
}

