/*
 * Decompiled with CFR 0.152.
 */
package com.airbnb.epoxy;

import android.graphics.Canvas;
import android.view.View;
import androidx.annotation.Nullable;
import androidx.recyclerview.widget.RecyclerView;
import com.airbnb.epoxy.EpoxyController;
import com.airbnb.epoxy.EpoxyDragCallback;
import com.airbnb.epoxy.EpoxyModel;
import com.airbnb.epoxy.EpoxySwipeCallback;
import com.airbnb.epoxy.EpoxyTouchHelperCallback;
import com.airbnb.epoxy.EpoxyViewHolder;
import com.airbnb.viewmodeladapter.R;

public abstract class EpoxyModelTouchCallback<T extends EpoxyModel>
extends EpoxyTouchHelperCallback
implements EpoxyDragCallback<T>,
EpoxySwipeCallback<T> {
    private static final int TOUCH_DEBOUNCE_MILLIS = 300;
    @Nullable
    private final EpoxyController controller;
    private final Class<T> targetModelClass;
    private EpoxyViewHolder holderBeingDragged;
    private EpoxyViewHolder holderBeingSwiped;

    public EpoxyModelTouchCallback(@Nullable EpoxyController controller, Class<T> targetModelClass) {
        this.controller = controller;
        this.targetModelClass = targetModelClass;
    }

    @Override
    protected int getMovementFlags(RecyclerView recyclerView, EpoxyViewHolder viewHolder) {
        boolean isOtherCallbackActive;
        EpoxyModel<?> model = viewHolder.getModel();
        boolean bl = isOtherCallbackActive = this.holderBeingDragged == null && this.holderBeingSwiped == null && this.recyclerViewHasSelection(recyclerView);
        if (!isOtherCallbackActive && this.isTouchableModel(model)) {
            return this.getMovementFlagsForModel(model, viewHolder.getAdapterPosition());
        }
        return 0;
    }

    @Override
    protected boolean canDropOver(RecyclerView recyclerView, EpoxyViewHolder current, EpoxyViewHolder target) {
        return this.isTouchableModel(target.getModel());
    }

    protected boolean isTouchableModel(EpoxyModel<?> model) {
        return this.targetModelClass.isInstance(model);
    }

    @Override
    protected boolean onMove(RecyclerView recyclerView, EpoxyViewHolder viewHolder, EpoxyViewHolder target) {
        if (this.controller == null) {
            throw new IllegalStateException("A controller must be provided in the constructor if dragging is enabled");
        }
        int fromPosition = viewHolder.getAdapterPosition();
        int toPosition = target.getAdapterPosition();
        this.controller.moveModel(fromPosition, toPosition);
        EpoxyModel<?> model = viewHolder.getModel();
        if (!this.isTouchableModel(model)) {
            throw new IllegalStateException("A model was dragged that is not a valid target: " + model.getClass());
        }
        this.onModelMoved(fromPosition, toPosition, model, viewHolder.itemView);
        return true;
    }

    @Override
    public void onModelMoved(int fromPosition, int toPosition, T modelBeingMoved, View itemView) {
    }

    @Override
    protected void onSwiped(EpoxyViewHolder viewHolder, int direction) {
        EpoxyModel<?> model = viewHolder.getModel();
        View view = viewHolder.itemView;
        int position = viewHolder.getAdapterPosition();
        if (!this.isTouchableModel(model)) {
            throw new IllegalStateException("A model was swiped that is not a valid target: " + model.getClass());
        }
        this.onSwipeCompleted(model, view, position, direction);
    }

    @Override
    public void onSwipeCompleted(T model, View itemView, int position, int direction) {
    }

    @Override
    protected void onSelectedChanged(@Nullable EpoxyViewHolder viewHolder, int actionState) {
        super.onSelectedChanged(viewHolder, actionState);
        if (viewHolder != null) {
            EpoxyModel<?> model = viewHolder.getModel();
            if (!this.isTouchableModel(model)) {
                throw new IllegalStateException("A model was selected that is not a valid target: " + model.getClass());
            }
            this.markRecyclerViewHasSelection((RecyclerView)viewHolder.itemView.getParent());
            if (actionState == 1) {
                this.holderBeingSwiped = viewHolder;
                this.onSwipeStarted(model, viewHolder.itemView, viewHolder.getAdapterPosition());
            } else if (actionState == 2) {
                this.holderBeingDragged = viewHolder;
                this.onDragStarted(model, viewHolder.itemView, viewHolder.getAdapterPosition());
            }
        } else if (this.holderBeingDragged != null) {
            this.onDragReleased(this.holderBeingDragged.getModel(), this.holderBeingDragged.itemView);
            this.holderBeingDragged = null;
        } else if (this.holderBeingSwiped != null) {
            this.onSwipeReleased(this.holderBeingSwiped.getModel(), this.holderBeingSwiped.itemView);
            this.holderBeingSwiped = null;
        }
    }

    private void markRecyclerViewHasSelection(RecyclerView recyclerView) {
        recyclerView.setTag(R.id.epoxy_touch_helper_selection_status, (Object)Boolean.TRUE);
    }

    private boolean recyclerViewHasSelection(RecyclerView recyclerView) {
        return recyclerView.getTag(R.id.epoxy_touch_helper_selection_status) != null;
    }

    private void clearRecyclerViewSelectionMarker(RecyclerView recyclerView) {
        recyclerView.setTag(R.id.epoxy_touch_helper_selection_status, null);
    }

    @Override
    public void onSwipeStarted(T model, View itemView, int adapterPosition) {
    }

    @Override
    public void onSwipeReleased(T model, View itemView) {
    }

    @Override
    public void onDragStarted(T model, View itemView, int adapterPosition) {
    }

    @Override
    public void onDragReleased(T model, View itemView) {
    }

    @Override
    protected void clearView(final RecyclerView recyclerView, EpoxyViewHolder viewHolder) {
        super.clearView(recyclerView, viewHolder);
        this.clearView(viewHolder.getModel(), viewHolder.itemView);
        recyclerView.postDelayed(new Runnable(){

            @Override
            public void run() {
                EpoxyModelTouchCallback.this.clearRecyclerViewSelectionMarker(recyclerView);
            }
        }, 300L);
    }

    @Override
    public void clearView(T model, View itemView) {
    }

    @Override
    protected void onChildDraw(Canvas c, RecyclerView recyclerView, EpoxyViewHolder viewHolder, float dX, float dY, int actionState, boolean isCurrentlyActive) {
        super.onChildDraw(c, recyclerView, viewHolder, dX, dY, actionState, isCurrentlyActive);
        EpoxyModel<?> model = viewHolder.getModel();
        if (!this.isTouchableModel(model)) {
            throw new IllegalStateException("A model was selected that is not a valid target: " + model.getClass());
        }
        View itemView = viewHolder.itemView;
        float swipeProgress = Math.abs(dX) > Math.abs(dY) ? dX / (float)itemView.getWidth() : dY / (float)itemView.getHeight();
        float clampedProgress = Math.max(-1.0f, Math.min(1.0f, swipeProgress));
        this.onSwipeProgressChanged(model, itemView, clampedProgress, c);
    }

    @Override
    public void onSwipeProgressChanged(T model, View itemView, float swipeProgress, Canvas canvas) {
    }
}

