/*
 * Decompiled with CFR 0.152.
 */
package com.airbnb.epoxy;

import android.content.Context;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.ViewGroup;
import androidx.annotation.CallSuper;
import androidx.annotation.DimenRes;
import androidx.annotation.Dimension;
import androidx.annotation.Px;
import androidx.recyclerview.widget.GridLayoutManager;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import com.airbnb.epoxy.ActivityRecyclerPool;
import com.airbnb.epoxy.ActivityRecyclerPoolKt;
import com.airbnb.epoxy.EpoxyController;
import com.airbnb.epoxy.EpoxyItemSpacingDecorator;
import com.airbnb.epoxy.EpoxyModel;
import com.airbnb.epoxy.EpoxyRecyclerView;
import com.airbnb.epoxy.SimpleEpoxyController;
import com.airbnb.epoxy.UnboundedViewPool;
import com.airbnb.viewmodeladapter.R;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000|\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0019\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0016\u0018\u0000 I2\u00020\u0001:\u0004IJKLB%\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u000e\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aJ\b\u0010\u001b\u001a\u00020\u0018H\u0016J\b\u0010\u001c\u001a\u00020\u0018H\u0002J\b\u0010\u001d\u001a\u00020\u0018H\u0002J\b\u0010\u001e\u001a\u00020\u001fH\u0014J\b\u0010 \u001a\u00020!H\u0014J\u0012\u0010\"\u001a\u00020\u00072\b\b\u0001\u0010#\u001a\u00020\u0007H\u0005J\b\u0010$\u001a\u00020\u0018H\u0015J\b\u0010%\u001a\u00020\u0018H\u0002J\b\u0010&\u001a\u00020\u0018H\u0016J\b\u0010'\u001a\u00020\u0018H\u0016J\b\u0010(\u001a\u00020\u0018H\u0002J\b\u0010)\u001a\u00020\u0018H\u0016J\u0006\u0010*\u001a\u00020\u0018J\u0012\u0010+\u001a\u00020\u00072\b\b\u0001\u0010,\u001a\u00020\u0007H\u0005J\u0016\u0010-\u001a\u00020\u00182\f\u0010.\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0012H\u0016J\u000e\u0010/\u001a\u00020\u00182\u0006\u00100\u001a\u00020\u000bJ\u000e\u00101\u001a\u00020\u00182\u0006\u00100\u001a\u00020\u000bJ\u000e\u00102\u001a\u00020\u00182\u0006\u0010\t\u001a\u00020\u0007J\u0010\u00103\u001a\u00020\u00182\b\b\u0001\u0010#\u001a\u00020\u0007J\u0010\u00104\u001a\u00020\u00182\b\b\u0001\u00105\u001a\u00020\u0007J\u0010\u00106\u001a\u00020\u00182\b\b\u0001\u0010,\u001a\u00020\u0007J\u0012\u00107\u001a\u00020\u00182\b\u00108\u001a\u0004\u0018\u00010\u001fH\u0016J\u0010\u00109\u001a\u00020\u00182\u0006\u0010:\u001a\u00020;H\u0016J\u001a\u0010<\u001a\u00020\u00182\u0010\u0010=\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030?0>H\u0016J\u000e\u0010@\u001a\u00020\u00182\u0006\u0010\u0010\u001a\u00020\rJ\b\u0010A\u001a\u00020\rH\u0016J\u001e\u0010B\u001a\u00020\u00182\f\u0010.\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00122\u0006\u0010C\u001a\u00020\rH\u0016J\b\u0010D\u001a\u00020\u0018H\u0002J\u001f\u0010E\u001a\u00020\u00182\u0017\u0010F\u001a\u0013\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u00180G\u00a2\u0006\u0002\bHR\u000e\u0010\t\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0011\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0013\u001a\u00020\u0014X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016\u00a8\u0006M"}, d2={"Lcom/airbnb/epoxy/EpoxyRecyclerView;", "Landroidx/recyclerview/widget/RecyclerView;", "context", "Landroid/content/Context;", "attrs", "Landroid/util/AttributeSet;", "defStyleAttr", "", "(Landroid/content/Context;Landroid/util/AttributeSet;I)V", "delayMsWhenRemovingAdapterOnDetach", "epoxyController", "Lcom/airbnb/epoxy/EpoxyController;", "isRemoveAdapterRunnablePosted", "", "removeAdapterRunnable", "Ljava/lang/Runnable;", "removeAdapterWhenDetachedFromWindow", "removedAdapter", "Landroidx/recyclerview/widget/RecyclerView$Adapter;", "spacingDecorator", "Lcom/airbnb/epoxy/EpoxyItemSpacingDecorator;", "getSpacingDecorator", "()Lcom/airbnb/epoxy/EpoxyItemSpacingDecorator;", "buildModelsWith", "", "callback", "Lcom/airbnb/epoxy/EpoxyRecyclerView$ModelBuilderCallback;", "clear", "clearPoolIfActivityIsDestroyed", "clearRemovedAdapterAndCancelRunnable", "createLayoutManager", "Landroidx/recyclerview/widget/RecyclerView$LayoutManager;", "createViewPool", "Landroidx/recyclerview/widget/RecyclerView$RecycledViewPool;", "dpToPx", "dp", "init", "initViewPool", "onAttachedToWindow", "onDetachedFromWindow", "removeAdapter", "requestLayout", "requestModelBuild", "resToPx", "itemSpacingRes", "setAdapter", "adapter", "setController", "controller", "setControllerAndBuildModels", "setDelayMsWhenRemovingAdapterOnDetach", "setItemSpacingDp", "setItemSpacingPx", "spacingPx", "setItemSpacingRes", "setLayoutManager", "layout", "setLayoutParams", "params", "Landroid/view/ViewGroup$LayoutParams;", "setModels", "models", "", "Lcom/airbnb/epoxy/EpoxyModel;", "setRemoveAdapterWhenDetachedFromWindow", "shouldShareViewPoolAcrossContext", "swapAdapter", "removeAndRecycleExistingViews", "syncSpanCount", "withModels", "buildModels", "Lkotlin/Function1;", "Lkotlin/ExtensionFunctionType;", "Companion", "ModelBuilderCallback", "ModelBuilderCallbackController", "WithModelsController", "epoxy-adapter_release"})
public class EpoxyRecyclerView
extends RecyclerView {
    @NotNull
    private final EpoxyItemSpacingDecorator spacingDecorator;
    private EpoxyController epoxyController;
    private RecyclerView.Adapter<?> removedAdapter;
    private boolean removeAdapterWhenDetachedFromWindow;
    private int delayMsWhenRemovingAdapterOnDetach;
    private boolean isRemoveAdapterRunnablePosted;
    private final Runnable removeAdapterRunnable;
    private static final int DEFAULT_ADAPTER_REMOVAL_DELAY_MS = 2000;
    private static final ActivityRecyclerPool ACTIVITY_RECYCLER_POOL;
    public static final Companion Companion;

    @NotNull
    protected final EpoxyItemSpacingDecorator getSpacingDecorator() {
        return this.spacingDecorator;
    }

    public final void setRemoveAdapterWhenDetachedFromWindow(boolean removeAdapterWhenDetachedFromWindow) {
        this.removeAdapterWhenDetachedFromWindow = removeAdapterWhenDetachedFromWindow;
    }

    public final void setDelayMsWhenRemovingAdapterOnDetach(int delayMsWhenRemovingAdapterOnDetach) {
        this.delayMsWhenRemovingAdapterOnDetach = delayMsWhenRemovingAdapterOnDetach;
    }

    @CallSuper
    protected void init() {
        this.setClipToPadding(false);
        this.initViewPool();
    }

    private final void initViewPool() {
        if (!this.shouldShareViewPoolAcrossContext()) {
            this.setRecycledViewPool(this.createViewPool());
            return;
        }
        Context context = this.getContext();
        Intrinsics.checkExpressionValueIsNotNull((Object)context, (String)"context");
        this.setRecycledViewPool(ACTIVITY_RECYCLER_POOL.getPool(context, (Function0<? extends RecyclerView.RecycledViewPool>)((Function0)new Function0<RecyclerView.RecycledViewPool>(this){
            final /* synthetic */ EpoxyRecyclerView this$0;

            @NotNull
            public final RecyclerView.RecycledViewPool invoke() {
                return this.this$0.createViewPool();
            }
            {
                this.this$0 = epoxyRecyclerView;
                super(0);
            }
        })).getViewPool());
    }

    @NotNull
    protected RecyclerView.RecycledViewPool createViewPool() {
        return new UnboundedViewPool();
    }

    public boolean shouldShareViewPoolAcrossContext() {
        return true;
    }

    public void setLayoutParams(@NotNull ViewGroup.LayoutParams params) {
        Intrinsics.checkParameterIsNotNull((Object)params, (String)"params");
        boolean isFirstParams = this.getLayoutParams() == null;
        super.setLayoutParams(params);
        if (isFirstParams && this.getLayoutManager() == null) {
            this.setLayoutManager(this.createLayoutManager());
        }
    }

    @NotNull
    protected RecyclerView.LayoutManager createLayoutManager() {
        ViewGroup.LayoutParams layoutParams = this.getLayoutParams();
        if (layoutParams.height == -1 || layoutParams.height == 0) {
            if (layoutParams.width == -1 || layoutParams.width == 0) {
                this.setHasFixedSize(true);
            }
            return (RecyclerView.LayoutManager)new LinearLayoutManager(this.getContext());
        }
        return (RecyclerView.LayoutManager)new LinearLayoutManager(this.getContext(), 0, false);
    }

    public void setLayoutManager(@Nullable RecyclerView.LayoutManager layout2) {
        super.setLayoutManager(layout2);
        this.syncSpanCount();
    }

    private final void syncSpanCount() {
        RecyclerView.LayoutManager layout2 = this.getLayoutManager();
        EpoxyController controller = this.epoxyController;
        if (layout2 instanceof GridLayoutManager && controller != null && (controller.getSpanCount() != ((GridLayoutManager)layout2).getSpanCount() || ((GridLayoutManager)layout2).getSpanSizeLookup() != controller.getSpanSizeLookup())) {
            controller.setSpanCount(((GridLayoutManager)layout2).getSpanCount());
            ((GridLayoutManager)layout2).setSpanSizeLookup(controller.getSpanSizeLookup());
        }
    }

    public void requestLayout() {
        this.syncSpanCount();
        super.requestLayout();
    }

    public final void setItemSpacingRes(@DimenRes int itemSpacingRes) {
        this.setItemSpacingPx(this.resToPx(itemSpacingRes));
    }

    public final void setItemSpacingDp(@Dimension(unit=0) int dp) {
        this.setItemSpacingPx(this.dpToPx(dp));
    }

    public final void setItemSpacingPx(@Px int spacingPx) {
        this.removeItemDecoration(this.spacingDecorator);
        this.spacingDecorator.setPxBetweenItems(spacingPx);
        if (spacingPx > 0) {
            this.addItemDecoration(this.spacingDecorator);
        }
    }

    public void setModels(@NotNull List<? extends EpoxyModel<?>> models) {
        SimpleEpoxyController simpleEpoxyController;
        Intrinsics.checkParameterIsNotNull(models, (String)"models");
        EpoxyController epoxyController = this.epoxyController;
        if (!(epoxyController instanceof SimpleEpoxyController)) {
            epoxyController = null;
        }
        if ((simpleEpoxyController = (SimpleEpoxyController)epoxyController) == null) {
            SimpleEpoxyController simpleEpoxyController2 = new SimpleEpoxyController();
            boolean bl = false;
            boolean bl2 = false;
            SimpleEpoxyController it = simpleEpoxyController2;
            boolean bl3 = false;
            this.setController(it);
            simpleEpoxyController = simpleEpoxyController2;
        }
        SimpleEpoxyController controller = simpleEpoxyController;
        controller.setModels(models);
    }

    public final void setController(@NotNull EpoxyController controller) {
        Intrinsics.checkParameterIsNotNull((Object)controller, (String)"controller");
        this.epoxyController = controller;
        this.setAdapter(controller.getAdapter());
        this.syncSpanCount();
    }

    public final void setControllerAndBuildModels(@NotNull EpoxyController controller) {
        Intrinsics.checkParameterIsNotNull((Object)controller, (String)"controller");
        controller.requestModelBuild();
        this.setController(controller);
    }

    public final void withModels(@NotNull Function1<? super EpoxyController, Unit> buildModels) {
        WithModelsController withModelsController;
        Intrinsics.checkParameterIsNotNull(buildModels, (String)"buildModels");
        EpoxyController epoxyController = this.epoxyController;
        if (!(epoxyController instanceof WithModelsController)) {
            epoxyController = null;
        }
        if ((withModelsController = (WithModelsController)epoxyController) == null) {
            WithModelsController withModelsController2 = new WithModelsController();
            boolean bl = false;
            boolean bl2 = false;
            WithModelsController it = withModelsController2;
            boolean bl3 = false;
            this.setController(it);
            withModelsController = withModelsController2;
        }
        WithModelsController controller = withModelsController;
        controller.setCallback(buildModels);
        controller.requestModelBuild();
    }

    public final void buildModelsWith(@NotNull ModelBuilderCallback callback2) {
        ModelBuilderCallbackController modelBuilderCallbackController;
        Intrinsics.checkParameterIsNotNull((Object)callback2, (String)"callback");
        EpoxyController epoxyController = this.epoxyController;
        if (!(epoxyController instanceof ModelBuilderCallbackController)) {
            epoxyController = null;
        }
        if ((modelBuilderCallbackController = (ModelBuilderCallbackController)epoxyController) == null) {
            ModelBuilderCallbackController modelBuilderCallbackController2 = new ModelBuilderCallbackController();
            boolean bl = false;
            boolean bl2 = false;
            ModelBuilderCallbackController it = modelBuilderCallbackController2;
            boolean bl3 = false;
            this.setController(it);
            modelBuilderCallbackController = modelBuilderCallbackController2;
        }
        ModelBuilderCallbackController controller = modelBuilderCallbackController;
        controller.setCallback(callback2);
        controller.requestModelBuild();
    }

    public final void requestModelBuild() {
        if (this.epoxyController == null) {
            throw (Throwable)new IllegalStateException("A controller must be set before requesting a model build.");
        }
        if (this.epoxyController instanceof SimpleEpoxyController) {
            throw (Throwable)new IllegalStateException("Models were set with #setModels, they can not be rebuilt.");
        }
        EpoxyController epoxyController = this.epoxyController;
        if (epoxyController == null) {
            Intrinsics.throwNpe();
        }
        epoxyController.requestModelBuild();
    }

    public void clear() {
        EpoxyController epoxyController = this.epoxyController;
        if (epoxyController != null) {
            epoxyController.cancelPendingModelBuild();
        }
        this.epoxyController = null;
        this.swapAdapter(null, true);
    }

    @Px
    protected final int dpToPx(@Dimension(unit=0) int dp) {
        float f = dp;
        Resources resources = this.getResources();
        Intrinsics.checkExpressionValueIsNotNull((Object)resources, (String)"resources");
        return (int)TypedValue.applyDimension((int)1, (float)f, (DisplayMetrics)resources.getDisplayMetrics());
    }

    @Px
    protected final int resToPx(@DimenRes int itemSpacingRes) {
        return this.getResources().getDimensionPixelOffset(itemSpacingRes);
    }

    public void setAdapter(@Nullable RecyclerView.Adapter<?> adapter) {
        super.setAdapter(adapter);
        this.clearRemovedAdapterAndCancelRunnable();
    }

    public void swapAdapter(@Nullable RecyclerView.Adapter<?> adapter, boolean removeAndRecycleExistingViews) {
        super.swapAdapter(adapter, removeAndRecycleExistingViews);
        this.clearRemovedAdapterAndCancelRunnable();
    }

    public void onAttachedToWindow() {
        super.onAttachedToWindow();
        if (this.removedAdapter != null) {
            this.swapAdapter(this.removedAdapter, false);
        }
        this.clearRemovedAdapterAndCancelRunnable();
    }

    public void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        if (this.removeAdapterWhenDetachedFromWindow) {
            if (this.delayMsWhenRemovingAdapterOnDetach > 0) {
                this.isRemoveAdapterRunnablePosted = true;
                this.postDelayed(this.removeAdapterRunnable, this.delayMsWhenRemovingAdapterOnDetach);
            } else {
                this.removeAdapter();
            }
        }
        this.clearPoolIfActivityIsDestroyed();
    }

    private final void removeAdapter() {
        RecyclerView.Adapter currentAdapter = this.getAdapter();
        if (currentAdapter != null) {
            this.swapAdapter(null, true);
            this.removedAdapter = currentAdapter;
        }
        this.clearPoolIfActivityIsDestroyed();
    }

    private final void clearRemovedAdapterAndCancelRunnable() {
        this.removedAdapter = null;
        if (this.isRemoveAdapterRunnablePosted) {
            this.removeCallbacks(this.removeAdapterRunnable);
            this.isRemoveAdapterRunnablePosted = false;
        }
    }

    private final void clearPoolIfActivityIsDestroyed() {
        if (ActivityRecyclerPoolKt.isActivityDestroyed(this.getContext())) {
            this.getRecycledViewPool().clear();
        }
    }

    @JvmOverloads
    public EpoxyRecyclerView(@NotNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        super(context, attrs, defStyleAttr);
        this.spacingDecorator = new EpoxyItemSpacingDecorator();
        this.removeAdapterWhenDetachedFromWindow = true;
        this.delayMsWhenRemovingAdapterOnDetach = 2000;
        this.removeAdapterRunnable = new Runnable(this){
            final /* synthetic */ EpoxyRecyclerView this$0;

            public final void run() {
                if (EpoxyRecyclerView.access$isRemoveAdapterRunnablePosted$p(this.this$0)) {
                    EpoxyRecyclerView.access$setRemoveAdapterRunnablePosted$p(this.this$0, false);
                    EpoxyRecyclerView.access$removeAdapter(this.this$0);
                }
            }
            {
                this.this$0 = epoxyRecyclerView;
            }
        };
        if (attrs != null) {
            TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.EpoxyRecyclerView, defStyleAttr, 0);
            this.setItemSpacingPx(a.getDimensionPixelSize(R.styleable.EpoxyRecyclerView_itemSpacing, 0));
            a.recycle();
        }
        this.init();
    }

    @JvmOverloads
    public /* synthetic */ EpoxyRecyclerView(Context context, AttributeSet attributeSet, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            attributeSet = null;
        }
        if ((n2 & 4) != 0) {
            n = 0;
        }
        this(context, attributeSet, n);
    }

    @JvmOverloads
    public EpoxyRecyclerView(@NotNull Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, 0, 4, null);
    }

    @JvmOverloads
    public EpoxyRecyclerView(@NotNull Context context) {
        this(context, null, 0, 6, null);
    }

    static {
        Companion = new Companion(null);
        ACTIVITY_RECYCLER_POOL = new ActivityRecyclerPool();
    }

    public static final /* synthetic */ boolean access$isRemoveAdapterRunnablePosted$p(EpoxyRecyclerView $this) {
        return $this.isRemoveAdapterRunnablePosted;
    }

    public static final /* synthetic */ void access$setRemoveAdapterRunnablePosted$p(EpoxyRecyclerView $this, boolean bl) {
        $this.isRemoveAdapterRunnablePosted = bl;
    }

    public static final /* synthetic */ void access$removeAdapter(EpoxyRecyclerView $this) {
        $this.removeAdapter();
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u000b\u001a\u00020\u0005H\u0014R+\u0010\u0003\u001a\u0013\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\u0002\b\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\n\u00a8\u0006\f"}, d2={"Lcom/airbnb/epoxy/EpoxyRecyclerView$WithModelsController;", "Lcom/airbnb/epoxy/EpoxyController;", "()V", "callback", "Lkotlin/Function1;", "", "Lkotlin/ExtensionFunctionType;", "getCallback", "()Lkotlin/jvm/functions/Function1;", "setCallback", "(Lkotlin/jvm/functions/Function1;)V", "buildModels", "epoxy-adapter_release"})
    private static final class WithModelsController
    extends EpoxyController {
        @NotNull
        private Function1<? super EpoxyController, Unit> callback = callback.1.INSTANCE;

        @NotNull
        public final Function1<EpoxyController, Unit> getCallback() {
            return this.callback;
        }

        public final void setCallback(@NotNull Function1<? super EpoxyController, Unit> function1) {
            Intrinsics.checkParameterIsNotNull(function1, (String)"<set-?>");
            this.callback = function1;
        }

        @Override
        protected void buildModels() {
            this.callback.invoke((Object)this);
        }
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\t\u001a\u00020\nH\u0014R\u001a\u0010\u0003\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\b\u00a8\u0006\u000b"}, d2={"Lcom/airbnb/epoxy/EpoxyRecyclerView$ModelBuilderCallbackController;", "Lcom/airbnb/epoxy/EpoxyController;", "()V", "callback", "Lcom/airbnb/epoxy/EpoxyRecyclerView$ModelBuilderCallback;", "getCallback", "()Lcom/airbnb/epoxy/EpoxyRecyclerView$ModelBuilderCallback;", "setCallback", "(Lcom/airbnb/epoxy/EpoxyRecyclerView$ModelBuilderCallback;)V", "buildModels", "", "epoxy-adapter_release"})
    private static final class ModelBuilderCallbackController
    extends EpoxyController {
        @NotNull
        private ModelBuilderCallback callback = new ModelBuilderCallback(){

            public void buildModels(@NotNull EpoxyController controller) {
                Intrinsics.checkParameterIsNotNull((Object)controller, (String)"controller");
            }
        };

        @NotNull
        public final ModelBuilderCallback getCallback() {
            return this.callback;
        }

        public final void setCallback(@NotNull ModelBuilderCallback modelBuilderCallback) {
            Intrinsics.checkParameterIsNotNull((Object)modelBuilderCallback, (String)"<set-?>");
            this.callback = modelBuilderCallback;
        }

        @Override
        protected void buildModels() {
            this.callback.buildModels(this);
        }
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\bf\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H&\u00a8\u0006\u0006"}, d2={"Lcom/airbnb/epoxy/EpoxyRecyclerView$ModelBuilderCallback;", "", "buildModels", "", "controller", "Lcom/airbnb/epoxy/EpoxyController;", "epoxy-adapter_release"})
    public static interface ModelBuilderCallback {
        public void buildModels(@NotNull EpoxyController var1);
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/airbnb/epoxy/EpoxyRecyclerView$Companion;", "", "()V", "ACTIVITY_RECYCLER_POOL", "Lcom/airbnb/epoxy/ActivityRecyclerPool;", "DEFAULT_ADAPTER_REMOVAL_DELAY_MS", "", "epoxy-adapter_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

