/*
 * Decompiled with CFR 0.152.
 */
package com.airbnb.epoxy;

import android.view.View;
import android.widget.CompoundButton;
import com.airbnb.epoxy.EpoxyModel;
import com.airbnb.epoxy.EpoxyViewHolder;
import com.airbnb.epoxy.ListenersUtils;
import com.airbnb.epoxy.OnModelCheckedChangeListener;

public class WrappedEpoxyModelCheckedChangeListener<T extends EpoxyModel<?>, V>
implements CompoundButton.OnCheckedChangeListener {
    private final OnModelCheckedChangeListener<T, V> originalCheckedChangeListener;

    public WrappedEpoxyModelCheckedChangeListener(OnModelCheckedChangeListener<T, V> checkedListener) {
        if (checkedListener == null) {
            throw new IllegalArgumentException("Checked change listener cannot be null");
        }
        this.originalCheckedChangeListener = checkedListener;
    }

    public void onCheckedChanged(CompoundButton button, boolean isChecked) {
        EpoxyViewHolder epoxyHolder = ListenersUtils.getEpoxyHolderForChildView((View)button);
        if (epoxyHolder == null) {
            throw new IllegalStateException("Could not find RecyclerView holder for clicked view");
        }
        int adapterPosition = epoxyHolder.getAdapterPosition();
        if (adapterPosition != -1) {
            this.originalCheckedChangeListener.onChecked(epoxyHolder.getModel(), epoxyHolder.objectToBind(), button, isChecked, adapterPosition);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof WrappedEpoxyModelCheckedChangeListener)) {
            return false;
        }
        WrappedEpoxyModelCheckedChangeListener that = (WrappedEpoxyModelCheckedChangeListener)o;
        return this.originalCheckedChangeListener.equals(that.originalCheckedChangeListener);
    }

    public int hashCode() {
        return this.originalCheckedChangeListener.hashCode();
    }
}

