/*
 * Decompiled with CFR 0.152.
 */
package com.airbnb.epoxy;

import android.view.View;
import android.view.ViewGroup;
import com.airbnb.epoxy.EpoxyModel;
import com.airbnb.epoxy.EpoxyViewHolder;
import com.airbnb.epoxy.ListenersUtils;
import com.airbnb.epoxy.ModelGroupHolder;
import com.airbnb.epoxy.OnModelClickListener;
import com.airbnb.epoxy.OnModelLongClickListener;
import com.airbnb.epoxy.WrappedEpoxyModelClickListener;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010)\n\u0002\b\u0003\u0018\u0000*\f\b\u0000\u0010\u0001*\u0006\u0012\u0002\b\u00030\u0002*\u0004\b\u0001\u0010\u00032\u00020\u00042\u00020\u0005:\u0001%B\u001d\b\u0016\u0012\u0014\u0010\u0006\u001a\u0010\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\bB\u001d\b\u0016\u0012\u0014\u0010\u0006\u001a\u0010\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0018\u00010\t\u00a2\u0006\u0002\u0010\nJ\u0013\u0010\u0016\u001a\u00020\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u0019H\u0096\u0002J\u0012\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\u0006\u0010\u001c\u001a\u00020\u000fH\u0002J\b\u0010\u001d\u001a\u00020\u001eH\u0016J\u0010\u0010\u001f\u001a\u00020 2\u0006\u0010\u001c\u001a\u00020\u000fH\u0016J\u0010\u0010!\u001a\u00020\u00172\u0006\u0010\u001c\u001a\u00020\u000fH\u0016J\u0018\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u000f0#*\u00020\u0013H\u0080\u0002\u00a2\u0006\u0002\b$R\u001c\u0010\u000b\u001a\u0010\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0018\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\f\u001a\u0010\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0018\u00010\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e*\u00020\u000f8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u001e\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e*\u00020\u00138@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006&"}, d2={"Lcom/airbnb/epoxy/WrappedEpoxyModelClickListener;", "T", "Lcom/airbnb/epoxy/EpoxyModel;", "V", "Landroid/view/View$OnClickListener;", "Landroid/view/View$OnLongClickListener;", "clickListener", "Lcom/airbnb/epoxy/OnModelClickListener;", "(Lcom/airbnb/epoxy/OnModelClickListener;)V", "Lcom/airbnb/epoxy/OnModelLongClickListener;", "(Lcom/airbnb/epoxy/OnModelLongClickListener;)V", "originalClickListener", "originalLongClickListener", "allViewsInHierarchy", "Lkotlin/sequences/Sequence;", "Landroid/view/View;", "getAllViewsInHierarchy", "(Landroid/view/View;)Lkotlin/sequences/Sequence;", "children", "Landroid/view/ViewGroup;", "getChildren$epoxy_adapter_release", "(Landroid/view/ViewGroup;)Lkotlin/sequences/Sequence;", "equals", "", "other", "", "getClickedModelInfo", "Lcom/airbnb/epoxy/WrappedEpoxyModelClickListener$ClickedModelInfo;", "view", "hashCode", "", "onClick", "", "onLongClick", "iterator", "", "iterator$epoxy_adapter_release", "ClickedModelInfo", "epoxy-adapter_release"})
public final class WrappedEpoxyModelClickListener<T extends EpoxyModel<?>, V>
implements View.OnClickListener,
View.OnLongClickListener {
    private final OnModelClickListener<T, V> originalClickListener;
    private final OnModelLongClickListener<T, V> originalLongClickListener;

    public void onClick(@NotNull View view) {
        EpoxyModel<?> epoxyModel;
        Intrinsics.checkParameterIsNotNull((Object)view, (String)"view");
        ClickedModelInfo clickedModelInfo = this.getClickedModelInfo(view);
        if (clickedModelInfo == null) {
            return;
        }
        ClickedModelInfo modelInfo = clickedModelInfo;
        OnModelClickListener<EpoxyModel<?>, Object> onModelClickListener = this.originalClickListener;
        if (onModelClickListener != null) {
            epoxyModel = modelInfo.getModel();
            if (epoxyModel == null) {
                throw new TypeCastException("null cannot be cast to non-null type T");
            }
        } else {
            String string = "Original click listener is null";
            boolean bl = false;
            throw (Throwable)new IllegalStateException(string.toString());
        }
        onModelClickListener.onClick(epoxyModel, modelInfo.getBoundObject(), view, modelInfo.getAdapterPosition());
    }

    public boolean onLongClick(@NotNull View view) {
        EpoxyModel<?> epoxyModel;
        Intrinsics.checkParameterIsNotNull((Object)view, (String)"view");
        ClickedModelInfo clickedModelInfo = this.getClickedModelInfo(view);
        if (clickedModelInfo == null) {
            return false;
        }
        ClickedModelInfo modelInfo = clickedModelInfo;
        OnModelLongClickListener<EpoxyModel<?>, Object> onModelLongClickListener = this.originalLongClickListener;
        if (onModelLongClickListener != null) {
            epoxyModel = modelInfo.getModel();
            if (epoxyModel == null) {
                throw new TypeCastException("null cannot be cast to non-null type T");
            }
        } else {
            String string = "Original long click listener is null";
            boolean bl = false;
            throw (Throwable)new IllegalStateException(string.toString());
        }
        return onModelLongClickListener.onLongClick(epoxyModel, modelInfo.getBoundObject(), view, modelInfo.getAdapterPosition());
    }

    private final ClickedModelInfo getClickedModelInfo(View view) {
        EpoxyViewHolder epoxyViewHolder;
        EpoxyViewHolder epoxyViewHolder2 = ListenersUtils.getEpoxyHolderForChildView(view);
        if (epoxyViewHolder2 == null) {
            String string = "Could not find RecyclerView holder for clicked view";
            boolean bl = false;
            throw (Throwable)new IllegalStateException(string.toString());
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)((Object)epoxyViewHolder2), (String)"ListenersUtils.getEpoxyH\u2026holder for clicked view\")");
        EpoxyViewHolder epoxyHolder = epoxyViewHolder2;
        int adapterPosition = epoxyHolder.getAdapterPosition();
        if (adapterPosition == -1) {
            return null;
        }
        Object object = epoxyHolder.objectToBind();
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"epoxyHolder.objectToBind()");
        Object boundObject = object;
        if (boundObject instanceof ModelGroupHolder) {
            Object v3;
            block6: {
                Iterable $this$firstOrNull$iv = ((ModelGroupHolder)boundObject).getViewHolders();
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    EpoxyViewHolder it = (EpoxyViewHolder)((Object)element$iv);
                    boolean bl = false;
                    View view2 = it.itemView;
                    Intrinsics.checkExpressionValueIsNotNull((Object)view2, (String)"it.itemView");
                    if (!SequencesKt.contains(this.getAllViewsInHierarchy(view2), (Object)view)) continue;
                    v3 = element$iv;
                    break block6;
                }
                v3 = null;
            }
            if ((epoxyViewHolder = (EpoxyViewHolder)v3) == null) {
                epoxyViewHolder = epoxyHolder;
            }
        } else {
            epoxyViewHolder = epoxyHolder;
        }
        EpoxyViewHolder holderToUse = epoxyViewHolder;
        EpoxyModel<?> epoxyModel = holderToUse.getModel();
        Intrinsics.checkExpressionValueIsNotNull(epoxyModel, (String)"holderToUse.model");
        Object object2 = holderToUse.objectToBind();
        Intrinsics.checkExpressionValueIsNotNull((Object)object2, (String)"holderToUse.objectToBind()");
        return new ClickedModelInfo(epoxyModel, adapterPosition, object2);
    }

    private final Sequence<View> getAllViewsInHierarchy(@NotNull View $this$allViewsInHierarchy) {
        return $this$allViewsInHierarchy instanceof ViewGroup ? SequencesKt.plus((Sequence)SequencesKt.flatMap(this.getChildren$epoxy_adapter_release((ViewGroup)$this$allViewsInHierarchy), (Function1)((Function1)new Function1<View, Sequence<? extends View>>(this){
            final /* synthetic */ WrappedEpoxyModelClickListener this$0;

            @NotNull
            public final Sequence<View> invoke(@NotNull View it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                return SequencesKt.plus((Sequence)SequencesKt.sequenceOf((Object[])new View[]{it}), (Sequence)(it instanceof ViewGroup ? WrappedEpoxyModelClickListener.access$getAllViewsInHierarchy$p(this.this$0, it) : SequencesKt.emptySequence()));
            }
            {
                this.this$0 = wrappedEpoxyModelClickListener;
                super(1);
            }
        })), (Object)$this$allViewsInHierarchy) : SequencesKt.sequenceOf((Object[])new View[]{$this$allViewsInHierarchy});
    }

    @NotNull
    public final Sequence<View> getChildren$epoxy_adapter_release(@NotNull ViewGroup $this$children) {
        Intrinsics.checkParameterIsNotNull((Object)$this$children, (String)"$this$children");
        return (Sequence)new Sequence<View>(this, $this$children){
            final /* synthetic */ WrappedEpoxyModelClickListener this$0;
            final /* synthetic */ ViewGroup $this_children;

            @NotNull
            public Iterator<View> iterator() {
                return this.this$0.iterator$epoxy_adapter_release(this.$this_children);
            }
            {
                this.this$0 = $outer;
                this.$this_children = $receiver;
            }
        };
    }

    @NotNull
    public final Iterator<View> iterator$epoxy_adapter_release(@NotNull ViewGroup $this$iterator) {
        Intrinsics.checkParameterIsNotNull((Object)$this$iterator, (String)"$this$iterator");
        return new Iterator<View>($this$iterator){
            private int index;
            final /* synthetic */ ViewGroup $this_iterator;

            public boolean hasNext() {
                return this.index < this.$this_iterator.getChildCount();
            }

            @NotNull
            public View next() {
                int n = this.index;
                this.index = n + 1;
                View view = this.$this_iterator.getChildAt(n);
                if (view == null) {
                    throw (Throwable)new IndexOutOfBoundsException();
                }
                return view;
            }

            public void remove() {
                iterator.1 v0 = this;
                v0.index += -1;
                this.$this_iterator.removeViewAt(v0.index);
            }
            {
                this.$this_iterator = $receiver;
            }
        };
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof WrappedEpoxyModelClickListener)) {
            return false;
        }
        if (this.originalClickListener != null ? Intrinsics.areEqual(this.originalClickListener, ((WrappedEpoxyModelClickListener)other).originalClickListener) ^ true : ((WrappedEpoxyModelClickListener)other).originalClickListener != null) {
            return false;
        }
        return this.originalLongClickListener != null ? Intrinsics.areEqual(this.originalLongClickListener, ((WrappedEpoxyModelClickListener)other).originalLongClickListener) : ((WrappedEpoxyModelClickListener)other).originalLongClickListener == null;
    }

    public int hashCode() {
        OnModelClickListener<T, V> onModelClickListener = this.originalClickListener;
        int result = onModelClickListener != null ? onModelClickListener.hashCode() : 0;
        OnModelLongClickListener<T, V> onModelLongClickListener = this.originalLongClickListener;
        result = 31 * result + (onModelLongClickListener != null ? onModelLongClickListener.hashCode() : 0);
        return result;
    }

    public WrappedEpoxyModelClickListener(@Nullable OnModelClickListener<T, V> clickListener) {
        boolean bl = false;
        boolean bl2 = false;
        if (clickListener == null) {
            boolean bl3 = false;
            String string = "Click listener cannot be null";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        this.originalClickListener = clickListener;
        this.originalLongClickListener = null;
    }

    public WrappedEpoxyModelClickListener(@Nullable OnModelLongClickListener<T, V> clickListener) {
        boolean bl = false;
        boolean bl2 = false;
        if (clickListener == null) {
            boolean bl3 = false;
            String string = "Click listener cannot be null";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        this.originalLongClickListener = clickListener;
        this.originalClickListener = null;
    }

    public static final /* synthetic */ Sequence access$getAllViewsInHierarchy$p(WrappedEpoxyModelClickListener $this, View $this$access_u24allViewsInHierarchy_u24p) {
        return $this.getAllViewsInHierarchy($this$access_u24allViewsInHierarchy_u24p);
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\t\b\u0002\u0018\u00002\u00020\u0001B!\u0012\n\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0001\u00a2\u0006\u0002\u0010\u0007R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0006\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0015\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u000e"}, d2={"Lcom/airbnb/epoxy/WrappedEpoxyModelClickListener$ClickedModelInfo;", "", "model", "Lcom/airbnb/epoxy/EpoxyModel;", "adapterPosition", "", "boundObject", "(Lcom/airbnb/epoxy/EpoxyModel;ILjava/lang/Object;)V", "getAdapterPosition", "()I", "getBoundObject", "()Ljava/lang/Object;", "getModel", "()Lcom/airbnb/epoxy/EpoxyModel;", "epoxy-adapter_release"})
    private static final class ClickedModelInfo {
        @NotNull
        private final EpoxyModel<?> model;
        private final int adapterPosition;
        @NotNull
        private final Object boundObject;

        @NotNull
        public final EpoxyModel<?> getModel() {
            return this.model;
        }

        public final int getAdapterPosition() {
            return this.adapterPosition;
        }

        @NotNull
        public final Object getBoundObject() {
            return this.boundObject;
        }

        public ClickedModelInfo(@NotNull EpoxyModel<?> model, int adapterPosition, @NotNull Object boundObject) {
            Intrinsics.checkParameterIsNotNull(model, (String)"model");
            Intrinsics.checkParameterIsNotNull((Object)boundObject, (String)"boundObject");
            this.model = model;
            this.adapterPosition = adapterPosition;
            this.boundObject = boundObject;
        }
    }
}

