/*
 * Decompiled with CFR 0.152.
 */
package com.airbnb.epoxy;

import androidx.annotation.CallSuper;
import androidx.annotation.LayoutRes;
import androidx.annotation.NonNull;
import com.airbnb.epoxy.EpoxyModel;
import com.airbnb.epoxy.EpoxyModelWithHolder;
import com.airbnb.epoxy.EpoxyViewHolder;
import com.airbnb.epoxy.ModelGroupHolder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class EpoxyModelGroup
extends EpoxyModelWithHolder<ModelGroupHolder> {
    protected final List<? extends EpoxyModel<?>> models;
    private final boolean shouldSaveViewState;

    public EpoxyModelGroup(@LayoutRes int layoutRes, Collection<? extends EpoxyModel<?>> models) {
        this(layoutRes, new ArrayList(models));
    }

    public EpoxyModelGroup(@LayoutRes int layoutRes, EpoxyModel<?> ... models) {
        this(layoutRes, new ArrayList(Arrays.asList(models)));
    }

    private EpoxyModelGroup(@LayoutRes int layoutRes, List<? extends EpoxyModel<?>> models) {
        if (models.isEmpty()) {
            throw new IllegalArgumentException("Models cannot be empty");
        }
        this.models = models;
        this.layout(layoutRes);
        this.id(models.get(0).id());
        boolean saveState = false;
        for (EpoxyModel<?> model : models) {
            if (!model.shouldSaveViewState()) continue;
            saveState = true;
            break;
        }
        this.shouldSaveViewState = saveState;
    }

    @Override
    @CallSuper
    public void bind(@NonNull ModelGroupHolder holder) {
        this.iterateModels(holder, new IterateModelsCallback(){

            @Override
            public void onModel(EpoxyModel model, EpoxyViewHolder viewHolder, int modelIndex) {
                EpoxyModelGroup.setViewVisibility(model, viewHolder);
                viewHolder.bind(model, null, Collections.emptyList(), modelIndex);
            }
        });
    }

    @Override
    @CallSuper
    public void bind(@NonNull ModelGroupHolder holder, @NonNull List<Object> payloads) {
        this.iterateModels(holder, new IterateModelsCallback(){

            @Override
            public void onModel(EpoxyModel model, EpoxyViewHolder viewHolder, int modelIndex) {
                EpoxyModelGroup.setViewVisibility(model, viewHolder);
                viewHolder.bind(model, null, Collections.emptyList(), modelIndex);
            }
        });
    }

    @Override
    public void bind(@NonNull ModelGroupHolder holder, @NonNull EpoxyModel<?> previouslyBoundModel) {
        if (!(previouslyBoundModel instanceof EpoxyModelGroup)) {
            this.bind(holder);
            return;
        }
        final EpoxyModelGroup previousGroup = (EpoxyModelGroup)previouslyBoundModel;
        this.iterateModels(holder, new IterateModelsCallback(){

            @Override
            public void onModel(EpoxyModel model, EpoxyViewHolder viewHolder, int modelIndex) {
                EpoxyModel<?> previousModel;
                EpoxyModelGroup.setViewVisibility(model, viewHolder);
                if (modelIndex < previousGroup.models.size() && (previousModel = previousGroup.models.get(modelIndex)).id() == model.id()) {
                    viewHolder.bind(model, previousModel, Collections.emptyList(), modelIndex);
                    return;
                }
                viewHolder.bind(model, null, Collections.emptyList(), modelIndex);
            }
        });
    }

    private static void setViewVisibility(EpoxyModel model, EpoxyViewHolder viewHolder) {
        if (model.isShown()) {
            viewHolder.itemView.setVisibility(0);
        } else {
            viewHolder.itemView.setVisibility(8);
        }
    }

    @Override
    @CallSuper
    public void unbind(@NonNull ModelGroupHolder holder) {
        holder.unbindGroup();
    }

    @Override
    @CallSuper
    public void onViewAttachedToWindow(ModelGroupHolder holder) {
        this.iterateModels(holder, new IterateModelsCallback(){

            @Override
            public void onModel(EpoxyModel model, EpoxyViewHolder viewHolder, int modelIndex) {
                model.onViewAttachedToWindow(viewHolder.objectToBind());
            }
        });
    }

    @Override
    @CallSuper
    public void onViewDetachedFromWindow(ModelGroupHolder holder) {
        this.iterateModels(holder, new IterateModelsCallback(){

            @Override
            public void onModel(EpoxyModel model, EpoxyViewHolder viewHolder, int modelIndex) {
                model.onViewDetachedFromWindow(viewHolder.objectToBind());
            }
        });
    }

    private void iterateModels(ModelGroupHolder holder, IterateModelsCallback callback2) {
        holder.bindGroupIfNeeded(this);
        int modelCount = this.models.size();
        for (int i = 0; i < modelCount; ++i) {
            callback2.onModel(this.models.get(i), holder.getViewHolders().get(i), i);
        }
    }

    @Override
    public int getSpanSize(int totalSpanCount, int position, int itemCount) {
        return this.models.get(0).spanSize(totalSpanCount, position, itemCount);
    }

    @Override
    protected final int getDefaultLayout() {
        throw new UnsupportedOperationException("You should set a layout with layout(...) instead of using this.");
    }

    @Override
    public boolean shouldSaveViewState() {
        return this.shouldSaveViewState;
    }

    protected boolean useViewStubLayoutParams(EpoxyModel<?> model, int modelPosition) {
        return true;
    }

    @Override
    protected final ModelGroupHolder createNewHolder() {
        return new ModelGroupHolder();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof EpoxyModelGroup)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        EpoxyModelGroup that = (EpoxyModelGroup)o;
        return this.models.equals(that.models);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.models.hashCode();
        return result;
    }

    private static interface IterateModelsCallback {
        public void onModel(EpoxyModel var1, EpoxyViewHolder var2, int var3);
    }
}

