/*
 * Decompiled with CFR 0.152.
 */
package com.airbnb.epoxy;

import android.content.Context;
import androidx.annotation.Nullable;
import androidx.annotation.PluralsRes;
import java.util.Arrays;

public class QuantityStringResAttribute {
    @PluralsRes
    private final int id;
    private final int quantity;
    @Nullable
    private final Object[] formatArgs;

    public QuantityStringResAttribute(@PluralsRes int id2, int quantity, @Nullable Object[] formatArgs) {
        this.quantity = quantity;
        this.id = id2;
        this.formatArgs = formatArgs;
    }

    public QuantityStringResAttribute(int id2, int quantity) {
        this(id2, quantity, null);
    }

    @PluralsRes
    public int getId() {
        return this.id;
    }

    public int getQuantity() {
        return this.quantity;
    }

    @Nullable
    public Object[] getFormatArgs() {
        return this.formatArgs;
    }

    public CharSequence toString(Context context) {
        if (this.formatArgs == null || this.formatArgs.length == 0) {
            return context.getResources().getQuantityString(this.id, this.quantity);
        }
        return context.getResources().getQuantityString(this.id, this.quantity, this.formatArgs);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof QuantityStringResAttribute)) {
            return false;
        }
        QuantityStringResAttribute that = (QuantityStringResAttribute)o;
        if (this.id != that.id) {
            return false;
        }
        if (this.quantity != that.quantity) {
            return false;
        }
        return Arrays.equals(this.formatArgs, that.formatArgs);
    }

    public int hashCode() {
        int result = this.id;
        result = 31 * result + this.quantity;
        result = 31 * result + Arrays.hashCode(this.formatArgs);
        return result;
    }
}

