/*
 * Decompiled with CFR 0.152.
 */
package com.airbnb.epoxy;

import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.view.ViewStub;
import androidx.annotation.VisibleForTesting;
import androidx.recyclerview.widget.RecyclerView;
import com.airbnb.epoxy.EpoxyHolder;
import com.airbnb.epoxy.EpoxyModel;
import com.airbnb.epoxy.EpoxyModelGroup;
import com.airbnb.epoxy.EpoxyViewHolder;
import com.airbnb.epoxy.HelperAdapter;
import com.airbnb.epoxy.LocalGroupRecycledViewPool;
import com.airbnb.epoxy.ViewStubData;
import com.airbnb.epoxy.ViewTypeManager;
import com.airbnb.viewmodeladapter.R;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\b\n\u0002\b\u0004\u0018\u0000 22\u00020\u0001:\u00012B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\"\u0010\u001b\u001a\u00020\u001c2\n\u0010\u001d\u001a\u0006\u0012\u0002\b\u00030\u001e2\f\u0010\u001f\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u001eH\u0002J\u000e\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020\u0006J\u0010\u0010#\u001a\u00020!2\u0006\u0010$\u001a\u00020%H\u0014J\u001e\u0010&\u001a\u00020!2\u0006\u0010'\u001a\u00020\b2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u0011H\u0002J\u0016\u0010(\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u0006\u0010'\u001a\u00020\bH\u0002J\u0010\u0010)\u001a\u00020\b2\u0006\u0010*\u001a\u00020\bH\u0002J\u001c\u0010+\u001a\u00020\u00122\u0006\u0010\u0002\u001a\u00020\b2\n\u0010,\u001a\u0006\u0012\u0002\b\u00030\u001eH\u0002J\u0010\u0010-\u001a\u00020!2\u0006\u0010.\u001a\u00020/H\u0002J\u0006\u00100\u001a\u00020!J\b\u00101\u001a\u00020\u001cH\u0002R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082.\u00a2\u0006\u0002\n\u0000R\u001e\u0010\n\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b@BX\u0086.\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eX\u0082.\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u001c\u0010\u0015\u001a\u00020\u00168\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0017\u0010\u0018\u001a\u0004\b\u0019\u0010\u001a\u00a8\u00063"}, d2={"Lcom/airbnb/epoxy/ModelGroupHolder;", "Lcom/airbnb/epoxy/EpoxyHolder;", "parent", "Landroid/view/ViewParent;", "(Landroid/view/ViewParent;)V", "boundGroup", "Lcom/airbnb/epoxy/EpoxyModelGroup;", "childContainer", "Landroid/view/ViewGroup;", "<set-?>", "rootView", "getRootView", "()Landroid/view/ViewGroup;", "stubs", "", "Lcom/airbnb/epoxy/ViewStubData;", "viewHolders", "Ljava/util/ArrayList;", "Lcom/airbnb/epoxy/EpoxyViewHolder;", "getViewHolders", "()Ljava/util/ArrayList;", "viewPool", "Landroidx/recyclerview/widget/RecyclerView$RecycledViewPool;", "getViewPool$annotations", "()V", "getViewPool", "()Landroidx/recyclerview/widget/RecyclerView$RecycledViewPool;", "areSameViewType", "", "model1", "Lcom/airbnb/epoxy/EpoxyModel;", "model2", "bindGroupIfNeeded", "", "group", "bindView", "itemView", "Landroid/view/View;", "collectViewStubs", "viewGroup", "createViewStubData", "findChildContainer", "outermostRoot", "getViewHolder", "model", "removeAndRecycleView", "modelPosition", "", "unbindGroup", "usingStubs", "Companion", "epoxy-adapter_release"})
public final class ModelGroupHolder
extends EpoxyHolder {
    @NotNull
    private final ArrayList<EpoxyViewHolder> viewHolders;
    @NotNull
    private final RecyclerView.RecycledViewPool viewPool;
    private ViewGroup rootView;
    private ViewGroup childContainer;
    private List<ViewStubData> stubs;
    private EpoxyModelGroup boundGroup;
    private static final HelperAdapter HELPER_ADAPTER;
    @NotNull
    public static final Companion Companion;

    @NotNull
    public final ArrayList<EpoxyViewHolder> getViewHolders() {
        return this.viewHolders;
    }

    @VisibleForTesting
    public static /* synthetic */ void getViewPool$annotations() {
    }

    @NotNull
    public final RecyclerView.RecycledViewPool getViewPool() {
        return this.viewPool;
    }

    @NotNull
    public final ViewGroup getRootView() {
        ViewGroup viewGroup = this.rootView;
        if (viewGroup == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"rootView");
        }
        return viewGroup;
    }

    private final boolean usingStubs() {
        List<ViewStubData> list = this.stubs;
        if (list == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"stubs");
        }
        Collection collection = list;
        boolean bl = false;
        return !collection.isEmpty();
    }

    @Override
    protected void bindView(@NotNull View itemView) {
        List<ViewStubData> list;
        Intrinsics.checkNotNullParameter((Object)itemView, (String)"itemView");
        if (!(itemView instanceof ViewGroup)) {
            throw (Throwable)new IllegalStateException("The layout provided to EpoxyModelGroup must be a ViewGroup");
        }
        ViewGroup viewGroup = this.rootView = (ViewGroup)itemView;
        if (viewGroup == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"rootView");
        }
        ViewGroup viewGroup2 = this.childContainer = this.findChildContainer(viewGroup);
        if (viewGroup2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"childContainer");
        }
        if (viewGroup2.getChildCount() != 0) {
            ViewGroup viewGroup3 = this.childContainer;
            if (viewGroup3 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"childContainer");
            }
            list = this.createViewStubData(viewGroup3);
        } else {
            list = CollectionsKt.emptyList();
        }
        this.stubs = list;
    }

    private final ViewGroup findChildContainer(ViewGroup outermostRoot) {
        ViewGroup viewGroup;
        View customRoot = outermostRoot.findViewById(R.id.epoxy_model_group_child_container);
        View view = customRoot;
        if (!(view instanceof ViewGroup)) {
            view = null;
        }
        if ((viewGroup = (ViewGroup)view) == null) {
            viewGroup = outermostRoot;
        }
        return viewGroup;
    }

    private final List<ViewStubData> createViewStubData(ViewGroup viewGroup) {
        ArrayList<ViewStubData> arrayList = new ArrayList<ViewStubData>(4);
        boolean bl = false;
        boolean bl2 = false;
        ArrayList<ViewStubData> $this$apply = arrayList;
        boolean bl3 = false;
        this.collectViewStubs(viewGroup, $this$apply);
        if ($this$apply.isEmpty()) {
            throw (Throwable)new IllegalStateException("No view stubs found. If viewgroup is not empty it must contain ViewStubs.");
        }
        return arrayList;
    }

    /*
     * WARNING - void declaration
     */
    private final void collectViewStubs(ViewGroup viewGroup, ArrayList<ViewStubData> stubs) {
        int n = 0;
        int n2 = viewGroup.getChildCount();
        while (n < n2) {
            void i;
            View child = viewGroup.getChildAt((int)i);
            if (child instanceof ViewGroup) {
                this.collectViewStubs((ViewGroup)child, stubs);
            } else if (child instanceof ViewStub) {
                stubs.add(new ViewStubData(viewGroup, (ViewStub)child, (int)i));
            }
            ++i;
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void bindGroupIfNeeded(@NotNull EpoxyModelGroup group) {
        int n;
        int n2;
        Intrinsics.checkNotNullParameter((Object)group, (String)"group");
        EpoxyModelGroup previouslyBoundGroup = this.boundGroup;
        if (previouslyBoundGroup == group) {
            return;
        }
        if (previouslyBoundGroup != null && previouslyBoundGroup.models.size() > group.models.size() && (n2 = previouslyBoundGroup.models.size() - 1) >= (n = group.models.size())) {
            while (true) {
                void i;
                this.removeAndRecycleView((int)i);
                if (i == n) break;
                --i;
            }
        }
        this.boundGroup = group;
        List<EpoxyModel<?>> models = group.models;
        int modelCount = models.size();
        if (this.usingStubs()) {
            List<ViewStubData> list = this.stubs;
            if (list == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"stubs");
            }
            if (list.size() < modelCount) {
                StringBuilder stringBuilder = new StringBuilder().append("Insufficient view stubs for EpoxyModelGroup. ").append(modelCount).append(" models were provided but only ");
                List<ViewStubData> list2 = this.stubs;
                if (list2 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"stubs");
                }
                throw (Throwable)new IllegalStateException(stringBuilder.append(list2.size()).append(" view stubs exist.").toString());
            }
        }
        this.viewHolders.ensureCapacity(modelCount);
        int n3 = 0;
        int n4 = modelCount;
        while (n3 < n4) {
            void i;
            block17: {
                ViewStubData parent;
                ViewStubData stubData;
                EpoxyModel<?> model;
                block16: {
                    ViewStubData viewStubData;
                    model = models.get((int)i);
                    Object object = previouslyBoundGroup;
                    EpoxyModel previouslyBoundModel = object != null && (object = ((EpoxyModelGroup)object).models) != null ? (EpoxyModel)CollectionsKt.getOrNull((List)object, (int)i) : null;
                    List<ViewStubData> list = this.stubs;
                    if (list == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"stubs");
                    }
                    if (((viewStubData = (stubData = (ViewStubData)CollectionsKt.getOrNull(list, (int)i))) == null || (viewStubData = viewStubData.getViewGroup()) == null) && (viewStubData = this.childContainer) == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"childContainer");
                    }
                    parent = viewStubData;
                    if (previouslyBoundModel == null) break block16;
                    if (this.areSameViewType(previouslyBoundModel, model)) break block17;
                    this.removeAndRecycleView((int)i);
                }
                EpoxyModel<?> epoxyModel = model;
                Intrinsics.checkNotNullExpressionValue(epoxyModel, (String)"model");
                EpoxyViewHolder holder = this.getViewHolder((ViewGroup)parent, epoxyModel);
                if (stubData == null) {
                    ViewGroup viewGroup = this.childContainer;
                    if (viewGroup == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"childContainer");
                    }
                    viewGroup.addView(holder.itemView, (int)i);
                } else {
                    View view = holder.itemView;
                    Intrinsics.checkNotNullExpressionValue((Object)view, (String)"holder.itemView");
                    stubData.setView(view, group.useViewStubLayoutParams(model, (int)i));
                }
                this.viewHolders.add((int)i, holder);
            }
            ++i;
        }
    }

    private final boolean areSameViewType(EpoxyModel<?> model1, EpoxyModel<?> model2) {
        return ViewTypeManager.getViewType(model1) == ViewTypeManager.getViewType(model2);
    }

    private final EpoxyViewHolder getViewHolder(ViewGroup parent, EpoxyModel<?> model) {
        EpoxyViewHolder epoxyViewHolder;
        int viewType = ViewTypeManager.getViewType(model);
        RecyclerView.ViewHolder recycledView = this.viewPool.getRecycledView(viewType);
        RecyclerView.ViewHolder viewHolder = recycledView;
        if (!(viewHolder instanceof EpoxyViewHolder)) {
            viewHolder = null;
        }
        if ((epoxyViewHolder = (EpoxyViewHolder)viewHolder) == null) {
            epoxyViewHolder = HELPER_ADAPTER.createViewHolder(model, parent, viewType);
        }
        return epoxyViewHolder;
    }

    public final void unbindGroup() {
        if (this.boundGroup == null) {
            throw (Throwable)new IllegalStateException("Group is not bound");
        }
        int n = this.viewHolders.size();
        boolean bl = false;
        int n2 = 0;
        n2 = 0;
        int n3 = n;
        while (n2 < n3) {
            int it = n2++;
            boolean bl2 = false;
            this.removeAndRecycleView(this.viewHolders.size() - 1);
        }
        this.boundGroup = null;
    }

    private final void removeAndRecycleView(int modelPosition) {
        if (this.usingStubs()) {
            List<ViewStubData> list = this.stubs;
            if (list == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"stubs");
            }
            list.get(modelPosition).resetStub();
        } else {
            ViewGroup viewGroup = this.childContainer;
            if (viewGroup == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"childContainer");
            }
            viewGroup.removeViewAt(modelPosition);
        }
        EpoxyViewHolder epoxyViewHolder = this.viewHolders.remove(modelPosition);
        Intrinsics.checkNotNullExpressionValue((Object)((Object)epoxyViewHolder), (String)"viewHolders.removeAt(modelPosition)");
        EpoxyViewHolder viewHolder = epoxyViewHolder;
        viewHolder.unbind();
        this.viewPool.putRecycledView((RecyclerView.ViewHolder)viewHolder);
    }

    public ModelGroupHolder(@NotNull ViewParent parent) {
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        this.viewHolders = new ArrayList(4);
        RecyclerView.RecycledViewPool recycledViewPool = ModelGroupHolder.Companion.findViewPool(parent);
        if (recycledViewPool == null) {
            recycledViewPool = new LocalGroupRecycledViewPool();
        }
        this.viewPool = recycledViewPool;
    }

    static {
        Companion = new Companion(null);
        HELPER_ADAPTER = new HelperAdapter();
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/airbnb/epoxy/ModelGroupHolder$Companion;", "", "()V", "HELPER_ADAPTER", "Lcom/airbnb/epoxy/HelperAdapter;", "findViewPool", "Landroidx/recyclerview/widget/RecyclerView$RecycledViewPool;", "view", "Landroid/view/ViewParent;", "epoxy-adapter_release"})
    public static final class Companion {
        private final RecyclerView.RecycledViewPool findViewPool(ViewParent view) {
            RecyclerView.RecycledViewPool viewPool = null;
            while (viewPool == null) {
                ViewParent parent;
                viewPool = view instanceof RecyclerView ? ((RecyclerView)view).getRecycledViewPool() : ((parent = view.getParent()) instanceof ViewParent ? this.findViewPool(parent) : null);
            }
            return viewPool;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

