/*
 * Decompiled with CFR 0.152.
 */
package com.airbnb.epoxy;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.recyclerview.widget.AdapterListUpdateCallback;
import androidx.recyclerview.widget.DiffUtil;
import androidx.recyclerview.widget.ListUpdateCallback;
import androidx.recyclerview.widget.RecyclerView;
import com.airbnb.epoxy.EpoxyModel;
import java.util.Collections;
import java.util.List;

public class DiffResult {
    @NonNull
    final List<? extends EpoxyModel<?>> previousModels;
    @NonNull
    final List<? extends EpoxyModel<?>> newModels;
    @Nullable
    final DiffUtil.DiffResult differResult;

    static DiffResult noOp(@Nullable List<? extends EpoxyModel<?>> models) {
        if (models == null) {
            models = Collections.emptyList();
        }
        return new DiffResult(models, models, null);
    }

    static DiffResult inserted(@NonNull List<? extends EpoxyModel<?>> newModels) {
        return new DiffResult(Collections.EMPTY_LIST, newModels, null);
    }

    static DiffResult clear(@NonNull List<? extends EpoxyModel<?>> previousModels) {
        return new DiffResult(previousModels, Collections.EMPTY_LIST, null);
    }

    static DiffResult diff(@NonNull List<? extends EpoxyModel<?>> previousModels, @NonNull List<? extends EpoxyModel<?>> newModels, @NonNull DiffUtil.DiffResult differResult) {
        return new DiffResult(previousModels, newModels, differResult);
    }

    private DiffResult(@NonNull List<? extends EpoxyModel<?>> previousModels, @NonNull List<? extends EpoxyModel<?>> newModels, @Nullable DiffUtil.DiffResult differResult) {
        this.previousModels = previousModels;
        this.newModels = newModels;
        this.differResult = differResult;
    }

    public void dispatchTo(RecyclerView.Adapter adapter) {
        this.dispatchTo((ListUpdateCallback)new AdapterListUpdateCallback(adapter));
    }

    public void dispatchTo(ListUpdateCallback callback2) {
        if (this.differResult != null) {
            this.differResult.dispatchUpdatesTo(callback2);
        } else if (this.newModels.isEmpty() && !this.previousModels.isEmpty()) {
            callback2.onRemoved(0, this.previousModels.size());
        } else if (!this.newModels.isEmpty() && this.previousModels.isEmpty()) {
            callback2.onInserted(0, this.newModels.size());
        }
    }
}

