/*
 * Decompiled with CFR 0.152.
 */
package com.airbnb.epoxy;

import android.graphics.Rect;
import android.view.View;
import android.view.ViewGroup;
import androidx.annotation.IntRange;
import androidx.annotation.Px;
import androidx.annotation.VisibleForTesting;
import com.airbnb.epoxy.EpoxyViewHolder;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u0011\u0012\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0004J\u0016\u0010\u001a\u001a\u00020\t2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\tJ\u0016\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010 \u001a\u00020\tJ\u0016\u0010!\u001a\u00020\u001f2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010 \u001a\u00020\tJ \u0010\"\u001a\u00020\u001f2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010 \u001a\u00020\t2\b\b\u0001\u0010#\u001a\u00020\u0003J\u0016\u0010$\u001a\u00020\u001f2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010 \u001a\u00020\tJ\b\u0010%\u001a\u00020\tH\u0002J\b\u0010&\u001a\u00020\tH\u0002J\u0012\u0010'\u001a\u00020\t2\b\b\u0001\u0010#\u001a\u00020\u0003H\u0002J\b\u0010(\u001a\u00020\tH\u0002J\u000e\u0010)\u001a\u00020\u001f2\u0006\u0010*\u001a\u00020\u0003J\u000e\u0010+\u001a\u00020\u001f2\u0006\u0010,\u001a\u00020\u0003J\u001e\u0010-\u001a\u00020\t2\u0006\u0010.\u001a\u00020/2\u0006\u00100\u001a\u0002012\u0006\u0010 \u001a\u00020\tR\u001e\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u0003@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u000b\u001a\u00020\u00038\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\f\u001a\u0004\u0018\u00010\u0003X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\rR\u0012\u0010\u000e\u001a\u0004\u0018\u00010\u0003X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\rR\u0012\u0010\u000f\u001a\u0004\u0018\u00010\u0003X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\rR\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0014\u001a\u00020\u00038\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0015\u001a\u00020\u00038\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0017\u001a\u00020\u00038\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0018\u001a\u00020\u00038\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0019\u001a\u00020\u00038\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00062"}, d2={"Lcom/airbnb/epoxy/EpoxyVisibilityItem;", "", "adapterPosition", "", "(Ljava/lang/Integer;)V", "<set-?>", "getAdapterPosition", "()I", "focusedVisible", "", "fullyVisible", "height", "lastVisibilityNotified", "Ljava/lang/Integer;", "lastVisibleHeightNotified", "lastVisibleWidthNotified", "localVisibleRect", "Landroid/graphics/Rect;", "partiallyVisible", "viewVisibility", "viewportHeight", "viewportWidth", "visible", "visibleHeight", "visibleWidth", "width", "handleChanged", "epoxyHolder", "Lcom/airbnb/epoxy/EpoxyViewHolder;", "visibilityChangedEnabled", "handleFocus", "", "detachEvent", "handleFullImpressionVisible", "handlePartialImpressionVisible", "thresholdPercentage", "handleVisible", "isFullyVisible", "isInFocusVisible", "isPartiallyVisible", "isVisible", "reset", "newAdapterPosition", "shiftBy", "offsetPosition", "update", "view", "Landroid/view/View;", "parent", "Landroid/view/ViewGroup;", "epoxy-adapter_release"})
@VisibleForTesting(otherwise=3)
public final class EpoxyVisibilityItem {
    @NotNull
    private final Rect localVisibleRect;
    private int adapterPosition;
    @Px
    private int height;
    @Px
    private int width;
    @Px
    private int visibleHeight;
    @Px
    private int visibleWidth;
    @Px
    private int viewportHeight;
    @Px
    private int viewportWidth;
    private boolean partiallyVisible;
    private boolean fullyVisible;
    private boolean visible;
    private boolean focusedVisible;
    private int viewVisibility;
    @Nullable
    private Integer lastVisibleHeightNotified;
    @Nullable
    private Integer lastVisibleWidthNotified;
    @Nullable
    private Integer lastVisibilityNotified;

    public EpoxyVisibilityItem(@Nullable Integer adapterPosition) {
        this.localVisibleRect = new Rect();
        this.adapterPosition = -1;
        this.viewVisibility = 8;
        Integer n = adapterPosition;
        if (n != null) {
            Integer n2 = n;
            boolean bl = false;
            boolean bl2 = false;
            int it = ((Number)n2).intValue();
            boolean bl3 = false;
            this.reset(it);
        }
    }

    public /* synthetic */ EpoxyVisibilityItem(Integer n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 1) != 0) {
            n = null;
        }
        this(n);
    }

    public final int getAdapterPosition() {
        return this.adapterPosition;
    }

    public final boolean update(@NotNull View view, @NotNull ViewGroup parent, boolean detachEvent) {
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        this.localVisibleRect.setEmpty();
        boolean viewDrawn = view.getLocalVisibleRect(this.localVisibleRect) && !detachEvent;
        this.height = view.getHeight();
        this.width = view.getWidth();
        this.viewportHeight = parent.getHeight();
        this.viewportWidth = parent.getWidth();
        this.visibleHeight = viewDrawn ? this.localVisibleRect.height() : 0;
        this.visibleWidth = viewDrawn ? this.localVisibleRect.width() : 0;
        this.viewVisibility = view.getVisibility();
        return this.height > 0 && this.width > 0;
    }

    public final void reset(int newAdapterPosition) {
        this.fullyVisible = false;
        this.visible = false;
        this.focusedVisible = false;
        this.adapterPosition = newAdapterPosition;
        this.lastVisibleHeightNotified = null;
        this.lastVisibleWidthNotified = null;
        this.lastVisibilityNotified = null;
    }

    public final void handleVisible(@NotNull EpoxyViewHolder epoxyHolder, boolean detachEvent) {
        Intrinsics.checkNotNullParameter((Object)((Object)epoxyHolder), (String)"epoxyHolder");
        boolean previousVisible = this.visible;
        boolean bl = this.visible = !detachEvent && this.isVisible();
        if (this.visible != previousVisible) {
            if (this.visible) {
                epoxyHolder.visibilityStateChanged(0);
            } else {
                epoxyHolder.visibilityStateChanged(1);
            }
        }
    }

    public final void handleFocus(@NotNull EpoxyViewHolder epoxyHolder, boolean detachEvent) {
        Intrinsics.checkNotNullParameter((Object)((Object)epoxyHolder), (String)"epoxyHolder");
        boolean previousFocusedVisible = this.focusedVisible;
        boolean bl = this.focusedVisible = !detachEvent && this.isInFocusVisible();
        if (this.focusedVisible != previousFocusedVisible) {
            if (this.focusedVisible) {
                epoxyHolder.visibilityStateChanged(2);
            } else {
                epoxyHolder.visibilityStateChanged(3);
            }
        }
    }

    public final void handlePartialImpressionVisible(@NotNull EpoxyViewHolder epoxyHolder, boolean detachEvent, @IntRange(from=0L, to=100L) int thresholdPercentage) {
        Intrinsics.checkNotNullParameter((Object)((Object)epoxyHolder), (String)"epoxyHolder");
        boolean previousPartiallyVisible = this.partiallyVisible;
        boolean bl = this.partiallyVisible = !detachEvent && this.isPartiallyVisible(thresholdPercentage);
        if (this.partiallyVisible != previousPartiallyVisible) {
            if (this.partiallyVisible) {
                epoxyHolder.visibilityStateChanged(5);
            } else {
                epoxyHolder.visibilityStateChanged(6);
            }
        }
    }

    public final void handleFullImpressionVisible(@NotNull EpoxyViewHolder epoxyHolder, boolean detachEvent) {
        Intrinsics.checkNotNullParameter((Object)((Object)epoxyHolder), (String)"epoxyHolder");
        boolean previousFullyVisible = this.fullyVisible;
        boolean bl = this.fullyVisible = !detachEvent && this.isFullyVisible();
        if (this.fullyVisible != previousFullyVisible && this.fullyVisible) {
            epoxyHolder.visibilityStateChanged(4);
        }
    }

    public final boolean handleChanged(@NotNull EpoxyViewHolder epoxyHolder, boolean visibilityChangedEnabled) {
        boolean changed;
        block7: {
            block6: {
                Intrinsics.checkNotNullParameter((Object)((Object)epoxyHolder), (String)"epoxyHolder");
                changed = false;
                Integer n = this.lastVisibleHeightNotified;
                if (n == null || this.visibleHeight != n) break block6;
                Integer n2 = this.lastVisibleWidthNotified;
                if (n2 == null || this.visibleWidth != n2) break block6;
                Integer n3 = this.lastVisibilityNotified;
                if (n3 != null && this.viewVisibility == n3) break block7;
            }
            if (visibilityChangedEnabled) {
                if (this.viewVisibility == 8) {
                    epoxyHolder.visibilityChanged(0.0f, 0.0f, 0, 0);
                } else {
                    epoxyHolder.visibilityChanged(100.0f / (float)this.height * (float)this.visibleHeight, 100.0f / (float)this.width * (float)this.visibleWidth, this.visibleHeight, this.visibleWidth);
                }
            }
            this.lastVisibleHeightNotified = this.visibleHeight;
            this.lastVisibleWidthNotified = this.visibleWidth;
            this.lastVisibilityNotified = this.viewVisibility;
            changed = true;
        }
        return changed;
    }

    private final boolean isVisible() {
        return this.viewVisibility == 0 && this.visibleHeight > 0 && this.visibleWidth > 0;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isInFocusVisible() {
        int halfViewportArea = this.viewportHeight * this.viewportWidth / 2;
        int totalArea = this.height * this.width;
        int visibleArea = this.visibleHeight * this.visibleWidth;
        if (this.viewVisibility != 0) return false;
        if (totalArea >= halfViewportArea) {
            if (visibleArea < halfViewportArea) return false;
            return true;
        }
        if (totalArea != visibleArea) return false;
        return true;
    }

    private final boolean isPartiallyVisible(@IntRange(from=0L, to=100L) int thresholdPercentage) {
        if (thresholdPercentage == 0) {
            return this.isVisible();
        }
        int totalArea = this.height * this.width;
        int visibleArea = this.visibleHeight * this.visibleWidth;
        float visibleAreaPercentage = (float)visibleArea / (float)totalArea * (float)100;
        return this.viewVisibility == 0 && visibleAreaPercentage >= (float)thresholdPercentage;
    }

    private final boolean isFullyVisible() {
        return this.viewVisibility == 0 && this.visibleHeight == this.height && this.visibleWidth == this.width;
    }

    public final void shiftBy(int offsetPosition) {
        EpoxyVisibilityItem epoxyVisibilityItem = this;
        epoxyVisibilityItem.adapterPosition += offsetPosition;
    }

    public EpoxyVisibilityItem() {
        this(null, 1, null);
    }
}

