/*
 * Decompiled with CFR 0.152.
 */
package com.airbnb.epoxy;

import android.content.Context;
import android.content.ContextWrapper;
import androidx.lifecycle.Lifecycle;
import androidx.lifecycle.LifecycleObserver;
import androidx.lifecycle.LifecycleOwner;
import androidx.recyclerview.widget.RecyclerView;
import com.airbnb.epoxy.ActivityRecyclerPoolKt;
import com.airbnb.epoxy.PoolReference;
import java.util.ArrayList;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0005J\u001e\u0010\t\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rH\u0007J\u000e\u0010\u000f\u001a\u0004\u0018\u00010\u0010*\u00020\u000bH\u0002R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/airbnb/epoxy/ActivityRecyclerPool;", "", "()V", "pools", "Ljava/util/ArrayList;", "Lcom/airbnb/epoxy/PoolReference;", "clearIfDestroyed", "", "pool", "getPool", "context", "Landroid/content/Context;", "poolFactory", "Lkotlin/Function0;", "Landroidx/recyclerview/widget/RecyclerView$RecycledViewPool;", "lifecycle", "Landroidx/lifecycle/Lifecycle;", "epoxy-adapter_release"})
public final class ActivityRecyclerPool {
    @NotNull
    private final ArrayList<PoolReference> pools = new ArrayList(5);

    @JvmOverloads
    @NotNull
    public final PoolReference getPool(@NotNull Context context, @NotNull Function0<? extends RecyclerView.RecycledViewPool> poolFactory) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter(poolFactory, (String)"poolFactory");
        Iterator<PoolReference> iterator2 = this.pools.iterator();
        Intrinsics.checkNotNullExpressionValue(iterator2, (String)"pools.iterator()");
        Iterator<PoolReference> iterator3 = iterator2;
        PoolReference poolToUse = null;
        while (iterator3.hasNext()) {
            PoolReference poolReference;
            Intrinsics.checkNotNullExpressionValue((Object)iterator3.next(), (String)"iterator.next()");
            if (poolReference.getContext() == context) {
                if (poolToUse != null) {
                    throw new IllegalStateException("A pool was already found");
                }
                poolToUse = poolReference;
                continue;
            }
            if (!ActivityRecyclerPoolKt.isActivityDestroyed(poolReference.getContext())) continue;
            poolReference.getViewPool().clear();
            iterator3.remove();
        }
        if (poolToUse == null) {
            poolToUse = new PoolReference(context, (RecyclerView.RecycledViewPool)poolFactory.invoke(), this);
            Lifecycle lifecycle = this.lifecycle(context);
            if (lifecycle != null) {
                lifecycle.addObserver((LifecycleObserver)poolToUse);
            }
            this.pools.add(poolToUse);
        }
        return poolToUse;
    }

    public final void clearIfDestroyed(@NotNull PoolReference pool) {
        Intrinsics.checkNotNullParameter((Object)pool, (String)"pool");
        if (ActivityRecyclerPoolKt.isActivityDestroyed(pool.getContext())) {
            pool.getViewPool().clear();
            this.pools.remove(pool);
        }
    }

    private final Lifecycle lifecycle(Context $this$lifecycle) {
        if ($this$lifecycle instanceof LifecycleOwner) {
            return ((LifecycleOwner)$this$lifecycle).getLifecycle();
        }
        if ($this$lifecycle instanceof ContextWrapper) {
            Context context = ((ContextWrapper)$this$lifecycle).getBaseContext();
            Intrinsics.checkNotNullExpressionValue((Object)context, (String)"baseContext");
            return this.lifecycle(context);
        }
        return null;
    }
}

