/*
 * Decompiled with CFR 0.152.
 */
package com.airbnb.epoxy;

import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import androidx.collection.LongSparseArray;
import com.airbnb.epoxy.EpoxyModel;
import java.util.Collections;
import java.util.List;

public class DiffPayload {
    private final EpoxyModel<?> singleModel;
    private final LongSparseArray<EpoxyModel<?>> modelsById;

    DiffPayload(List<? extends EpoxyModel<?>> models) {
        if (models.isEmpty()) {
            throw new IllegalStateException("Models must not be empty");
        }
        int modelCount = models.size();
        if (modelCount == 1) {
            this.singleModel = models.get(0);
            this.modelsById = null;
        } else {
            this.singleModel = null;
            this.modelsById = new LongSparseArray(modelCount);
            for (EpoxyModel<?> model : models) {
                this.modelsById.put(model.id(), model);
            }
        }
    }

    public DiffPayload(EpoxyModel<?> changedItem) {
        this(Collections.singletonList(changedItem));
    }

    @Nullable
    public static EpoxyModel<?> getModelFromPayload(List<Object> payloads, long modelId) {
        if (payloads.isEmpty()) {
            return null;
        }
        for (Object payload : payloads) {
            DiffPayload diffPayload = (DiffPayload)payload;
            if (diffPayload.singleModel != null) {
                if (diffPayload.singleModel.id() != modelId) continue;
                return diffPayload.singleModel;
            }
            EpoxyModel modelForId = (EpoxyModel)diffPayload.modelsById.get(modelId);
            if (modelForId == null) continue;
            return modelForId;
        }
        return null;
    }

    @VisibleForTesting
    boolean equalsForTesting(DiffPayload that) {
        int thatSize;
        if (this.singleModel != null) {
            return that.singleModel == this.singleModel;
        }
        int thisSize = this.modelsById.size();
        if (thisSize != (thatSize = that.modelsById.size())) {
            return false;
        }
        for (int i = 0; i < thisSize; ++i) {
            EpoxyModel thatModel;
            long thatKey;
            long thisKey = this.modelsById.keyAt(i);
            if (thisKey != (thatKey = that.modelsById.keyAt(i))) {
                return false;
            }
            EpoxyModel thisModel = (EpoxyModel)this.modelsById.valueAt(i);
            if (thisModel == (thatModel = (EpoxyModel)that.modelsById.valueAt(i))) continue;
            return false;
        }
        return true;
    }
}

