/*
 * Decompiled with CFR 0.152.
 */
package com.airbnb.epoxy;

import android.view.View;
import android.view.ViewGroup;
import com.airbnb.epoxy.EpoxyModel;
import com.airbnb.epoxy.EpoxyViewHolder;
import com.airbnb.epoxy.ListenersUtils;
import com.airbnb.epoxy.ModelGroupHolder;
import com.airbnb.epoxy.OnModelClickListener;
import com.airbnb.epoxy.OnModelLongClickListener;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010)\n\u0002\b\u0003\u0018\u0000*\f\b\u0000\u0010\u0001*\u0006\u0012\u0002\b\u00030\u0002*\u0004\b\u0001\u0010\u00032\u00020\u00042\u00020\u0005:\u0001%B\u001d\b\u0016\u0012\u0014\u0010\u0006\u001a\u0010\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\bB\u001d\b\u0016\u0012\u0014\u0010\u0006\u001a\u0010\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0018\u00010\t\u00a2\u0006\u0002\u0010\nJ\u0013\u0010\u0016\u001a\u00020\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u0019H\u0096\u0002J\u0012\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\u0006\u0010\u001c\u001a\u00020\u000fH\u0002J\b\u0010\u001d\u001a\u00020\u001eH\u0016J\u0010\u0010\u001f\u001a\u00020 2\u0006\u0010\u001c\u001a\u00020\u000fH\u0016J\u0010\u0010!\u001a\u00020\u00172\u0006\u0010\u001c\u001a\u00020\u000fH\u0016J\u0018\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u000f0#*\u00020\u0013H\u0080\u0002\u00a2\u0006\u0002\b$R\u001c\u0010\u000b\u001a\u0010\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0018\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\f\u001a\u0010\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0018\u00010\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e*\u00020\u000f8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u001e\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e*\u00020\u00138@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006&"}, d2={"Lcom/airbnb/epoxy/WrappedEpoxyModelClickListener;", "T", "Lcom/airbnb/epoxy/EpoxyModel;", "V", "Landroid/view/View$OnClickListener;", "Landroid/view/View$OnLongClickListener;", "clickListener", "Lcom/airbnb/epoxy/OnModelClickListener;", "(Lcom/airbnb/epoxy/OnModelClickListener;)V", "Lcom/airbnb/epoxy/OnModelLongClickListener;", "(Lcom/airbnb/epoxy/OnModelLongClickListener;)V", "originalClickListener", "originalLongClickListener", "allViewsInHierarchy", "Lkotlin/sequences/Sequence;", "Landroid/view/View;", "getAllViewsInHierarchy", "(Landroid/view/View;)Lkotlin/sequences/Sequence;", "children", "Landroid/view/ViewGroup;", "getChildren$epoxy_adapter_release", "(Landroid/view/ViewGroup;)Lkotlin/sequences/Sequence;", "equals", "", "other", "", "getClickedModelInfo", "Lcom/airbnb/epoxy/WrappedEpoxyModelClickListener$ClickedModelInfo;", "view", "hashCode", "", "onClick", "", "onLongClick", "iterator", "", "iterator$epoxy_adapter_release", "ClickedModelInfo", "epoxy-adapter_release"})
@SourceDebugExtension(value={"SMAP\nWrappedEpoxyModelClickListener.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WrappedEpoxyModelClickListener.kt\ncom/airbnb/epoxy/WrappedEpoxyModelClickListener\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,156:1\n288#2,2:157\n*S KotlinDebug\n*F\n+ 1 WrappedEpoxyModelClickListener.kt\ncom/airbnb/epoxy/WrappedEpoxyModelClickListener\n*L\n77#1:157,2\n*E\n"})
public final class WrappedEpoxyModelClickListener<T extends EpoxyModel<?>, V>
implements View.OnClickListener,
View.OnLongClickListener {
    @Nullable
    private final OnModelClickListener<T, V> originalClickListener;
    @Nullable
    private final OnModelLongClickListener<T, V> originalLongClickListener;

    public WrappedEpoxyModelClickListener(@Nullable OnModelClickListener<T, V> clickListener) {
        if (clickListener == null) {
            boolean bl = false;
            String string = "Click listener cannot be null";
            throw new IllegalArgumentException(string.toString());
        }
        this.originalClickListener = clickListener;
        this.originalLongClickListener = null;
    }

    public WrappedEpoxyModelClickListener(@Nullable OnModelLongClickListener<T, V> clickListener) {
        if (clickListener == null) {
            boolean bl = false;
            String string = "Click listener cannot be null";
            throw new IllegalArgumentException(string.toString());
        }
        this.originalLongClickListener = clickListener;
        this.originalClickListener = null;
    }

    public void onClick(@NotNull View view) {
        Unit unit;
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        ClickedModelInfo clickedModelInfo = this.getClickedModelInfo(view);
        if (clickedModelInfo == null) {
            return;
        }
        ClickedModelInfo modelInfo = clickedModelInfo;
        OnModelClickListener<EpoxyModel<?>, Object> onModelClickListener = this.originalClickListener;
        if (onModelClickListener != null) {
            EpoxyModel<?> epoxyModel = modelInfo.getModel();
            Intrinsics.checkNotNull(epoxyModel, (String)"null cannot be cast to non-null type T of com.airbnb.epoxy.WrappedEpoxyModelClickListener");
            onModelClickListener.onClick(epoxyModel, modelInfo.getBoundObject(), view, modelInfo.getAdapterPosition());
            unit = Unit.INSTANCE;
        } else {
            unit = null;
        }
        if (unit == null) {
            throw new IllegalStateException("Original click listener is null".toString());
        }
    }

    public boolean onLongClick(@NotNull View view) {
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        ClickedModelInfo clickedModelInfo = this.getClickedModelInfo(view);
        if (clickedModelInfo == null) {
            return false;
        }
        ClickedModelInfo modelInfo = clickedModelInfo;
        OnModelLongClickListener<EpoxyModel<?>, Object> onModelLongClickListener = this.originalLongClickListener;
        if (onModelLongClickListener == null) {
            throw new IllegalStateException("Original long click listener is null".toString());
        }
        EpoxyModel<?> epoxyModel = modelInfo.getModel();
        Intrinsics.checkNotNull(epoxyModel, (String)"null cannot be cast to non-null type T of com.airbnb.epoxy.WrappedEpoxyModelClickListener");
        return onModelLongClickListener.onLongClick(epoxyModel, modelInfo.getBoundObject(), view, modelInfo.getAdapterPosition());
    }

    /*
     * WARNING - void declaration
     */
    private final ClickedModelInfo getClickedModelInfo(View view) {
        EpoxyViewHolder epoxyViewHolder;
        EpoxyViewHolder epoxyViewHolder2 = ListenersUtils.getEpoxyHolderForChildView(view);
        if (epoxyViewHolder2 == null) {
            throw new IllegalStateException("Could not find RecyclerView holder for clicked view".toString());
        }
        EpoxyViewHolder epoxyHolder = epoxyViewHolder2;
        int adapterPosition = epoxyHolder.getAdapterPosition();
        if (adapterPosition == -1) {
            return null;
        }
        Object object = epoxyHolder.objectToBind();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"epoxyHolder.objectToBind()");
        Object boundObject = object;
        if (boundObject instanceof ModelGroupHolder) {
            Object v3;
            block6: {
                void $this$firstOrNull$iv;
                Iterable iterable = ((ModelGroupHolder)boundObject).getViewHolders();
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    EpoxyViewHolder it = (EpoxyViewHolder)((Object)element$iv);
                    boolean bl = false;
                    View view2 = it.itemView;
                    Intrinsics.checkNotNullExpressionValue((Object)view2, (String)"it.itemView");
                    if (!SequencesKt.contains(this.getAllViewsInHierarchy(view2), (Object)view)) continue;
                    v3 = element$iv;
                    break block6;
                }
                v3 = null;
            }
            if ((epoxyViewHolder = (EpoxyViewHolder)v3) == null) {
                epoxyViewHolder = epoxyHolder;
            }
        } else {
            epoxyViewHolder = epoxyHolder;
        }
        EpoxyViewHolder holderToUse = epoxyViewHolder;
        EpoxyModel<?> epoxyModel = holderToUse.getModel();
        Intrinsics.checkNotNullExpressionValue(epoxyModel, (String)"holderToUse.model");
        Object object2 = holderToUse.objectToBind();
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"holderToUse.objectToBind()");
        return new ClickedModelInfo(epoxyModel, adapterPosition, object2);
    }

    private final Sequence<View> getAllViewsInHierarchy(View $this$allViewsInHierarchy) {
        Sequence sequence;
        if ($this$allViewsInHierarchy instanceof ViewGroup) {
            sequence = SequencesKt.plus((Sequence)SequencesKt.flatMap(this.getChildren$epoxy_adapter_release((ViewGroup)$this$allViewsInHierarchy), (Function1)((Function1)new Function1<View, Sequence<? extends View>>(this){
                final /* synthetic */ WrappedEpoxyModelClickListener<T, V> this$0;
                {
                    this.this$0 = $receiver;
                    super(1);
                }

                @NotNull
                public final Sequence<View> invoke(@NotNull View it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    Object[] objectArray = new View[]{it};
                    return SequencesKt.plus((Sequence)SequencesKt.sequenceOf((Object[])objectArray), (Sequence)(it instanceof ViewGroup ? WrappedEpoxyModelClickListener.access$getAllViewsInHierarchy(this.this$0, it) : SequencesKt.emptySequence()));
                }
            })), (Object)$this$allViewsInHierarchy);
        } else {
            Object[] objectArray = new View[]{$this$allViewsInHierarchy};
            sequence = SequencesKt.sequenceOf((Object[])objectArray);
        }
        return sequence;
    }

    @NotNull
    public final Sequence<View> getChildren$epoxy_adapter_release(@NotNull ViewGroup $this$children) {
        Intrinsics.checkNotNullParameter((Object)$this$children, (String)"<this>");
        return (Sequence)new Sequence<View>(this, $this$children){
            final /* synthetic */ WrappedEpoxyModelClickListener<T, V> this$0;
            final /* synthetic */ ViewGroup $this_children;
            {
                this.this$0 = $receiver;
                this.$this_children = $receiver2;
            }

            @NotNull
            public Iterator<View> iterator() {
                return this.this$0.iterator$epoxy_adapter_release(this.$this_children);
            }
        };
    }

    @NotNull
    public final Iterator<View> iterator$epoxy_adapter_release(@NotNull ViewGroup $this$iterator) {
        Intrinsics.checkNotNullParameter((Object)$this$iterator, (String)"<this>");
        return new Iterator<View>($this$iterator){
            private int index;
            final /* synthetic */ ViewGroup $this_iterator;
            {
                this.$this_iterator = $receiver;
            }

            public boolean hasNext() {
                return this.index < this.$this_iterator.getChildCount();
            }

            @NotNull
            public View next() {
                int n = this.index;
                this.index = n + 1;
                View view = this.$this_iterator.getChildAt(n);
                if (view == null) {
                    throw new IndexOutOfBoundsException();
                }
                return view;
            }

            public void remove() {
                this.index += -1;
                this.$this_iterator.removeViewAt(this.index);
            }
        };
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof WrappedEpoxyModelClickListener)) {
            return false;
        }
        boolean bl = this.originalClickListener != null ? !Intrinsics.areEqual(this.originalClickListener, ((WrappedEpoxyModelClickListener)other).originalClickListener) : ((WrappedEpoxyModelClickListener)other).originalClickListener != null;
        if (bl) {
            return false;
        }
        return this.originalLongClickListener != null ? Intrinsics.areEqual(this.originalLongClickListener, ((WrappedEpoxyModelClickListener)other).originalLongClickListener) : ((WrappedEpoxyModelClickListener)other).originalLongClickListener == null;
    }

    public int hashCode() {
        OnModelClickListener<T, V> onModelClickListener = this.originalClickListener;
        int result = onModelClickListener != null ? onModelClickListener.hashCode() : 0;
        OnModelLongClickListener<T, V> onModelLongClickListener = this.originalLongClickListener;
        result = 31 * result + (onModelLongClickListener != null ? onModelLongClickListener.hashCode() : 0);
        return result;
    }

    public static final /* synthetic */ Sequence access$getAllViewsInHierarchy(WrappedEpoxyModelClickListener $this, View $receiver) {
        return $this.getAllViewsInHierarchy($receiver);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\t\b\u0002\u0018\u00002\u00020\u0001B!\u0012\n\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0001\u00a2\u0006\u0002\u0010\u0007R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0006\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0015\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u000e"}, d2={"Lcom/airbnb/epoxy/WrappedEpoxyModelClickListener$ClickedModelInfo;", "", "model", "Lcom/airbnb/epoxy/EpoxyModel;", "adapterPosition", "", "boundObject", "(Lcom/airbnb/epoxy/EpoxyModel;ILjava/lang/Object;)V", "getAdapterPosition", "()I", "getBoundObject", "()Ljava/lang/Object;", "getModel", "()Lcom/airbnb/epoxy/EpoxyModel;", "epoxy-adapter_release"})
    private static final class ClickedModelInfo {
        @NotNull
        private final EpoxyModel<?> model;
        private final int adapterPosition;
        @NotNull
        private final Object boundObject;

        public ClickedModelInfo(@NotNull EpoxyModel<?> model, int adapterPosition, @NotNull Object boundObject) {
            Intrinsics.checkNotNullParameter(model, (String)"model");
            Intrinsics.checkNotNullParameter((Object)boundObject, (String)"boundObject");
            this.model = model;
            this.adapterPosition = adapterPosition;
            this.boundObject = boundObject;
        }

        @NotNull
        public final EpoxyModel<?> getModel() {
            return this.model;
        }

        public final int getAdapterPosition() {
            return this.adapterPosition;
        }

        @NotNull
        public final Object getBoundObject() {
            return this.boundObject;
        }
    }
}

