package com.airbnb.epoxy;

import androidx.annotation.DimenRes;
import androidx.annotation.Dimension;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import java.lang.CharSequence;
import java.lang.Number;
import java.util.List;

@EpoxyBuildScope
public interface CarouselModelBuilder {
  CarouselModelBuilder onBind(OnModelBoundListener<CarouselModel_, Carousel> listener);

  CarouselModelBuilder onUnbind(OnModelUnboundListener<CarouselModel_, Carousel> listener);

  CarouselModelBuilder onVisibilityStateChanged(
      OnModelVisibilityStateChangedListener<CarouselModel_, Carousel> listener);

  CarouselModelBuilder onVisibilityChanged(
      OnModelVisibilityChangedListener<CarouselModel_, Carousel> listener);

  CarouselModelBuilder hasFixedSize(boolean hasFixedSize);

  CarouselModelBuilder numViewsToShowOnScreen(float numViewsToShowOnScreen);

  CarouselModelBuilder initialPrefetchItemCount(int initialPrefetchItemCount);

  CarouselModelBuilder paddingRes(@DimenRes int paddingRes);

  CarouselModelBuilder paddingDp(@Dimension(unit = 0) int paddingDp);

  CarouselModelBuilder padding(@Nullable Carousel.Padding padding);

  CarouselModelBuilder models(@NonNull List<? extends EpoxyModel<?>> models);

  CarouselModelBuilder id(long id);

  CarouselModelBuilder id(@Nullable Number... ids);

  CarouselModelBuilder id(long id1, long id2);

  CarouselModelBuilder id(@Nullable CharSequence key);

  CarouselModelBuilder id(@Nullable CharSequence key, @Nullable CharSequence... otherKeys);

  CarouselModelBuilder id(@Nullable CharSequence key, long id);

  CarouselModelBuilder spanSizeOverride(
      @Nullable EpoxyModel.SpanSizeOverrideCallback spanSizeCallback);
}
