package com.airbnb.epoxy;

import android.view.ViewGroup;
import androidx.annotation.DimenRes;
import androidx.annotation.Dimension;
import androidx.annotation.LayoutRes;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import java.lang.CharSequence;
import java.lang.IllegalArgumentException;
import java.lang.IllegalStateException;
import java.lang.Number;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.UnsupportedOperationException;
import java.util.BitSet;
import java.util.List;

/**
 * Generated file. Do not modify!
 */
public class CarouselModel_ extends EpoxyModel<Carousel> implements GeneratedModel<Carousel>, CarouselModelBuilder {
  private final BitSet assignedAttributes_epoxyGeneratedModel = new BitSet(7);

  private OnModelBoundListener<CarouselModel_, Carousel> onModelBoundListener_epoxyGeneratedModel;

  private OnModelUnboundListener<CarouselModel_, Carousel> onModelUnboundListener_epoxyGeneratedModel;

  private OnModelVisibilityStateChangedListener<CarouselModel_, Carousel> onModelVisibilityStateChangedListener_epoxyGeneratedModel;

  private OnModelVisibilityChangedListener<CarouselModel_, Carousel> onModelVisibilityChangedListener_epoxyGeneratedModel;

  private boolean hasFixedSize_Boolean = false;

  /**
   * Bitset index: 1
   */
  private float numViewsToShowOnScreen_Float = 0.0f;

  /**
   * Bitset index: 2
   */
  private int initialPrefetchItemCount_Int = 0;

  /**
   * Bitset index: 3
   */
  @DimenRes
  private int paddingRes_Int = 0;

  /**
   * Bitset index: 4
   */
  @Dimension(
      unit = 0
  )
  private int paddingDp_Int = Carousel.NO_VALUE_SET;

  /**
   * Bitset index: 5
   */
  @Nullable
  private Carousel.Padding padding_Padding = (Carousel.Padding) null;

  /**
   * Bitset index: 6
   */
  @NonNull
  private List<? extends EpoxyModel<?>> models_List;

  @Override
  public void addTo(EpoxyController controller) {
    super.addTo(controller);
    addWithDebugValidation(controller);
    if (!assignedAttributes_epoxyGeneratedModel.get(6)) {
    	throw new IllegalStateException("A value is required for setModels");
    }
  }

  @Override
  protected int getViewType() {
    return 0;
  }

  @Override
  public Carousel buildView(ViewGroup parent) {
    Carousel v = new Carousel(parent.getContext());
    v.setLayoutParams(new ViewGroup.MarginLayoutParams(ViewGroup.MarginLayoutParams.MATCH_PARENT, ViewGroup.MarginLayoutParams.WRAP_CONTENT));
    return v;
  }

  @Override
  public void handlePreBind(final EpoxyViewHolder holder, final Carousel object,
      final int position) {
    validateStateHasNotChangedSinceAdded("The model was changed between being added to the controller and being bound.", position);
  }

  @Override
  public void bind(final Carousel object) {
    super.bind(object);
    if (assignedAttributes_epoxyGeneratedModel.get(3)) {
      object.setPaddingRes(paddingRes_Int);
    }
    else if (assignedAttributes_epoxyGeneratedModel.get(4)) {
      object.setPaddingDp(paddingDp_Int);
    }
    else if (assignedAttributes_epoxyGeneratedModel.get(5)) {
      object.setPadding(padding_Padding);
    }
    else {
      object.setPaddingDp(paddingDp_Int);
    }
    object.setHasFixedSize(hasFixedSize_Boolean);
    if (assignedAttributes_epoxyGeneratedModel.get(1)) {
      object.setNumViewsToShowOnScreen(numViewsToShowOnScreen_Float);
    }
    else if (assignedAttributes_epoxyGeneratedModel.get(2)) {
      object.setInitialPrefetchItemCount(initialPrefetchItemCount_Int);
    }
    else {
      object.setNumViewsToShowOnScreen(numViewsToShowOnScreen_Float);
    }
    object.setModels(models_List);
  }

  @Override
  public void bind(final Carousel object, EpoxyModel previousModel) {
    if (!(previousModel instanceof CarouselModel_)) {
      bind(object);
      return;
    }
    CarouselModel_ that = (CarouselModel_) previousModel;
    super.bind(object);

    if (assignedAttributes_epoxyGeneratedModel.get(3)) {
      if ((paddingRes_Int != that.paddingRes_Int)) {
        object.setPaddingRes(paddingRes_Int);
      }
    }
    else if (assignedAttributes_epoxyGeneratedModel.get(4)) {
      if ((paddingDp_Int != that.paddingDp_Int)) {
        object.setPaddingDp(paddingDp_Int);
      }
    }
    else if (assignedAttributes_epoxyGeneratedModel.get(5)) {
      if (!that.assignedAttributes_epoxyGeneratedModel.get(5) || (padding_Padding != null ? !padding_Padding.equals(that.padding_Padding) : that.padding_Padding != null)) {
        object.setPadding(padding_Padding);
      }
    }
    // A value was not set so we should use the default value, but we only need to set it if the previous model had a custom value set.
    else if (that.assignedAttributes_epoxyGeneratedModel.get(3) || that.assignedAttributes_epoxyGeneratedModel.get(4) || that.assignedAttributes_epoxyGeneratedModel.get(5)) {
      object.setPaddingDp(paddingDp_Int);
    }

    if ((hasFixedSize_Boolean != that.hasFixedSize_Boolean)) {
      object.setHasFixedSize(hasFixedSize_Boolean);
    }

    if (assignedAttributes_epoxyGeneratedModel.get(1)) {
      if ((Float.compare(that.numViewsToShowOnScreen_Float, numViewsToShowOnScreen_Float) != 0)) {
        object.setNumViewsToShowOnScreen(numViewsToShowOnScreen_Float);
      }
    }
    else if (assignedAttributes_epoxyGeneratedModel.get(2)) {
      if ((initialPrefetchItemCount_Int != that.initialPrefetchItemCount_Int)) {
        object.setInitialPrefetchItemCount(initialPrefetchItemCount_Int);
      }
    }
    // A value was not set so we should use the default value, but we only need to set it if the previous model had a custom value set.
    else if (that.assignedAttributes_epoxyGeneratedModel.get(1) || that.assignedAttributes_epoxyGeneratedModel.get(2)) {
      object.setNumViewsToShowOnScreen(numViewsToShowOnScreen_Float);
    }

    if ((models_List != null ? !models_List.equals(that.models_List) : that.models_List != null)) {
      object.setModels(models_List);
    }
  }

  @Override
  public void handlePostBind(final Carousel object, int position) {
    if (onModelBoundListener_epoxyGeneratedModel != null) {
      onModelBoundListener_epoxyGeneratedModel.onModelBound(this, object, position);
    }
    validateStateHasNotChangedSinceAdded("The model was changed during the bind call.", position);
  }

  /**
   * Register a listener that will be called when this model is bound to a view.
   * <p>
   * The listener will contribute to this model's hashCode state per the {@link
   * com.airbnb.epoxy.EpoxyAttribute.Option#DoNotHash} rules.
   * <p>
   * You may clear the listener by setting a null value, or by calling {@link #reset()}
   */
  public CarouselModel_ onBind(OnModelBoundListener<CarouselModel_, Carousel> listener) {
    onMutation();
    this.onModelBoundListener_epoxyGeneratedModel = listener;
    return this;
  }

  @Override
  public void unbind(Carousel object) {
    super.unbind(object);
    if (onModelUnboundListener_epoxyGeneratedModel != null) {
      onModelUnboundListener_epoxyGeneratedModel.onModelUnbound(this, object);
    }
    object.clear();
  }

  /**
   * Register a listener that will be called when this model is unbound from a view.
   * <p>
   * The listener will contribute to this model's hashCode state per the {@link
   * com.airbnb.epoxy.EpoxyAttribute.Option#DoNotHash} rules.
   * <p>
   * You may clear the listener by setting a null value, or by calling {@link #reset()}
   */
  public CarouselModel_ onUnbind(OnModelUnboundListener<CarouselModel_, Carousel> listener) {
    onMutation();
    this.onModelUnboundListener_epoxyGeneratedModel = listener;
    return this;
  }

  @Override
  public void onVisibilityStateChanged(int visibilityState, final Carousel object) {
    if (onModelVisibilityStateChangedListener_epoxyGeneratedModel != null) {
      onModelVisibilityStateChangedListener_epoxyGeneratedModel.onVisibilityStateChanged(this, object, visibilityState);
    }
    super.onVisibilityStateChanged(visibilityState, object);
  }

  /**
   * Register a listener that will be called when this model visibility state has changed.
   * <p>
   * The listener will contribute to this model's hashCode state per the {@link
   * com.airbnb.epoxy.EpoxyAttribute.Option#DoNotHash} rules.
   */
  public CarouselModel_ onVisibilityStateChanged(
      OnModelVisibilityStateChangedListener<CarouselModel_, Carousel> listener) {
    onMutation();
    this.onModelVisibilityStateChangedListener_epoxyGeneratedModel = listener;
    return this;
  }

  @Override
  public void onVisibilityChanged(float percentVisibleHeight, float percentVisibleWidth,
      int visibleHeight, int visibleWidth, final Carousel object) {
    if (onModelVisibilityChangedListener_epoxyGeneratedModel != null) {
      onModelVisibilityChangedListener_epoxyGeneratedModel.onVisibilityChanged(this, object, percentVisibleHeight, percentVisibleWidth, visibleHeight, visibleWidth);
    }
    super.onVisibilityChanged(percentVisibleHeight, percentVisibleWidth, visibleHeight, visibleWidth, object);
  }

  /**
   * Register a listener that will be called when this model visibility has changed.
   * <p>
   * The listener will contribute to this model's hashCode state per the {@link
   * com.airbnb.epoxy.EpoxyAttribute.Option#DoNotHash} rules.
   */
  public CarouselModel_ onVisibilityChanged(
      OnModelVisibilityChangedListener<CarouselModel_, Carousel> listener) {
    onMutation();
    this.onModelVisibilityChangedListener_epoxyGeneratedModel = listener;
    return this;
  }

  /**
   * <i>Optional</i>: Default value is false
   *
   * @see Carousel#setHasFixedSize(boolean)
   */
  public CarouselModel_ hasFixedSize(boolean hasFixedSize) {
    onMutation();
    this.hasFixedSize_Boolean = hasFixedSize;
    return this;
  }

  public boolean hasFixedSize() {
    return hasFixedSize_Boolean;
  }

  /**
   * Set the number of views to show on screen in this carousel at a time, partial numbers are
   *  allowed.
   *
   *  <p>This is useful where you want to easily control for the number of items on screen,
   *  regardless of screen size. For example, you could set this to 1.2f so that one view is shown in
   *  full and 20% of the next view "peeks" from the edge to indicate that there is more content to
   *  scroll to.
   *
   *  <p>Another pattern is setting a different view count depending on whether the device is phone
   *  or tablet.
   *
   *  <p>Additionally, if a LinearLayoutManager is used this value will be forwarded to {@link
   *  LinearLayoutManager#setInitialPrefetchItemCount(int)} as a performance optimization.
   *
   *  <p>If you want to only change the prefetch count without changing the view size you can simply
   *  use {@link #setInitialPrefetchItemCount(int)}
   * <p>
   * <i>Optional</i>: Default value is 0.0f
   *
   * @see Carousel#setNumViewsToShowOnScreen(float)
   */
  public CarouselModel_ numViewsToShowOnScreen(float numViewsToShowOnScreen) {
    assignedAttributes_epoxyGeneratedModel.set(1);
    assignedAttributes_epoxyGeneratedModel.clear(2);
    this.initialPrefetchItemCount_Int = 0;
    onMutation();
    this.numViewsToShowOnScreen_Float = numViewsToShowOnScreen;
    return this;
  }

  public float numViewsToShowOnScreenFloat() {
    return numViewsToShowOnScreen_Float;
  }

  /**
   * If you are using a Linear or Grid layout manager you can use this to set the item prefetch
   *  count. Only use this if you are not using {@link #setNumViewsToShowOnScreen(float)}
   *
   *  @see #setNumViewsToShowOnScreen(float)
   *  @see LinearLayoutManager#setInitialPrefetchItemCount(int)
   * <p>
   * <i>Optional</i>: Default value is 0
   *
   * @see Carousel#setInitialPrefetchItemCount(int)
   */
  public CarouselModel_ initialPrefetchItemCount(int initialPrefetchItemCount) {
    assignedAttributes_epoxyGeneratedModel.set(2);
    assignedAttributes_epoxyGeneratedModel.clear(1);
    this.numViewsToShowOnScreen_Float = 0.0f;
    onMutation();
    this.initialPrefetchItemCount_Int = initialPrefetchItemCount;
    return this;
  }

  public int initialPrefetchItemCountInt() {
    return initialPrefetchItemCount_Int;
  }

  /**
   * Set a dimension resource to specify the padding value to use on each side of the carousel and
   *  in between carousel items.
   * <p>
   * <i>Optional</i>: Default value is 0
   *
   * @see Carousel#setPaddingRes(int)
   */
  public CarouselModel_ paddingRes(@DimenRes int paddingRes) {
    assignedAttributes_epoxyGeneratedModel.set(3);
    assignedAttributes_epoxyGeneratedModel.clear(4);
    this.paddingDp_Int = Carousel.NO_VALUE_SET;
    assignedAttributes_epoxyGeneratedModel.clear(5);
    this.padding_Padding = (Carousel.Padding) null;
    onMutation();
    this.paddingRes_Int = paddingRes;
    return this;
  }

  @DimenRes
  public int paddingResInt() {
    return paddingRes_Int;
  }

  /**
   * Set a DP value to use as the padding on each side of the carousel and in between carousel
   *  items.
   *
   *  <p>The default as the value returned by {@link #getDefaultSpacingBetweenItemsDp()}
   * <p>
   * <i>Optional</i>: Default value is <b>{@value Carousel#NO_VALUE_SET}</b>
   *
   * @see Carousel#setPaddingDp(int)
   */
  public CarouselModel_ paddingDp(@Dimension(unit = 0) int paddingDp) {
    assignedAttributes_epoxyGeneratedModel.set(4);
    assignedAttributes_epoxyGeneratedModel.clear(3);
    this.paddingRes_Int = 0;
    assignedAttributes_epoxyGeneratedModel.clear(5);
    this.padding_Padding = (Carousel.Padding) null;
    onMutation();
    this.paddingDp_Int = paddingDp;
    return this;
  }

  @Dimension(
      unit = 0
  )
  public int paddingDpInt() {
    return paddingDp_Int;
  }

  /**
   * Use the {@link Padding} class to specify individual padding values for each side of the
   *  carousel, as well as item spacing.
   *
   *  <p>A value of null will set all padding and item spacing to 0.
   * <p>
   * <i>Optional</i>: Default value is (Carousel.Padding) null
   *
   * @see Carousel#setPadding(Carousel.Padding)
   */
  public CarouselModel_ padding(@Nullable Carousel.Padding padding) {
    assignedAttributes_epoxyGeneratedModel.set(5);
    assignedAttributes_epoxyGeneratedModel.clear(3);
    this.paddingRes_Int = 0;
    assignedAttributes_epoxyGeneratedModel.clear(4);
    this.paddingDp_Int = Carousel.NO_VALUE_SET;
    onMutation();
    this.padding_Padding = padding;
    return this;
  }

  @Nullable
  public Carousel.Padding paddingPadding() {
    return padding_Padding;
  }

  /**
   * <i>Required.</i>
   *
   * @see Carousel#setModels(List<? extends EpoxyModel<?>>)
   */
  public CarouselModel_ models(@NonNull List<? extends EpoxyModel<?>> models) {
    if (models == null) {
      throw new IllegalArgumentException("models cannot be null");
    }
    assignedAttributes_epoxyGeneratedModel.set(6);
    onMutation();
    this.models_List = models;
    return this;
  }

  @NonNull
  public List<? extends EpoxyModel<?>> models() {
    return models_List;
  }

  @Override
  public CarouselModel_ id(long id) {
    super.id(id);
    return this;
  }

  @Override
  public CarouselModel_ id(@Nullable Number... ids) {
    super.id(ids);
    return this;
  }

  @Override
  public CarouselModel_ id(long id1, long id2) {
    super.id(id1, id2);
    return this;
  }

  @Override
  public CarouselModel_ id(@Nullable CharSequence key) {
    super.id(key);
    return this;
  }

  @Override
  public CarouselModel_ id(@Nullable CharSequence key, @Nullable CharSequence... otherKeys) {
    super.id(key, otherKeys);
    return this;
  }

  @Override
  public CarouselModel_ id(@Nullable CharSequence key, long id) {
    super.id(key, id);
    return this;
  }

  @Override
  public CarouselModel_ layout(@LayoutRes int layoutRes) {
    throw new UnsupportedOperationException("Layout resources are unsupported with programmatic views.");
  }

  @Override
  public CarouselModel_ spanSizeOverride(
      @Nullable EpoxyModel.SpanSizeOverrideCallback spanSizeCallback) {
    super.spanSizeOverride(spanSizeCallback);
    return this;
  }

  @Override
  public CarouselModel_ show() {
    super.show();
    return this;
  }

  @Override
  public CarouselModel_ show(boolean show) {
    super.show(show);
    return this;
  }

  @Override
  public CarouselModel_ hide() {
    super.hide();
    return this;
  }

  @Override
  @LayoutRes
  protected int getDefaultLayout() {
    throw new UnsupportedOperationException("Layout resources are unsupported for views created programmatically.");
  }

  @Override
  public CarouselModel_ reset() {
    onModelBoundListener_epoxyGeneratedModel = null;
    onModelUnboundListener_epoxyGeneratedModel = null;
    onModelVisibilityStateChangedListener_epoxyGeneratedModel = null;
    onModelVisibilityChangedListener_epoxyGeneratedModel = null;
    assignedAttributes_epoxyGeneratedModel.clear();
    this.hasFixedSize_Boolean = false;
    this.numViewsToShowOnScreen_Float = 0.0f;
    this.initialPrefetchItemCount_Int = 0;
    this.paddingRes_Int = 0;
    this.paddingDp_Int = Carousel.NO_VALUE_SET;
    this.padding_Padding = (Carousel.Padding) null;
    this.models_List = null;
    super.reset();
    return this;
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (!(o instanceof CarouselModel_)) {
      return false;
    }
    if (!super.equals(o)) {
      return false;
    }
    CarouselModel_ that = (CarouselModel_) o;
    if (((onModelBoundListener_epoxyGeneratedModel == null) != (that.onModelBoundListener_epoxyGeneratedModel == null))) {
      return false;
    }
    if (((onModelUnboundListener_epoxyGeneratedModel == null) != (that.onModelUnboundListener_epoxyGeneratedModel == null))) {
      return false;
    }
    if (((onModelVisibilityStateChangedListener_epoxyGeneratedModel == null) != (that.onModelVisibilityStateChangedListener_epoxyGeneratedModel == null))) {
      return false;
    }
    if (((onModelVisibilityChangedListener_epoxyGeneratedModel == null) != (that.onModelVisibilityChangedListener_epoxyGeneratedModel == null))) {
      return false;
    }
    if ((hasFixedSize_Boolean != that.hasFixedSize_Boolean)) {
      return false;
    }
    if ((Float.compare(that.numViewsToShowOnScreen_Float, numViewsToShowOnScreen_Float) != 0)) {
      return false;
    }
    if ((initialPrefetchItemCount_Int != that.initialPrefetchItemCount_Int)) {
      return false;
    }
    if ((paddingRes_Int != that.paddingRes_Int)) {
      return false;
    }
    if ((paddingDp_Int != that.paddingDp_Int)) {
      return false;
    }
    if ((padding_Padding != null ? !padding_Padding.equals(that.padding_Padding) : that.padding_Padding != null)) {
      return false;
    }
    if ((models_List != null ? !models_List.equals(that.models_List) : that.models_List != null)) {
      return false;
    }
    return true;
  }

  @Override
  public int hashCode() {
    int _result = super.hashCode();
    _result = 31 * _result + (onModelBoundListener_epoxyGeneratedModel != null ? 1 : 0);
    _result = 31 * _result + (onModelUnboundListener_epoxyGeneratedModel != null ? 1 : 0);
    _result = 31 * _result + (onModelVisibilityStateChangedListener_epoxyGeneratedModel != null ? 1 : 0);
    _result = 31 * _result + (onModelVisibilityChangedListener_epoxyGeneratedModel != null ? 1 : 0);
    _result = 31 * _result + (hasFixedSize_Boolean ? 1 : 0);
    _result = 31 * _result + (numViewsToShowOnScreen_Float != +0.0f ? Float.floatToIntBits(numViewsToShowOnScreen_Float) : 0);
    _result = 31 * _result + initialPrefetchItemCount_Int;
    _result = 31 * _result + paddingRes_Int;
    _result = 31 * _result + paddingDp_Int;
    _result = 31 * _result + (padding_Padding != null ? padding_Padding.hashCode() : 0);
    _result = 31 * _result + (models_List != null ? models_List.hashCode() : 0);
    return _result;
  }

  @Override
  public String toString() {
    return "CarouselModel_{" +
        "hasFixedSize_Boolean=" + hasFixedSize_Boolean +
        ", numViewsToShowOnScreen_Float=" + numViewsToShowOnScreen_Float +
        ", initialPrefetchItemCount_Int=" + initialPrefetchItemCount_Int +
        ", paddingRes_Int=" + paddingRes_Int +
        ", paddingDp_Int=" + paddingDp_Int +
        ", padding_Padding=" + padding_Padding +
        ", models_List=" + models_List +
        "}" + super.toString();
  }

  @Override
  public boolean shouldSaveViewState() {
    return true;
  }

  @Override
  public int getSpanSize(int totalSpanCount, int position, int itemCount) {
    return totalSpanCount;
  }
}
