/*
 * Decompiled with CFR 0.152.
 */
package com.airbnb.lottie;

import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.content.Context;
import android.graphics.PointF;
import android.view.View;
import android.view.ViewTreeObserver;
import android.view.animation.LinearInterpolator;
import com.airbnb.lottie.R;
import com.airbnb.lottie.animation.KeyframeAnimation;
import com.airbnb.lottie.model.Layer;
import com.airbnb.lottie.model.LottieComposition;
import com.airbnb.lottie.utils.ScaleXY;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class LottieViewAnimator {
    private final LottieComposition.OnCompositionLoadedListener loadedListener = new LottieComposition.OnCompositionLoadedListener(){

        @Override
        public void onCompositionLoaded(LottieComposition composition) {
            LottieViewAnimator.this.setComposition(composition);
        }
    };
    private final ValueAnimator animator = ValueAnimator.ofFloat((float[])new float[]{0.0f, 1.0f});
    private final Map<String, View> viewsMap;
    private final List<KeyframeAnimation<?>> animatableValues = new ArrayList();
    private LottieComposition composition;
    private boolean startWhenReady = false;

    public static LottieViewAnimator of(Context context, String fileName, View ... views) {
        return new LottieViewAnimator(context, fileName, views);
    }

    private LottieViewAnimator(Context context, String fileName, View ... views) {
        this.viewsMap = new HashMap<String, View>(views.length);
        for (View view : views) {
            Object tag = view.getTag(R.id.lottie_layer_name);
            if (tag == null) continue;
            this.viewsMap.put((String)tag, view);
        }
        this.animator.setInterpolator((TimeInterpolator)new LinearInterpolator());
        this.animator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator animation) {
                for (KeyframeAnimation av : LottieViewAnimator.this.animatableValues) {
                    av.setProgress(animation.getAnimatedFraction());
                }
            }
        });
        LottieComposition.fromAssetFileName(context, fileName, this.loadedListener);
    }

    private void setComposition(LottieComposition composition) {
        this.composition = composition;
        this.animator.setDuration(composition.getDuration());
        for (final Layer layer : composition.getLayers()) {
            final View view = this.viewsMap.get(layer.getName());
            if (view == null) continue;
            if (layer.getPosition().hasAnimation()) {
                KeyframeAnimation<PointF> position = layer.getPosition().createAnimation();
                position.addUpdateListener(new KeyframeAnimation.AnimationListener<PointF>(){

                    @Override
                    public void onValueChanged(PointF progress) {
                        PointF initialPoint = layer.getPosition().getInitialPoint();
                        view.setTranslationX(progress.x - initialPoint.x);
                        view.setTranslationY(progress.y - initialPoint.y);
                    }
                });
                this.animatableValues.add(position);
            }
            if (layer.getScale().hasAnimation()) {
                KeyframeAnimation<ScaleXY> scale = layer.getScale().createAnimation();
                scale.addUpdateListener(new KeyframeAnimation.AnimationListener<ScaleXY>(){

                    @Override
                    public void onValueChanged(ScaleXY scale) {
                        view.setScaleX(scale.getScaleX());
                        view.setScaleY(scale.getScaleY());
                    }
                });
                this.animatableValues.add(scale);
            }
            ScaleXY initialScale = (ScaleXY)layer.getScale().getInitialValue();
            view.setScaleX(initialScale.getScaleX());
            view.setScaleY(initialScale.getScaleY());
            if (layer.getRotation().hasAnimation()) {
                KeyframeAnimation<Float> rotation = layer.getRotation().createAnimation();
                rotation.addUpdateListener(new KeyframeAnimation.AnimationListener<Float>(){

                    @Override
                    public void onValueChanged(Float rotation) {
                        view.setRotation(rotation.floatValue());
                    }
                });
                this.animatableValues.add(rotation);
            }
            view.setRotation(layer.getRotation().getInitialValue().floatValue());
            if (layer.getOpacity().hasAnimation()) {
                KeyframeAnimation<Integer> opacity = layer.getOpacity().createAnimation();
                opacity.addUpdateListener(new KeyframeAnimation.AnimationListener<Integer>(){

                    @Override
                    public void onValueChanged(Integer progress) {
                        view.setAlpha((float)progress.intValue() / 255.0f);
                    }
                });
                this.animatableValues.add(opacity);
            }
            view.setAlpha((float)layer.getOpacity().getInitialValue().intValue() / 255.0f);
            if (layer.getAnchor().hasAnimation()) {
                KeyframeAnimation<PointF> anchor = layer.getAnchor().createAnimation();
                anchor.addUpdateListener(new KeyframeAnimation.AnimationListener<PointF>(){

                    @Override
                    public void onValueChanged(PointF anchor) {
                        LottieViewAnimator.this.setViewAnchor(view, anchor);
                    }
                });
            }
            if (view.getWidth() > 0) {
                this.setViewAnchor(view, layer.getAnchor().getInitialPoint());
                continue;
            }
            view.getViewTreeObserver().addOnGlobalLayoutListener(new ViewTreeObserver.OnGlobalLayoutListener(){

                public void onGlobalLayout() {
                    view.getViewTreeObserver().removeOnGlobalLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
                    LottieViewAnimator.this.setViewAnchor(view, layer.getAnchor().getInitialPoint());
                }
            });
        }
        if (this.startWhenReady) {
            this.startWhenReady = false;
            this.start();
        }
    }

    public LottieViewAnimator start() {
        if (this.animatableValues.isEmpty()) {
            this.startWhenReady = true;
            return this;
        }
        this.animator.start();
        return this;
    }

    public LottieViewAnimator cancel() {
        this.animator.cancel();
        return this;
    }

    public LottieViewAnimator loop(boolean loop) {
        this.animator.setRepeatCount(loop ? -1 : 0);
        return this;
    }

    public LottieViewAnimator setProgress(float progress) {
        this.animator.setCurrentPlayTime((long)(progress * (float)this.animator.getDuration()));
        return this;
    }

    private void setViewAnchor(View view, PointF anchor) {
        view.setPivotX(anchor.x * (float)view.getWidth() / (100.0f * this.composition.getScale()));
        view.setPivotY(anchor.y * (float)view.getHeight() / (100.0f * this.composition.getScale()));
    }
}

