/*
 * Decompiled with CFR 0.152.
 */
package com.airbnb.lottie.animatable;

import android.support.annotation.RestrictTo;
import com.airbnb.lottie.animatable.BaseAnimatableValue;
import com.airbnb.lottie.animation.KeyframeAnimation;
import com.airbnb.lottie.animation.NumberKeyframeAnimation;
import com.airbnb.lottie.animation.StaticKeyframeAnimation;
import com.airbnb.lottie.model.LottieComposition;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public class AnimatableFloatValue
extends BaseAnimatableValue<Float, Float> {
    public AnimatableFloatValue(LottieComposition composition, Float initialValue) {
        super(composition);
        this.initialValue = initialValue;
    }

    public AnimatableFloatValue(JSONObject json, int frameRate, LottieComposition composition) {
        this(json, frameRate, composition, true);
    }

    public AnimatableFloatValue(JSONObject json, int frameRate, LottieComposition composition, boolean isDp) {
        super(json, frameRate, composition, isDp);
    }

    @Override
    protected Float valueFromObject(Object object, float scale) throws JSONException {
        if (object instanceof JSONArray) {
            object = ((JSONArray)object).get(0);
        }
        if (object instanceof Float) {
            return Float.valueOf(((Float)object).floatValue() * scale);
        }
        if (object instanceof Double) {
            return Float.valueOf((float)((Double)object * (double)scale));
        }
        if (object instanceof Integer) {
            return Float.valueOf((float)((Integer)object).intValue() * scale);
        }
        return null;
    }

    @Override
    public KeyframeAnimation<Float> createAnimation() {
        if (!this.hasAnimation()) {
            return new StaticKeyframeAnimation<Object>(this.initialValue);
        }
        NumberKeyframeAnimation<Float> animation = new NumberKeyframeAnimation<Float>(this.duration, this.composition, this.keyTimes, Float.class, this.keyValues, this.interpolators);
        animation.setStartDelay(this.delay);
        return animation;
    }

    @Override
    public Float getInitialValue() {
        return (Float)this.initialValue;
    }
}

