/*
 * Decompiled with CFR 0.152.
 */
package com.airbnb.lottie.animatable;

import android.support.annotation.RestrictTo;
import com.airbnb.lottie.animatable.BaseAnimatableValue;
import com.airbnb.lottie.animation.KeyframeAnimation;
import com.airbnb.lottie.animation.NumberKeyframeAnimation;
import com.airbnb.lottie.animation.StaticKeyframeAnimation;
import com.airbnb.lottie.model.LottieComposition;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public class AnimatableIntegerValue
extends BaseAnimatableValue<Integer, Integer> {
    public AnimatableIntegerValue(LottieComposition composition, Integer initialValue) {
        super(composition);
        this.initialValue = initialValue;
    }

    public AnimatableIntegerValue(JSONObject json, int frameRate, LottieComposition composition, boolean isDp, boolean remap100To255) {
        super(json, frameRate, composition, isDp);
        if (remap100To255) {
            this.initialValue = (Integer)this.initialValue * 255 / 100;
            for (int i = 0; i < this.keyValues.size(); ++i) {
                this.keyValues.set(i, (Integer)this.keyValues.get(i) * 255 / 100);
            }
        }
    }

    @Override
    protected Integer valueFromObject(Object object, float scale) throws JSONException {
        if (object instanceof Integer) {
            return Math.round((float)((Integer)object).intValue() * scale);
        }
        if (object instanceof JSONArray && ((JSONArray)object).get(0) instanceof Integer) {
            return Math.round((float)((JSONArray)object).getInt(0) * scale);
        }
        return null;
    }

    @Override
    public KeyframeAnimation<Integer> createAnimation() {
        if (!this.hasAnimation()) {
            return new StaticKeyframeAnimation<Object>(this.initialValue);
        }
        NumberKeyframeAnimation<Integer> animation = new NumberKeyframeAnimation<Integer>(this.duration, this.composition, this.keyTimes, Integer.class, this.keyValues, this.interpolators);
        animation.setStartDelay(this.delay);
        return animation;
    }

    @Override
    public Integer getInitialValue() {
        return (Integer)this.initialValue;
    }
}

