/*
 * Decompiled with CFR 0.152.
 */
package com.airbnb.lottie.animatable;

import android.graphics.PointF;
import android.support.annotation.RestrictTo;
import android.support.v4.view.animation.PathInterpolatorCompat;
import android.view.animation.Interpolator;
import android.view.animation.LinearInterpolator;
import com.airbnb.lottie.animatable.AnimatableValue;
import com.airbnb.lottie.animation.KeyframeAnimation;
import com.airbnb.lottie.animation.PathKeyframeAnimation;
import com.airbnb.lottie.animation.StaticKeyframeAnimation;
import com.airbnb.lottie.model.LottieComposition;
import com.airbnb.lottie.utils.JsonUtils;
import com.airbnb.lottie.utils.SegmentedPath;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public class AnimatablePathValue
implements AnimatableValue {
    private final List<Float> keyTimes = new ArrayList<Float>();
    private final List<Interpolator> interpolators = new ArrayList<Interpolator>();
    private final int frameRate;
    private final LottieComposition composition;
    private PointF initialPoint;
    private final SegmentedPath animationPath = new SegmentedPath();
    private long delay;
    private long duration;
    private long startFrame;
    private long durationFrames;

    public AnimatablePathValue(LottieComposition composition) {
        this.frameRate = 0;
        this.composition = composition;
        this.initialPoint = new PointF(0.0f, 0.0f);
    }

    public AnimatablePathValue(JSONObject pointValues, int frameRate, LottieComposition composition) {
        Object value;
        this.frameRate = frameRate;
        this.composition = composition;
        try {
            value = pointValues.get("k");
        }
        catch (JSONException e) {
            throw new IllegalArgumentException("Point values have no keyframes.");
        }
        if (value instanceof JSONArray) {
            Object firstObject;
            try {
                firstObject = ((JSONArray)value).get(0);
            }
            catch (JSONException e) {
                throw new IllegalArgumentException("Unable to parse value.");
            }
            if (firstObject instanceof JSONObject && ((JSONObject)firstObject).has("t")) {
                this.buildAnimationForKeyframes((JSONArray)value);
            } else {
                this.initialPoint = JsonUtils.pointFromJsonArray((JSONArray)value, composition.getScale());
            }
        }
    }

    private void buildAnimationForKeyframes(JSONArray keyframes) {
        try {
            int i;
            for (i = 0; i < keyframes.length(); ++i) {
                JSONObject kf = keyframes.getJSONObject(i);
                if (!kf.has("t")) continue;
                this.startFrame = kf.getLong("t");
                break;
            }
            for (i = keyframes.length() - 1; i >= 0; --i) {
                JSONObject keyframe = keyframes.getJSONObject(i);
                if (!keyframe.has("t")) continue;
                long endFrame = keyframe.getLong("t");
                if (endFrame <= this.startFrame) {
                    throw new IllegalStateException("Invalid frame compDuration " + this.startFrame + "->" + endFrame);
                }
                this.durationFrames = endFrame - this.startFrame;
                this.duration = (long)((float)this.durationFrames / (float)this.frameRate * 1000.0f);
                this.delay = (long)((float)this.startFrame / (float)this.frameRate * 1000.0f);
                break;
            }
            boolean addStartValue = true;
            boolean addTimePadding = false;
            PointF outPoint = null;
            for (int i2 = 0; i2 < keyframes.length(); ++i2) {
                PointF startPoint;
                JSONObject keyframe = keyframes.getJSONObject(i2);
                long frame = keyframe.getLong("t");
                float timePercentage = (float)(frame - this.startFrame) / (float)this.durationFrames;
                if (outPoint != null) {
                    PointF vertex = outPoint;
                    this.animationPath.lineTo(vertex.x, vertex.y);
                    this.interpolators.add((Interpolator)new LinearInterpolator());
                    outPoint = null;
                }
                float scale = this.composition.getScale();
                PointF pointF = startPoint = keyframe.has("s") ? JsonUtils.pointFromJsonArray(keyframe.getJSONArray("s"), scale) : new PointF();
                if (addStartValue) {
                    if (i2 == 0) {
                        this.animationPath.moveTo(startPoint.x, startPoint.y);
                        this.initialPoint = startPoint;
                    } else {
                        this.animationPath.lineTo(startPoint.x, startPoint.y);
                        this.interpolators.add((Interpolator)new LinearInterpolator());
                    }
                    addStartValue = false;
                }
                if (addTimePadding) {
                    float holdPercentage = timePercentage - 1.0E-5f;
                    this.keyTimes.add(Float.valueOf(holdPercentage));
                    addTimePadding = false;
                }
                if (keyframe.has("e")) {
                    LinearInterpolator interpolator;
                    PointF cp1 = keyframe.has("to") ? JsonUtils.pointFromJsonArray(keyframe.getJSONArray("to"), scale) : null;
                    PointF cp2 = keyframe.has("ti") ? JsonUtils.pointFromJsonArray(keyframe.getJSONArray("ti"), scale) : null;
                    PointF vertex = JsonUtils.pointFromJsonArray(keyframe.getJSONArray("e"), scale);
                    if (cp1 != null && cp2 != null && cp1.length() != 0.0f && cp2.length() != 0.0f) {
                        this.animationPath.cubicTo(startPoint.x + cp1.x, startPoint.y + cp1.y, vertex.x + cp2.x, vertex.y + cp2.y, vertex.x, vertex.y);
                    } else {
                        this.animationPath.lineTo(vertex.x, vertex.y);
                    }
                    if (keyframe.has("o") && keyframe.has("i")) {
                        cp1 = JsonUtils.pointValueFromJsonObject(keyframe.getJSONObject("o"), scale);
                        cp2 = JsonUtils.pointValueFromJsonObject(keyframe.getJSONObject("i"), scale);
                        interpolator = PathInterpolatorCompat.create((float)(cp1.x / scale), (float)(cp1.y / scale), (float)(cp2.x / scale), (float)(cp2.y / scale));
                    } else {
                        interpolator = new LinearInterpolator();
                    }
                    this.interpolators.add((Interpolator)interpolator);
                }
                this.keyTimes.add(Float.valueOf(timePercentage));
                if (!keyframe.has("h") || keyframe.getInt("h") != 1) continue;
                outPoint = startPoint;
                addStartValue = true;
                addTimePadding = true;
            }
        }
        catch (JSONException e) {
            throw new IllegalArgumentException("Unable to parse keyframes " + keyframes, e);
        }
    }

    @Override
    public KeyframeAnimation<PointF> createAnimation() {
        if (!this.hasAnimation()) {
            return new StaticKeyframeAnimation<PointF>(this.initialPoint);
        }
        PathKeyframeAnimation animation = new PathKeyframeAnimation(this.duration, this.composition, this.keyTimes, this.animationPath, this.interpolators);
        animation.setStartDelay(this.delay);
        return animation;
    }

    @Override
    public boolean hasAnimation() {
        return this.animationPath.hasSegments();
    }

    public PointF getInitialPoint() {
        return this.initialPoint;
    }

    public String toString() {
        return "initialPoint=" + this.initialPoint;
    }
}

