/*
 * Decompiled with CFR 0.152.
 */
package com.airbnb.lottie.animatable;

import android.support.annotation.RestrictTo;
import com.airbnb.lottie.animatable.BaseAnimatableValue;
import com.airbnb.lottie.animation.KeyframeAnimation;
import com.airbnb.lottie.animation.ScaleKeyframeAnimation;
import com.airbnb.lottie.animation.StaticKeyframeAnimation;
import com.airbnb.lottie.model.LottieComposition;
import com.airbnb.lottie.utils.ScaleXY;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public class AnimatableScaleValue
extends BaseAnimatableValue<ScaleXY, ScaleXY> {
    public AnimatableScaleValue(LottieComposition composition) {
        super(composition);
        this.initialValue = new ScaleXY();
    }

    public AnimatableScaleValue(JSONObject scaleValues, int frameRate, LottieComposition composition, boolean isDp) {
        super(scaleValues, frameRate, composition, isDp);
    }

    @Override
    protected ScaleXY valueFromObject(Object object, float scale) throws JSONException {
        JSONArray array = (JSONArray)object;
        try {
            if (array.length() >= 2) {
                return new ScaleXY().scale((float)array.getDouble(0) / 100.0f * scale, (float)array.getDouble(1) / 100.0f * scale);
            }
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        return new ScaleXY();
    }

    @Override
    public KeyframeAnimation<ScaleXY> createAnimation() {
        if (!this.hasAnimation()) {
            return new StaticKeyframeAnimation<Object>(this.initialValue);
        }
        ScaleKeyframeAnimation animation = new ScaleKeyframeAnimation(this.duration, this.composition, this.keyTimes, this.keyValues, this.interpolators);
        animation.setStartDelay(this.delay);
        return animation;
    }
}

