/*
 * Decompiled with CFR 0.152.
 */
package com.airbnb.lottie.animatable;

import android.graphics.PointF;
import android.support.annotation.Nullable;
import android.support.v4.view.animation.PathInterpolatorCompat;
import android.view.animation.Interpolator;
import android.view.animation.LinearInterpolator;
import com.airbnb.lottie.animatable.AnimatableValue;
import com.airbnb.lottie.animation.KeyframeAnimation;
import com.airbnb.lottie.model.LottieComposition;
import com.airbnb.lottie.utils.JsonUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

abstract class BaseAnimatableValue<V, O>
implements AnimatableValue {
    final List<V> keyValues = new ArrayList<V>();
    final List<Float> keyTimes = new ArrayList<Float>();
    final List<Interpolator> interpolators = new ArrayList<Interpolator>();
    long delay;
    long duration;
    final LottieComposition composition;
    private final boolean isDp;
    private long startFrame;
    private long durationFrames;
    private final int frameRate;
    V initialValue;

    BaseAnimatableValue(LottieComposition composition) {
        this.composition = composition;
        this.isDp = false;
        this.frameRate = 0;
    }

    BaseAnimatableValue(@Nullable JSONObject json, int frameRate, LottieComposition composition, boolean isDp) {
        this.frameRate = frameRate;
        this.composition = composition;
        this.isDp = isDp;
        if (json != null) {
            this.init(json);
        }
    }

    void init(JSONObject json) {
        try {
            Object value = json.get("k");
            if (value instanceof JSONArray && ((JSONArray)value).get(0) instanceof JSONObject && ((JSONArray)value).getJSONObject(0).has("t")) {
                this.buildAnimationForKeyframes((JSONArray)value);
            } else {
                this.initialValue = this.valueFromObject(value, this.getScale());
            }
        }
        catch (JSONException e) {
            throw new IllegalStateException("Unable to parse json " + json, e);
        }
    }

    private void buildAnimationForKeyframes(JSONArray keyframes) {
        try {
            int i;
            for (i = 0; i < keyframes.length(); ++i) {
                JSONObject kf = keyframes.getJSONObject(i);
                if (!kf.has("t")) continue;
                this.startFrame = kf.getLong("t");
                break;
            }
            for (i = keyframes.length() - 1; i >= 0; --i) {
                JSONObject keyframe = keyframes.getJSONObject(i);
                if (!keyframe.has("t")) continue;
                long endFrame = keyframe.getLong("t");
                if (endFrame <= this.startFrame) {
                    throw new IllegalStateException("Invalid frame compDuration " + this.startFrame + "->" + endFrame);
                }
                this.durationFrames = endFrame - this.startFrame;
                this.duration = (long)((float)this.durationFrames / (float)this.frameRate * 1000.0f);
                this.delay = (long)((float)this.startFrame / (float)this.frameRate * 1000.0f);
                break;
            }
            boolean addStartValue = true;
            boolean addTimePadding = false;
            Object outValue = null;
            for (int i2 = 0; i2 < keyframes.length(); ++i2) {
                Object startValue;
                JSONObject keyframe = keyframes.getJSONObject(i2);
                long frame = keyframe.getLong("t");
                float timePercentage = (float)(frame - this.startFrame) / (float)this.durationFrames;
                if (outValue != null) {
                    this.keyValues.add(outValue);
                    this.interpolators.add((Interpolator)new LinearInterpolator());
                    outValue = null;
                }
                Object e = startValue = keyframe.has("s") ? (Object)this.valueFromObject(keyframe.getJSONArray("s"), this.getScale()) : null;
                if (addStartValue) {
                    if (startValue != null) {
                        if (i2 == 0) {
                            this.initialValue = startValue;
                        }
                        this.keyValues.add(startValue);
                        if (!this.interpolators.isEmpty()) {
                            this.interpolators.add((Interpolator)new LinearInterpolator());
                        }
                    }
                    addStartValue = false;
                }
                if (addTimePadding) {
                    float holdPercentage = timePercentage - 1.0E-5f;
                    this.keyTimes.add(Float.valueOf(holdPercentage));
                    addTimePadding = false;
                }
                if (keyframe.has("e")) {
                    LinearInterpolator timingFunction;
                    V endValue = this.valueFromObject(keyframe.getJSONArray("e"), this.getScale());
                    this.keyValues.add(endValue);
                    if (keyframe.has("o") && keyframe.has("i")) {
                        JSONObject timingControlPoint1 = keyframe.getJSONObject("o");
                        JSONObject timingControlPoint2 = keyframe.getJSONObject("i");
                        PointF cp1 = JsonUtils.pointValueFromJsonObject(timingControlPoint1, 1.0f);
                        PointF cp2 = JsonUtils.pointValueFromJsonObject(timingControlPoint2, 1.0f);
                        timingFunction = PathInterpolatorCompat.create((float)cp1.x, (float)cp1.y, (float)cp2.x, (float)cp2.y);
                    } else {
                        timingFunction = new LinearInterpolator();
                    }
                    this.interpolators.add((Interpolator)timingFunction);
                }
                this.keyTimes.add(Float.valueOf(timePercentage));
                if (!keyframe.has("h") || keyframe.getInt("h") != 1) continue;
                outValue = startValue;
                addStartValue = true;
                addTimePadding = true;
            }
        }
        catch (JSONException e) {
            throw new IllegalArgumentException("Unable to parse values.", e);
        }
    }

    private float getScale() {
        return this.isDp ? this.composition.getScale() : 1.0f;
    }

    O convertType(V value) {
        return (O)value;
    }

    @Override
    public boolean hasAnimation() {
        return !this.keyValues.isEmpty();
    }

    public O getInitialValue() {
        return this.convertType(this.initialValue);
    }

    protected abstract V valueFromObject(Object var1, float var2) throws JSONException;

    @Override
    public abstract KeyframeAnimation createAnimation();

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("initialValue=").append(this.initialValue);
        if (!this.keyValues.isEmpty()) {
            sb.append(", values=").append(Arrays.toString(this.keyTimes.toArray()));
        }
        return sb.toString();
    }
}

