/*
 * Decompiled with CFR 0.152.
 */
package com.airbnb.lottie.animation;

import android.animation.ArgbEvaluator;
import android.support.annotation.RestrictTo;
import android.view.animation.Interpolator;
import com.airbnb.lottie.animation.KeyframeAnimation;
import com.airbnb.lottie.model.LottieComposition;
import java.util.List;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public class ColorKeyframeAnimation
extends KeyframeAnimation<Integer> {
    private final ArgbEvaluator argbEvaluator = new ArgbEvaluator();
    private final List<Integer> values;

    public ColorKeyframeAnimation(long duration, LottieComposition composition, List<Float> keyTimes, List<Integer> values, List<Interpolator> interpolators) {
        super(duration, composition, keyTimes, interpolators);
        if (keyTimes.size() != values.size()) {
            throw new IllegalArgumentException("Key times and values must be the same length " + keyTimes.size() + " vs " + values.size());
        }
        this.values = values;
    }

    @Override
    public Integer getValue() {
        if (this.progress <= 0.0f) {
            return this.values.get(0);
        }
        if (this.progress >= 1.0f) {
            return this.values.get(this.values.size() - 1);
        }
        int keyframeIndex = this.getKeyframeIndex();
        float startKeytime = ((Float)this.keyTimes.get(keyframeIndex)).floatValue();
        float endKeytime = ((Float)this.keyTimes.get(keyframeIndex + 1)).floatValue();
        float percentageIntoFrame = 0.0f;
        if (!this.isDiscrete) {
            percentageIntoFrame = (this.progress - startKeytime) / (endKeytime - startKeytime);
            if (this.interpolators != null) {
                percentageIntoFrame = ((Interpolator)this.interpolators.get(keyframeIndex)).getInterpolation(percentageIntoFrame);
            }
        }
        int startColor = this.values.get(keyframeIndex);
        int endColor = this.values.get(keyframeIndex + 1);
        return (Integer)this.argbEvaluator.evaluate(percentageIntoFrame, (Object)startColor, (Object)endColor);
    }
}

