/*
 * Decompiled with CFR 0.152.
 */
package com.airbnb.lottie.animation;

import android.support.annotation.FloatRange;
import android.support.annotation.RestrictTo;
import android.view.animation.Interpolator;
import com.airbnb.lottie.model.LottieComposition;
import java.util.ArrayList;
import java.util.List;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public abstract class KeyframeAnimation<T> {
    private final List<AnimationListener<T>> listeners = new ArrayList<AnimationListener<T>>();
    private final long duration;
    private final LottieComposition composition;
    final List<Float> keyTimes;
    private long startDelay;
    boolean isDiscrete = false;
    final List<Interpolator> interpolators;
    float progress;
    private int cachedKeyframeIndex = -1;
    private float cachedKeyframeIndexStart;
    private float cachedKeyframeIndexEnd;
    private float cachedDurationEndProgress = Float.MIN_VALUE;

    KeyframeAnimation(long duration, LottieComposition composition, List<Float> keyTimes, List<Interpolator> interpolators) {
        this.duration = duration;
        this.composition = composition;
        this.keyTimes = keyTimes;
        this.interpolators = interpolators;
        if (!interpolators.isEmpty() && interpolators.size() != keyTimes.size() - 1) {
            throw new IllegalArgumentException("There must be 1 fewer interpolator than keytime " + interpolators.size() + " vs " + keyTimes.size());
        }
    }

    public void setStartDelay(long startDelay) {
        this.startDelay = startDelay;
        this.cachedDurationEndProgress = Float.MIN_VALUE;
    }

    public void setIsDiscrete() {
        this.isDiscrete = true;
    }

    public void addUpdateListener(AnimationListener<T> listener) {
        this.listeners.add(listener);
    }

    public void removeUpdateListener(AnimationListener<T> listener) {
        this.listeners.remove(listener);
    }

    public void setProgress(@FloatRange(from=0.0, to=1.0) float progress) {
        if ((progress = progress < this.getStartDelayProgress() ? 0.0f : (progress > this.getDurationEndProgress() ? 1.0f : (progress - this.getStartDelayProgress()) / this.getDurationRangeProgress())) == this.progress) {
            return;
        }
        this.progress = progress;
        T value = this.getValue();
        for (int i = 0; i < this.listeners.size(); ++i) {
            this.listeners.get(i).onValueChanged(value);
        }
    }

    int getKeyframeIndex() {
        int keyframeIndex = 1;
        if (this.cachedKeyframeIndex != -1 && this.progress >= this.cachedKeyframeIndexStart && this.progress <= this.cachedKeyframeIndexEnd) {
            keyframeIndex = this.cachedKeyframeIndex;
        } else {
            float keyTime = this.keyTimes.get(1).floatValue();
            while (keyTime < this.progress && keyframeIndex < this.keyTimes.size() - 1) {
                keyTime = this.keyTimes.get(++keyframeIndex).floatValue();
            }
            this.cachedKeyframeIndex = keyframeIndex;
            this.cachedKeyframeIndexStart = this.keyTimes.get(this.cachedKeyframeIndex - 1).floatValue();
            this.cachedKeyframeIndexEnd = this.keyTimes.get(this.cachedKeyframeIndex).floatValue();
        }
        return keyframeIndex - 1;
    }

    @FloatRange(from=0.0, to=1.0)
    private float getStartDelayProgress() {
        return (float)this.startDelay / (float)this.composition.getDuration();
    }

    @FloatRange(from=0.0, to=1.0)
    private float getDurationEndProgress() {
        if (this.cachedDurationEndProgress == Float.MIN_VALUE) {
            this.cachedDurationEndProgress = this.getStartDelayProgress() + this.getDurationRangeProgress();
        }
        return this.cachedDurationEndProgress;
    }

    @FloatRange(from=0.0, to=1.0)
    private float getDurationRangeProgress() {
        return (float)this.duration / (float)this.composition.getDuration();
    }

    public abstract T getValue();

    public static interface AnimationListener<T> {
        public void onValueChanged(T var1);
    }
}

