/*
 * Decompiled with CFR 0.152.
 */
package com.airbnb.lottie.animation;

import android.graphics.PathMeasure;
import android.graphics.PointF;
import android.support.annotation.Nullable;
import android.support.annotation.RestrictTo;
import android.view.animation.Interpolator;
import com.airbnb.lottie.animation.KeyframeAnimation;
import com.airbnb.lottie.model.LottieComposition;
import com.airbnb.lottie.utils.SegmentedPath;
import java.util.List;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public class PathKeyframeAnimation
extends KeyframeAnimation<PointF> {
    private final PointF point = new PointF();
    private final float[] pos = new float[2];
    private final SegmentedPath segmentedPath;
    private int pathMeasureKeyframeIndex = -1;
    @Nullable
    private PathMeasure pathMeasure;

    public PathKeyframeAnimation(long duration, LottieComposition composition, List<Float> keyTimes, SegmentedPath segmentedPath, List<Interpolator> interpolators) {
        super(duration, composition, keyTimes, interpolators);
        this.segmentedPath = segmentedPath;
    }

    @Override
    public PointF getValue() {
        if (this.progress <= 0.0f) {
            if (this.pathMeasureKeyframeIndex != 0 || this.pathMeasure == null) {
                this.pathMeasureKeyframeIndex = 0;
                this.pathMeasure = new PathMeasure(this.segmentedPath.getSegment(0), false);
            }
            this.pathMeasure.getPosTan(0.0f, this.pos, null);
            this.point.set(this.pos[0], this.pos[1]);
            return this.point;
        }
        if (this.progress >= 1.0f) {
            if (this.pathMeasureKeyframeIndex != this.segmentedPath.getSegmentCount() - 1 || this.pathMeasure == null) {
                this.pathMeasureKeyframeIndex = this.segmentedPath.getSegmentCount() - 1;
                this.pathMeasure = new PathMeasure(this.segmentedPath.getSegment(this.segmentedPath.getSegmentCount() - 1), false);
            }
            this.pathMeasure.getPosTan(this.pathMeasure.getLength(), this.pos, null);
            this.point.set(this.pos[0], this.pos[1]);
            return this.point;
        }
        int keyframeIndex = this.getKeyframeIndex();
        if (this.pathMeasureKeyframeIndex != keyframeIndex) {
            this.pathMeasureKeyframeIndex = keyframeIndex;
            this.pathMeasure = new PathMeasure(this.segmentedPath.getSegment(keyframeIndex), false);
        }
        float startKeytime = ((Float)this.keyTimes.get(keyframeIndex)).floatValue();
        float endKeytime = ((Float)this.keyTimes.get(keyframeIndex + 1)).floatValue();
        float percentageIntoFrame = 0.0f;
        if (!this.isDiscrete) {
            percentageIntoFrame = (this.progress - startKeytime) / (endKeytime - startKeytime);
            if (this.interpolators != null) {
                percentageIntoFrame = ((Interpolator)this.interpolators.get(keyframeIndex)).getInterpolation(percentageIntoFrame);
            }
        }
        this.pathMeasure.getPosTan(percentageIntoFrame * this.pathMeasure.getLength(), this.pos, null);
        this.point.set(this.pos[0], this.pos[1]);
        return this.point;
    }
}

