/*
 * Decompiled with CFR 0.152.
 */
package com.airbnb.lottie.animation;

import android.graphics.PointF;
import android.support.annotation.RestrictTo;
import android.view.animation.Interpolator;
import com.airbnb.lottie.animation.KeyframeAnimation;
import com.airbnb.lottie.model.LottieComposition;
import java.util.List;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public class PointKeyframeAnimation
extends KeyframeAnimation<PointF> {
    private final PointF point = new PointF();
    private final List<PointF> points;

    public PointKeyframeAnimation(long duration, LottieComposition composition, List<Float> keyTimes, List<PointF> points, List<Interpolator> interpolators) {
        super(duration, composition, keyTimes, interpolators);
        this.points = points;
    }

    @Override
    public PointF getValue() {
        if (this.progress <= 0.0f) {
            return this.points.get(0);
        }
        if (this.progress > 1.0f) {
            return this.points.get(this.points.size() - 1);
        }
        int keyframeIndex = this.getKeyframeIndex();
        float startKeytime = ((Float)this.keyTimes.get(keyframeIndex)).floatValue();
        float endKeytime = ((Float)this.keyTimes.get(keyframeIndex + 1)).floatValue();
        float percentageIntoFrame = 0.0f;
        if (!this.isDiscrete) {
            percentageIntoFrame = (this.progress - startKeytime) / (endKeytime - startKeytime);
            if (this.interpolators != null) {
                percentageIntoFrame = ((Interpolator)this.interpolators.get(keyframeIndex)).getInterpolation(percentageIntoFrame);
            }
        }
        PointF startPoint = this.points.get(keyframeIndex);
        PointF endPoint = this.points.get(keyframeIndex + 1);
        this.point.set(startPoint.x + percentageIntoFrame * (endPoint.x - startPoint.x), startPoint.y + percentageIntoFrame * (endPoint.y - startPoint.y));
        return this.point;
    }
}

