/*
 * Decompiled with CFR 0.152.
 */
package com.airbnb.lottie.animation;

import android.graphics.Path;
import android.support.annotation.RestrictTo;
import android.view.animation.Interpolator;
import com.airbnb.lottie.animation.KeyframeAnimation;
import com.airbnb.lottie.model.LottieComposition;
import com.airbnb.lottie.model.ShapeData;
import com.airbnb.lottie.utils.MiscUtils;
import java.util.List;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public class ShapeKeyframeAnimation
extends KeyframeAnimation<Path> {
    private final Path tempPath = new Path();
    private final ShapeData tempShapeData = new ShapeData();
    private final List<ShapeData> shapeData;

    public ShapeKeyframeAnimation(long duration, LottieComposition composition, List<Float> keyTimes, List<ShapeData> shapeData, List<Interpolator> interpolators) {
        super(duration, composition, keyTimes, interpolators);
        this.shapeData = shapeData;
    }

    @Override
    public Path getValue() {
        if (this.progress <= 0.0f) {
            MiscUtils.getPathFromData(this.shapeData.get(0), this.tempPath);
            return this.tempPath;
        }
        if (this.progress >= 1.0f) {
            MiscUtils.getPathFromData(this.shapeData.get(this.shapeData.size() - 1), this.tempPath);
            return this.tempPath;
        }
        int keyframeIndex = this.getKeyframeIndex();
        float startKeytime = ((Float)this.keyTimes.get(keyframeIndex)).floatValue();
        float endKeytime = ((Float)this.keyTimes.get(keyframeIndex + 1)).floatValue();
        float percentageIntoFrame = 0.0f;
        if (!this.isDiscrete) {
            percentageIntoFrame = (this.progress - startKeytime) / (endKeytime - startKeytime);
            if (this.interpolators != null) {
                percentageIntoFrame = ((Interpolator)this.interpolators.get(keyframeIndex)).getInterpolation(percentageIntoFrame);
            }
        }
        ShapeData startShapeData = this.shapeData.get(keyframeIndex);
        ShapeData endShapeData = this.shapeData.get(keyframeIndex + 1);
        this.tempShapeData.interpolateBetween(startShapeData, endShapeData, percentageIntoFrame);
        MiscUtils.getPathFromData(this.tempShapeData, this.tempPath);
        return this.tempPath;
    }
}

