/*
 * Decompiled with CFR 0.152.
 */
package com.airbnb.lottie.layers;

import android.graphics.Bitmap;
import android.graphics.BitmapShader;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffXfermode;
import android.graphics.Shader;
import android.graphics.Xfermode;
import android.graphics.drawable.Drawable;
import android.support.annotation.FloatRange;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.RestrictTo;
import com.airbnb.lottie.animation.KeyframeAnimation;
import com.airbnb.lottie.animation.NumberKeyframeAnimation;
import com.airbnb.lottie.layers.AnimatableLayer;
import com.airbnb.lottie.layers.EllipseShapeLayer;
import com.airbnb.lottie.layers.GroupLayerView;
import com.airbnb.lottie.layers.MaskLayer;
import com.airbnb.lottie.layers.RectLayer;
import com.airbnb.lottie.layers.ShapeLayerView;
import com.airbnb.lottie.model.CircleShape;
import com.airbnb.lottie.model.Layer;
import com.airbnb.lottie.model.LottieComposition;
import com.airbnb.lottie.model.RectangleShape;
import com.airbnb.lottie.model.ShapeFill;
import com.airbnb.lottie.model.ShapeGroup;
import com.airbnb.lottie.model.ShapePath;
import com.airbnb.lottie.model.ShapeStroke;
import com.airbnb.lottie.model.ShapeTransform;
import com.airbnb.lottie.model.ShapeTrimPath;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public class LayerView
extends AnimatableLayer {
    private MaskLayer mask;
    private LayerView matteLayer;
    private final List<LayerView> transformLayers = new ArrayList<LayerView>();
    private final Paint mainCanvasPaint = new Paint();
    @Nullable
    private final Bitmap contentBitmap;
    @Nullable
    private final Bitmap maskBitmap;
    @Nullable
    private final Bitmap matteBitmap;
    @Nullable
    private Canvas contentCanvas;
    @Nullable
    private Canvas maskCanvas;
    @Nullable
    private Canvas matteCanvas;
    private final Paint maskShapePaint = new Paint(1);
    private final Paint maskPaint = new Paint(1);
    private final Paint mattePaint = new Paint(1);
    private final Layer layerModel;
    private final LottieComposition composition;
    @Nullable
    private LayerView parentLayer;

    LayerView(Layer layerModel, LottieComposition composition, Drawable.Callback callback, @Nullable Bitmap mainBitmap, @Nullable Bitmap maskBitmap, @Nullable Bitmap matteBitmap) {
        super(callback);
        this.layerModel = layerModel;
        this.composition = composition;
        this.maskBitmap = maskBitmap;
        this.matteBitmap = matteBitmap;
        this.contentBitmap = mainBitmap;
        this.mattePaint.setXfermode((Xfermode)new PorterDuffXfermode(PorterDuff.Mode.SRC_IN));
        this.setBounds(composition.getBounds());
        if (this.contentBitmap != null) {
            this.contentCanvas = new Canvas(this.contentBitmap);
            if (maskBitmap != null) {
                this.maskPaint.setShader((Shader)new BitmapShader(this.contentBitmap, Shader.TileMode.CLAMP, Shader.TileMode.CLAMP));
            }
        }
        this.setupForModel();
    }

    private void setupForModel() {
        this.setBackgroundColor(this.layerModel.getSolidColor());
        this.setBounds(0, 0, this.layerModel.getSolidWidth(), this.layerModel.getSolidHeight());
        this.setPosition(this.layerModel.getPosition().createAnimation());
        this.setAnchorPoint(this.layerModel.getAnchor().createAnimation());
        this.setTransform(this.layerModel.getScale().createAnimation());
        this.setRotation(this.layerModel.getRotation().createAnimation());
        this.setAlpha(this.layerModel.getOpacity().createAnimation());
        this.setVisible(this.layerModel.hasInAnimation(), false);
        ArrayList<Object> reversedItems = new ArrayList<Object>(this.layerModel.getShapes());
        Collections.reverse(reversedItems);
        ShapeTransform currentTransform = null;
        ShapeTrimPath currentTrimPath = null;
        ShapeFill currentFill = null;
        ShapeStroke currentStroke = null;
        for (int i = 0; i < reversedItems.size(); ++i) {
            AnimatableLayer shapeLayer;
            Object item = reversedItems.get(i);
            if (item instanceof ShapeGroup) {
                GroupLayerView groupLayer = new GroupLayerView((ShapeGroup)item, currentFill, currentStroke, currentTrimPath, currentTransform, this.getCallback());
                this.addLayer(groupLayer);
                continue;
            }
            if (item instanceof ShapeTransform) {
                currentTransform = (ShapeTransform)item;
                continue;
            }
            if (item instanceof ShapeFill) {
                currentFill = (ShapeFill)item;
                continue;
            }
            if (item instanceof ShapeTrimPath) {
                currentTrimPath = (ShapeTrimPath)item;
                continue;
            }
            if (item instanceof ShapeStroke) {
                currentStroke = (ShapeStroke)item;
                continue;
            }
            if (item instanceof ShapePath) {
                ShapePath shapePath = (ShapePath)item;
                shapeLayer = new ShapeLayerView(shapePath, currentFill, currentStroke, currentTrimPath, new ShapeTransform(this.composition), this.getCallback());
                this.addLayer(shapeLayer);
                continue;
            }
            if (item instanceof RectangleShape) {
                RectangleShape shapeRect = (RectangleShape)item;
                shapeLayer = new RectLayer(shapeRect, currentFill, currentStroke, new ShapeTransform(this.composition), this.getCallback());
                this.addLayer(shapeLayer);
                continue;
            }
            if (!(item instanceof CircleShape)) continue;
            CircleShape shapeCircle = (CircleShape)item;
            shapeLayer = new EllipseShapeLayer(shapeCircle, currentFill, currentStroke, currentTrimPath, new ShapeTransform(this.composition), this.getCallback());
            this.addLayer(shapeLayer);
        }
        if (this.maskBitmap != null && this.layerModel.getMasks() != null && !this.layerModel.getMasks().isEmpty()) {
            this.setMask(new MaskLayer(this.layerModel.getMasks(), this.getCallback()));
            this.maskCanvas = new Canvas(this.maskBitmap);
        }
        this.buildAnimations();
    }

    private void buildAnimations() {
        if (this.layerModel.hasInOutAnimation()) {
            NumberKeyframeAnimation<Float> inOutAnimation = new NumberKeyframeAnimation<Float>(this.layerModel.getComposition().getDuration(), this.layerModel.getComposition(), this.layerModel.getInOutKeyTimes(), Float.class, this.layerModel.getInOutKeyFrames(), Collections.emptyList());
            inOutAnimation.setIsDiscrete();
            inOutAnimation.addUpdateListener(new KeyframeAnimation.AnimationListener<Float>(){

                @Override
                public void onValueChanged(Float progress) {
                    LayerView.this.setVisible(progress.floatValue() == 1.0f, false);
                }
            });
            this.setVisible(((Float)inOutAnimation.getValue()).floatValue() == 1.0f, false);
            this.addAnimation(inOutAnimation);
        } else {
            this.setVisible(true, false);
        }
    }

    Layer getLayerModel() {
        return this.layerModel;
    }

    void setParentLayer(@Nullable LayerView parentLayer) {
        this.parentLayer = parentLayer;
    }

    @Nullable
    private LayerView getParentLayer() {
        return this.parentLayer;
    }

    private void setMask(MaskLayer mask) {
        this.mask = mask;
        for (KeyframeAnimation<Path> animation : mask.getMasks()) {
            this.addAnimation(animation);
            animation.addUpdateListener(new KeyframeAnimation.AnimationListener<Path>(){

                @Override
                public void onValueChanged(Path progress) {
                    LayerView.this.invalidateSelf();
                }
            });
        }
    }

    void setMatteLayer(LayerView matteLayer) {
        if (this.matteBitmap == null) {
            throw new IllegalArgumentException("Cannot set a matte if no matte bitmap was given!");
        }
        this.matteLayer = matteLayer;
        this.matteCanvas = new Canvas(this.matteBitmap);
    }

    @Override
    public void draw(@NonNull Canvas mainCanvas) {
        Bitmap mainBitmap;
        if (this.contentBitmap != null) {
            if (this.contentBitmap.isRecycled()) {
                return;
            }
            this.contentBitmap.eraseColor(0);
        }
        if (this.maskBitmap != null) {
            this.maskBitmap.eraseColor(0);
        }
        if (this.matteBitmap != null) {
            this.matteBitmap.eraseColor(0);
        }
        if (!this.isVisible() || this.mainCanvasPaint.getAlpha() == 0) {
            return;
        }
        this.transformLayers.clear();
        for (LayerView parent = this.parentLayer; parent != null; parent = parent.getParentLayer()) {
            this.transformLayers.add(parent);
        }
        Collections.reverse(this.transformLayers);
        if (this.contentCanvas == null || this.contentBitmap == null) {
            int mainCanvasCount = this.saveCanvas(mainCanvas);
            for (LayerView layer : this.transformLayers) {
                this.applyTransformForLayer(mainCanvas, layer);
            }
            super.draw(mainCanvas);
            mainCanvas.restoreToCount(mainCanvasCount);
            return;
        }
        int contentCanvasCount = this.saveCanvas(this.contentCanvas);
        int maskCanvasCount = this.saveCanvas(this.maskCanvas);
        for (LayerView layer : this.transformLayers) {
            this.applyTransformForLayer(this.contentCanvas, layer);
            this.applyTransformForLayer(this.maskCanvas, layer);
        }
        this.applyTransformForLayer(this.maskCanvas, this);
        super.draw(this.contentCanvas);
        if (this.hasMasks()) {
            for (int i = 0; i < this.mask.getMasks().size(); ++i) {
                Path path = this.mask.getMasks().get(i).getValue();
                this.maskCanvas.drawPath(path, this.maskShapePaint);
            }
            if (!this.hasMattes()) {
                mainCanvas.drawBitmap(this.maskBitmap, 0.0f, 0.0f, this.maskPaint);
            }
            mainBitmap = this.maskBitmap;
        } else {
            if (!this.hasMattes()) {
                mainCanvas.drawBitmap(this.contentBitmap, 0.0f, 0.0f, this.mainCanvasPaint);
            }
            mainBitmap = this.contentBitmap;
        }
        this.restoreCanvas(this.contentCanvas, contentCanvasCount);
        this.restoreCanvas(this.maskCanvas, maskCanvasCount);
        if (this.hasMattes()) {
            this.matteLayer.draw(this.matteCanvas);
            this.matteCanvas.drawBitmap(mainBitmap, 0.0f, 0.0f, this.mattePaint);
            mainCanvas.drawBitmap(this.matteBitmap, 0.0f, 0.0f, this.mainCanvasPaint);
        }
    }

    private boolean hasMattes() {
        return this.matteCanvas != null && this.matteBitmap != null && this.matteLayer != null;
    }

    private boolean hasMasks() {
        return this.maskBitmap != null && this.maskCanvas != null && this.mask != null && !this.mask.getMasks().isEmpty();
    }

    @Override
    public void setProgress(@FloatRange(from=0.0, to=1.0) float progress) {
        super.setProgress(progress);
        if (this.matteLayer != null) {
            this.matteLayer.setProgress(progress);
        }
    }

    public long getId() {
        return this.layerModel.getId();
    }
}

