/*
 * Decompiled with CFR 0.152.
 */
package com.airbnb.lottie.model;

import android.support.annotation.RestrictTo;
import com.airbnb.lottie.animatable.AnimatablePathValue;
import com.airbnb.lottie.animatable.AnimatablePointValue;
import com.airbnb.lottie.model.LottieComposition;
import org.json.JSONException;
import org.json.JSONObject;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public class CircleShape {
    private final AnimatablePathValue position;
    private final AnimatablePointValue size;

    CircleShape(JSONObject json, int frameRate, LottieComposition composition) {
        try {
            this.position = new AnimatablePathValue(json.getJSONObject("p"), frameRate, composition);
            this.size = new AnimatablePointValue(json.getJSONObject("s"), frameRate, composition);
        }
        catch (JSONException e) {
            throw new IllegalArgumentException("Unable to parse circle " + json, e);
        }
    }

    public AnimatablePathValue getPosition() {
        return this.position;
    }

    public AnimatablePointValue getSize() {
        return this.size;
    }
}

