/*
 * Decompiled with CFR 0.152.
 */
package com.airbnb.lottie.model;

import android.graphics.Rect;
import android.support.annotation.RestrictTo;
import com.airbnb.lottie.animatable.AnimatableFloatValue;
import com.airbnb.lottie.animatable.AnimatableIntegerValue;
import com.airbnb.lottie.animatable.AnimatablePathValue;
import com.airbnb.lottie.animatable.AnimatableScaleValue;
import com.airbnb.lottie.model.LottieComposition;
import com.airbnb.lottie.model.Transform;
import org.json.JSONException;
import org.json.JSONObject;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public class ShapeTransform
implements Transform {
    private static final String TAG = ShapeTransform.class.getSimpleName();
    private final Rect compBounds;
    private final AnimatablePathValue position;
    private final AnimatablePathValue anchor;
    private final AnimatableScaleValue scale;
    private final AnimatableFloatValue rotation;
    private final AnimatableIntegerValue opacity;

    public ShapeTransform(LottieComposition composition) {
        this.compBounds = composition.getBounds();
        this.position = new AnimatablePathValue(composition);
        this.anchor = new AnimatablePathValue(composition);
        this.scale = new AnimatableScaleValue(composition);
        this.rotation = new AnimatableFloatValue(composition, Float.valueOf(0.0f));
        this.opacity = new AnimatableIntegerValue(composition, 255);
    }

    ShapeTransform(JSONObject json, int frameRate, LottieComposition composition) {
        JSONObject jsonOpacity;
        JSONObject jsonRotation;
        JSONObject jsonScale;
        JSONObject jsonAnchor;
        JSONObject jsonPosition;
        this.compBounds = composition.getBounds();
        try {
            jsonPosition = json.getJSONObject("p");
        }
        catch (JSONException e) {
            throw new IllegalStateException("Transform has no position.");
        }
        this.position = new AnimatablePathValue(jsonPosition, frameRate, composition);
        try {
            jsonAnchor = json.getJSONObject("a");
        }
        catch (JSONException e) {
            throw new IllegalStateException("Transform has no anchor.");
        }
        this.anchor = new AnimatablePathValue(jsonAnchor, frameRate, composition);
        try {
            jsonScale = json.getJSONObject("s");
        }
        catch (JSONException e) {
            throw new IllegalStateException("Transform has no scale.");
        }
        this.scale = new AnimatableScaleValue(jsonScale, frameRate, composition, false);
        try {
            jsonRotation = json.getJSONObject("r");
        }
        catch (JSONException e) {
            throw new IllegalStateException("Transform has no rotation.");
        }
        this.rotation = new AnimatableFloatValue(jsonRotation, frameRate, composition, false);
        try {
            jsonOpacity = json.getJSONObject("o");
        }
        catch (JSONException e) {
            throw new IllegalStateException("Transform has no opacity.");
        }
        this.opacity = new AnimatableIntegerValue(jsonOpacity, frameRate, composition, false, true);
    }

    @Override
    public Rect getBounds() {
        return this.compBounds;
    }

    @Override
    public AnimatablePathValue getPosition() {
        return this.position;
    }

    @Override
    public AnimatablePathValue getAnchor() {
        return this.anchor;
    }

    @Override
    public AnimatableScaleValue getScale() {
        return this.scale;
    }

    @Override
    public AnimatableFloatValue getRotation() {
        return this.rotation;
    }

    @Override
    public AnimatableIntegerValue getOpacity() {
        return this.opacity;
    }

    public String toString() {
        return "ShapeTransform{anchor=" + this.anchor.toString() + ", compBounds=" + this.compBounds + ", position=" + this.position.toString() + ", scale=" + this.scale.toString() + ", rotation=" + this.rotation.getInitialValue() + ", opacity=" + this.opacity.getInitialValue() + '}';
    }
}

