/*
 * Decompiled with CFR 0.152.
 */
package com.airbnb.lottie;

import com.airbnb.lottie.BaseAnimatableValue;
import com.airbnb.lottie.FloatKeyframeAnimation;
import com.airbnb.lottie.JsonUtils;
import com.airbnb.lottie.KeyframeAnimation;
import com.airbnb.lottie.LottieComposition;
import com.airbnb.lottie.StaticKeyframeAnimation;
import org.json.JSONObject;

class AnimatableFloatValue
extends BaseAnimatableValue<Float, Float> {
    AnimatableFloatValue(LottieComposition composition, Float initialValue) {
        super(composition);
        this.initialValue = initialValue;
    }

    AnimatableFloatValue(JSONObject json, LottieComposition composition) {
        this(json, composition, true);
    }

    AnimatableFloatValue(JSONObject json, LottieComposition composition, boolean isDp) {
        super(json, composition, isDp);
    }

    @Override
    public Float valueFromObject(Object object, float scale) {
        return Float.valueOf(JsonUtils.valueFromObject(object) * scale);
    }

    public KeyframeAnimation<Float> createAnimation() {
        if (!this.hasAnimation()) {
            return new StaticKeyframeAnimation<Object>(this.initialValue);
        }
        return new FloatKeyframeAnimation(this.keyframes);
    }

    @Override
    public Float getInitialValue() {
        return (Float)this.initialValue;
    }
}

