/*
 * Decompiled with CFR 0.152.
 */
package com.airbnb.lottie;

import com.airbnb.lottie.BaseAnimatableValue;
import com.airbnb.lottie.IntegerKeyframeAnimation;
import com.airbnb.lottie.JsonUtils;
import com.airbnb.lottie.Keyframe;
import com.airbnb.lottie.KeyframeAnimation;
import com.airbnb.lottie.LottieComposition;
import com.airbnb.lottie.StaticKeyframeAnimation;
import org.json.JSONObject;

class AnimatableIntegerValue
extends BaseAnimatableValue<Integer, Integer> {
    AnimatableIntegerValue(LottieComposition composition, Integer initialValue) {
        super(composition);
        this.initialValue = initialValue;
    }

    AnimatableIntegerValue(JSONObject json, LottieComposition composition, boolean isDp, boolean remap100To255) {
        super(json, composition, isDp);
        if (remap100To255) {
            this.initialValue = (Integer)this.initialValue * 255 / 100;
            for (int i = 0; i < this.keyframes.size(); ++i) {
                Keyframe keyframe = (Keyframe)this.keyframes.get(i);
                keyframe.startValue = (Integer)keyframe.startValue * 255 / 100;
                keyframe.endValue = (Integer)keyframe.endValue * 255 / 100;
            }
        }
    }

    @Override
    public Integer valueFromObject(Object object, float scale) {
        return Math.round(JsonUtils.valueFromObject(object) * scale);
    }

    public KeyframeAnimation<Integer> createAnimation() {
        if (!this.hasAnimation()) {
            return new StaticKeyframeAnimation<Object>(this.initialValue);
        }
        return new IntegerKeyframeAnimation(this.keyframes);
    }

    @Override
    public Integer getInitialValue() {
        return (Integer)this.initialValue;
    }
}

