/*
 * Decompiled with CFR 0.152.
 */
package com.airbnb.lottie;

import android.graphics.PointF;
import com.airbnb.lottie.AnimatableFloatValue;
import com.airbnb.lottie.AnimatableSplitDimensionPathValue;
import com.airbnb.lottie.BaseKeyframeAnimation;
import com.airbnb.lottie.IAnimatablePathValue;
import com.airbnb.lottie.JsonUtils;
import com.airbnb.lottie.Keyframe;
import com.airbnb.lottie.LottieComposition;
import com.airbnb.lottie.PathKeyframe;
import com.airbnb.lottie.PathKeyframeAnimation;
import com.airbnb.lottie.StaticKeyframeAnimation;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONObject;

class AnimatablePathValue
implements IAnimatablePathValue {
    private final List<PathKeyframe> keyframes = new ArrayList<PathKeyframe>();
    private PointF initialPoint;

    static IAnimatablePathValue createAnimatablePathOrSplitDimensionPath(JSONObject json, LottieComposition composition) {
        if (json.has("k")) {
            return new AnimatablePathValue(json.opt("k"), composition);
        }
        return new AnimatableSplitDimensionPathValue(new AnimatableFloatValue(json.optJSONObject("x"), composition), new AnimatableFloatValue(json.optJSONObject("y"), composition));
    }

    AnimatablePathValue() {
        this.initialPoint = new PointF(0.0f, 0.0f);
    }

    AnimatablePathValue(Object json, LottieComposition composition) {
        if (this.hasKeyframes(json)) {
            JSONArray jsonArray = (JSONArray)json;
            for (int i = 0; i < jsonArray.length(); ++i) {
                JSONObject jsonKeyframe = jsonArray.optJSONObject(i);
                PathKeyframe keyframe = new PathKeyframe(jsonKeyframe, composition, this);
                this.keyframes.add(keyframe);
            }
            Keyframe.setEndFrames(this.keyframes);
        } else {
            this.initialPoint = JsonUtils.pointFromJsonArray((JSONArray)json, composition.getScale());
        }
    }

    private boolean hasKeyframes(Object json) {
        if (!(json instanceof JSONArray)) {
            return false;
        }
        Object firstObject = ((JSONArray)json).opt(0);
        return firstObject instanceof JSONObject && ((JSONObject)firstObject).has("t");
    }

    @Override
    public PointF valueFromObject(Object object, float scale) {
        return JsonUtils.pointFromJsonArray((JSONArray)object, scale);
    }

    @Override
    public BaseKeyframeAnimation<?, PointF> createAnimation() {
        if (!this.hasAnimation()) {
            return new StaticKeyframeAnimation<PointF>(this.initialPoint);
        }
        return new PathKeyframeAnimation((List<? extends Keyframe<PointF>>)this.keyframes);
    }

    @Override
    public boolean hasAnimation() {
        return !this.keyframes.isEmpty();
    }

    @Override
    public PointF getInitialPoint() {
        return this.initialPoint;
    }

    public String toString() {
        return "initialPoint=" + this.initialPoint;
    }
}

