/*
 * Decompiled with CFR 0.152.
 */
package com.airbnb.lottie;

import android.graphics.PointF;
import com.airbnb.lottie.BaseAnimatableValue;
import com.airbnb.lottie.JsonUtils;
import com.airbnb.lottie.KeyframeAnimation;
import com.airbnb.lottie.LottieComposition;
import com.airbnb.lottie.PointKeyframeAnimation;
import com.airbnb.lottie.StaticKeyframeAnimation;
import org.json.JSONArray;
import org.json.JSONObject;

class AnimatablePointValue
extends BaseAnimatableValue<PointF, PointF> {
    AnimatablePointValue(JSONObject pointValues, LottieComposition composition) {
        super(pointValues, composition, true);
    }

    @Override
    public PointF valueFromObject(Object object, float scale) {
        if (object instanceof JSONArray) {
            return JsonUtils.pointFromJsonArray((JSONArray)object, scale);
        }
        if (object instanceof JSONObject) {
            return JsonUtils.pointFromJsonObject((JSONObject)object, scale);
        }
        throw new IllegalArgumentException("Unable to parse point from " + object);
    }

    public KeyframeAnimation<PointF> createAnimation() {
        if (!this.hasAnimation()) {
            return new StaticKeyframeAnimation<Object>(this.initialValue);
        }
        return new PointKeyframeAnimation(this.keyframes);
    }
}

