/*
 * Decompiled with CFR 0.152.
 */
package com.airbnb.lottie;

import android.support.annotation.Nullable;
import com.airbnb.lottie.AnimatableValue;
import com.airbnb.lottie.BaseKeyframeAnimation;
import com.airbnb.lottie.Keyframe;
import com.airbnb.lottie.LottieComposition;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONObject;

abstract class BaseAnimatableValue<V, O>
implements AnimatableValue<V, O> {
    List<Keyframe<V>> keyframes = Collections.emptyList();
    final LottieComposition composition;
    private final boolean isDp;
    V initialValue;

    BaseAnimatableValue(LottieComposition composition) {
        this.composition = composition;
        this.isDp = false;
    }

    BaseAnimatableValue(@Nullable JSONObject json, LottieComposition composition, boolean isDp) {
        this.composition = composition;
        this.isDp = isDp;
        if (json != null) {
            Object k = json.opt("k");
            if (this.hasKeyframes(k)) {
                this.keyframes = Keyframe.parseKeyframes((JSONArray)k, composition, this.getScale(), this);
                if (!this.keyframes.isEmpty()) {
                    this.initialValue = this.keyframes.get((int)0).startValue;
                }
            } else {
                this.initialValue = this.valueFromObject(k, this.getScale());
            }
            if (this.keyframes == null) {
                this.keyframes = Collections.emptyList();
            }
        }
    }

    private boolean hasKeyframes(Object json) {
        if (!(json instanceof JSONArray)) {
            return false;
        }
        Object firstObject = ((JSONArray)json).opt(0);
        return firstObject instanceof JSONObject && ((JSONObject)firstObject).has("t");
    }

    private float getScale() {
        return this.isDp ? this.composition.getScale() : 1.0f;
    }

    O convertType(V value) {
        return (O)value;
    }

    @Override
    public boolean hasAnimation() {
        return !this.keyframes.isEmpty();
    }

    public O getInitialValue() {
        return this.convertType(this.initialValue);
    }

    @Override
    public abstract BaseKeyframeAnimation<?, O> createAnimation();

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("initialValue=").append(this.initialValue);
        if (!this.keyframes.isEmpty()) {
            sb.append(", values=").append(Arrays.toString(this.keyframes.toArray()));
        }
        return sb.toString();
    }
}

