/*
 * Decompiled with CFR 0.152.
 */
package com.airbnb.lottie;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.drawable.Drawable;
import android.text.TextUtils;
import android.util.Log;
import android.view.View;
import com.airbnb.lottie.ImageAsset;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import junit.framework.Assert;

class ImageAssetBitmapManager {
    private final Context context;
    private String imagesFolder;
    private final Map<String, ImageAsset> imageAssets;
    private final Map<String, Bitmap> bitmaps = new HashMap<String, Bitmap>();

    ImageAssetBitmapManager(Drawable.Callback callback, String imagesFolder, Map<String, ImageAsset> imageAssets) {
        Assert.assertNotNull((Object)callback);
        this.imagesFolder = imagesFolder;
        if (this.imagesFolder.charAt(this.imagesFolder.length() - 1) != '/') {
            this.imagesFolder = this.imagesFolder + '/';
        }
        if (!(callback instanceof View)) {
            Log.w((String)"LOTTIE", (String)"LottieDrawable must be inside of a view for images to work.");
            this.imageAssets = new HashMap<String, ImageAsset>();
            this.context = null;
            return;
        }
        this.context = ((View)callback).getContext();
        this.imageAssets = imageAssets;
    }

    Bitmap bitmapForId(String id) {
        Bitmap bitmap = this.bitmaps.get(id);
        if (bitmap == null) {
            ImageAsset imageAsset = this.imageAssets.get(id);
            if (imageAsset == null) {
                return null;
            }
            try {
                if (TextUtils.isEmpty((CharSequence)this.imagesFolder)) {
                    throw new IllegalStateException("You must set an images folder before loading an image. Set it with LottieComposition#setImagesFolder or LottieDrawable#setImagesFolder");
                }
                InputStream is = this.context.getAssets().open(this.imagesFolder + imageAsset.getFileName());
                bitmap = BitmapFactory.decodeStream((InputStream)is);
                this.bitmaps.put(id, bitmap);
            }
            catch (IOException e) {
                Log.w((String)"LOTTIE", (String)"Unable to open asset.", (Throwable)e);
            }
        }
        return bitmap;
    }

    void recycleBitmaps() {
        for (String key : this.bitmaps.keySet()) {
            Bitmap bitmap = this.bitmaps.remove(key);
            bitmap.recycle();
        }
    }

    boolean hasSameContext(Context context) {
        return context == null && this.context == null || context != null && this.context.equals(context);
    }
}

